/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="FieldCanBeFinal", summary="This field is only assigned during initialization; consider making it final", severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class FieldCanBeFinal
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableSet<String> IMPLICIT_VAR_ANNOTATIONS = ImmutableSet.of((Object)"javax.inject.Inject", (Object)"com.google.inject.Inject", (Object)"com.google.inject.testing.fieldbinder.Bind", (Object)"com.googlecode.objectify.v5.annotation.Collection", (Object)"com.googlecode.objectify.v5.annotation.Id", (Object)"com.googlecode.objectify.v5.annotation.Index", (Object[])new String[]{"com.googlecode.objectify.v5.annotation.Parent", "com.googlecode.objectify.v5.annotation.Subclass", "com.google.errorprone.annotations.Var", "com.google.common.annotations.NonFinalForGwt", "org.kohsuke.args4j.Argument", "org.kohsuke.args4j.Option", "org.mockito.Spy", "javax.jdo.annotations.Persistent", "javax.xml.bind.annotation.XmlAttribute", "com.google.gwt.uibinder.client.UiField", "com.beust.jcommander.Parameter", "javax.persistence.Id"});
    private static final ImmutableSet<String> IMPLICIT_VAR_CLASS_ANNOTATIONS = ImmutableSet.of((Object)"com.googlecode.objectify.v4.annotation.Entity", (Object)"com.googlecode.objectify.v4.annotation.Embed", (Object)"com.googlecode.objectify.v5.annotation.Entity", (Object)"com.googlecode.objectify.v5.annotation.Embed");
    private static final ImmutableSet<String> IMPLICIT_VAR_ANNOTATION_SIMPLE_NAMES = ImmutableSet.of((Object)"NonFinalForTesting", (Object)"NotFinalForTesting");
    private static final EnumSet<Tree.Kind> UNARY_ASSIGNMENT = EnumSet.of(Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_INCREMENT);

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        VariableAssignmentRecords writes = new VariableAssignmentRecords();
        new FinalScanner(writes, state.context).scan(state.getPath(), InitializationContext.NONE);
        block0: for (VariableAssignments var : writes.getAssignments()) {
            if (!var.isEffectivelyFinal() || !var.sym.isPrivate()) continue;
            for (String annotation : IMPLICIT_VAR_ANNOTATIONS) {
                if (!ASTHelpers.hasAnnotation((Symbol)var.sym, (String)annotation, (VisitorState)state)) continue;
                continue block0;
            }
            VariableTree varDecl = var.declaration();
            for (AnnotationTree anno : varDecl.getModifiers().getAnnotations()) {
                if (!IMPLICIT_VAR_ANNOTATION_SIMPLE_NAMES.contains((Object)ASTHelpers.getAnnotationName((AnnotationTree)anno))) continue;
                return Description.NO_MATCH;
            }
            SuggestedFixes.addModifiers((Tree)varDecl, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).ifPresent(f -> {
                if (SuggestedFixes.compilesWithFix((Fix)f, (VisitorState)state)) {
                    state.reportMatch(this.describeMatch(varDecl, (Fix)f));
                }
            });
        }
        return Description.NO_MATCH;
    }

    private class FinalScanner
    extends TreePathScanner<Void, InitializationContext> {
        private final VariableAssignmentRecords writes;
        private final Context context;

        public FinalScanner(VariableAssignmentRecords writes, Context context) {
            this.writes = writes;
            this.context = context;
        }

        @Override
        public Void visitVariable(VariableTree node, InitializationContext init) {
            Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)node);
            if (sym.getKind() == ElementKind.FIELD && !FieldCanBeFinal.this.isSuppressed(node)) {
                this.writes.recordDeclaration(sym, node);
            }
            return (Void)super.visitVariable(node, InitializationContext.NONE);
        }

        @Override
        public Void visitBlock(BlockTree node, InitializationContext init) {
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.CLASS) {
                init = node.isStatic() ? InitializationContext.STATIC : InitializationContext.INSTANCE;
            }
            return (Void)super.visitBlock(node, init);
        }

        @Override
        public Void visitMethod(MethodTree node, InitializationContext init) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)node);
            if (sym != null && sym.isConstructor()) {
                init = InitializationContext.INSTANCE;
            }
            return (Void)super.visitMethod(node, init);
        }

        @Override
        public Void visitAssignment(AssignmentTree node, InitializationContext init) {
            if (init == InitializationContext.INSTANCE && !this.isThisAccess(node.getVariable())) {
                init = InitializationContext.NONE;
            }
            this.writes.recordAssignment(node.getVariable(), init);
            return (Void)super.visitAssignment(node, init);
        }

        boolean isThisAccess(Tree tree) {
            if (tree.getKind() == Tree.Kind.IDENTIFIER) {
                return true;
            }
            if (tree.getKind() != Tree.Kind.MEMBER_SELECT) {
                return false;
            }
            ExpressionTree selected = ((MemberSelectTree)tree).getExpression();
            if (!(selected instanceof IdentifierTree)) {
                return false;
            }
            IdentifierTree ident = (IdentifierTree)selected;
            return ident.getName().contentEquals("this");
        }

        @Override
        public Void visitClass(ClassTree node, InitializationContext init) {
            VisitorState state = new VisitorState(this.context).withPath(this.getCurrentPath());
            if (FieldCanBeFinal.this.isSuppressed(node)) {
                return null;
            }
            for (String annotation : IMPLICIT_VAR_CLASS_ANNOTATIONS) {
                if (!ASTHelpers.hasAnnotation((Symbol)ASTHelpers.getSymbol((ClassTree)node), (String)annotation, (VisitorState)state)) continue;
                return null;
            }
            return (Void)super.visitClass(node, InitializationContext.NONE);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, InitializationContext init) {
            init = InitializationContext.NONE;
            this.writes.recordAssignment(node.getVariable(), init);
            return (Void)super.visitCompoundAssignment(node, init);
        }

        @Override
        public Void visitUnary(UnaryTree node, InitializationContext init) {
            if (UNARY_ASSIGNMENT.contains((Object)node.getKind())) {
                init = InitializationContext.NONE;
                this.writes.recordAssignment(node.getExpression(), init);
            }
            return (Void)super.visitUnary(node, init);
        }
    }

    static class VariableAssignments {
        final Symbol.VarSymbol sym;
        final EnumSet<InitializationContext> writes = EnumSet.noneOf(InitializationContext.class);
        VariableTree declaration;

        VariableAssignments(Symbol.VarSymbol sym) {
            this.sym = sym;
        }

        public void recordAssignment(InitializationContext init) {
            this.writes.add(init);
        }

        public void recordDeclaration(VariableTree tree) {
            this.declaration = tree;
        }

        boolean isEffectivelyFinal() {
            InitializationContext other;
            InitializationContext wanted;
            if (this.declaration == null) {
                return false;
            }
            if (this.sym.getModifiers().contains((Object)Modifier.FINAL)) {
                return false;
            }
            if (this.writes.contains((Object)InitializationContext.NONE)) {
                return false;
            }
            if (this.sym.isStatic()) {
                wanted = InitializationContext.STATIC;
                other = InitializationContext.INSTANCE;
            } else {
                wanted = InitializationContext.INSTANCE;
                other = InitializationContext.STATIC;
            }
            if (this.writes.contains((Object)other)) {
                return false;
            }
            return this.writes.contains((Object)wanted) || (this.sym.flags() & 0x40000L) == 262144L;
        }

        VariableTree declaration() {
            return this.declaration;
        }
    }

    static class VariableAssignmentRecords {
        private final Map<Symbol.VarSymbol, VariableAssignments> assignments = new LinkedHashMap<Symbol.VarSymbol, VariableAssignments>();

        VariableAssignmentRecords() {
        }

        public Iterable<VariableAssignments> getAssignments() {
            return this.assignments.values();
        }

        public void recordAssignment(Tree tree, InitializationContext init) {
            Symbol sym = ASTHelpers.getSymbol((Tree)tree);
            if (sym != null && sym.getKind() == ElementKind.FIELD) {
                this.recordAssignment((Symbol.VarSymbol)sym, init);
            }
        }

        public void recordAssignment(Symbol.VarSymbol sym, InitializationContext init) {
            this.getDeclaration(sym).recordAssignment(init);
        }

        private VariableAssignments getDeclaration(Symbol.VarSymbol sym) {
            VariableAssignments info = this.assignments.computeIfAbsent(sym, k -> new VariableAssignments((Symbol.VarSymbol)k));
            return info;
        }

        public void recordDeclaration(Symbol.VarSymbol sym, VariableTree tree) {
            this.getDeclaration(sym).recordDeclaration(tree);
        }
    }

    static enum InitializationContext {
        STATIC,
        INSTANCE,
        NONE;

    }
}

