/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import java.util.List;

@BugPattern(name="ModifyCollectionInEnhancedForLoop", summary="Modifying a collection while iterating over it in a loop may cause a ConcurrentModificationException to be thrown.", severity=BugPattern.SeverityLevel.WARNING)
public class ModifyCollectionInEnhancedForLoop
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").namedAnyOf(new String[]{"add", "addAll", "clear", "remove", "removeAll", "retainAll"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (state.getTypes().closure((Type)ASTHelpers.getSymbol((MethodInvocationTree)tree).enclClass().asType()).stream().anyMatch(s -> s.asElement().packge().getQualifiedName().toString().startsWith("java.util.concurrent"))) {
            return Description.NO_MATCH;
        }
        if (ModifyCollectionInEnhancedForLoop.blockEndsInBreakOrReturn(state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree collection = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (collection == null) {
            return Description.NO_MATCH;
        }
        if (!ModifyCollectionInEnhancedForLoop.enclosingLoop(state.getPath(), collection)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean blockEndsInBreakOrReturn(VisitorState state) {
        TreePath statementPath = state.findPathToEnclosing(new Class[]{StatementTree.class});
        if (statementPath == null) {
            return false;
        }
        Tree parent = statementPath.getParentPath().getLeaf();
        if (!(parent instanceof BlockTree)) {
            return false;
        }
        StatementTree statement = (StatementTree)statementPath.getLeaf();
        List<? extends StatementTree> statements = ((BlockTree)parent).getStatements();
        int idx = statements.indexOf(statement);
        if (idx == -1 || idx == statements.size()) {
            return false;
        }
        switch (((StatementTree)Iterables.getLast(statements)).getKind()) {
            case BREAK: 
            case RETURN: {
                return true;
            }
        }
        return false;
    }

    static boolean enclosingLoop(TreePath path, ExpressionTree collection) {
        for (Tree node : path) {
            switch (node.getKind()) {
                case METHOD: 
                case CLASS: 
                case LAMBDA_EXPRESSION: {
                    return false;
                }
                case ENHANCED_FOR_LOOP: {
                    if (!ASTHelpers.sameVariable((ExpressionTree)collection, (ExpressionTree)((EnhancedForLoopTree)node).getExpression())) break;
                    return true;
                }
            }
        }
        return false;
    }
}

