/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreeScanner;
import java.util.Iterator;

@BugPattern(name="OptionalNotPresent", summary="One should not call optional.get() inside an if statement that checks !optional.isPresent", severity=BugPattern.SeverityLevel.WARNING)
public class OptionalNotPresent
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final MethodMatchers.MethodNameMatcher GOOGLE_OPTIONAL_PRESENT = Matchers.instanceMethod().onDescendantOf(Optional.class.getName()).named("isPresent");
    private static final MethodMatchers.MethodNameMatcher OPTIONAL_PRESENT = Matchers.instanceMethod().onDescendantOf("java.util.Optional").named("isPresent");

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState visitorState) {
        if (GOOGLE_OPTIONAL_PRESENT.matches((Tree)methodInvocationTree, visitorState) || OPTIONAL_PRESENT.matches((Tree)methodInvocationTree, visitorState)) {
            ExpressionTree optionalVar = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
            Iterator<Tree> iter = visitorState.getPath().iterator();
            iter.next();
            Tree upTree = iter.next();
            if (!(upTree instanceof UnaryTree) || upTree.getKind() != Tree.Kind.LOGICAL_COMPLEMENT) {
                return Description.NO_MATCH;
            }
            IfTree ifTree = null;
            if ((ifTree = OptionalNotPresent.possibleIf(ifTree, upTree, iter)) == null) {
                return Description.NO_MATCH;
            }
            TreeScannerInside treeScannerInside = new TreeScannerInside();
            treeScannerInside.scan(ifTree.getThenStatement(), optionalVar);
            if (treeScannerInside.hasGet && !treeScannerInside.hasAssignment) {
                return this.describeMatch(methodInvocationTree);
            }
        }
        return Description.NO_MATCH;
    }

    private static IfTree possibleIf(IfTree ifTree, Tree upTree, Iterator<Tree> iter) {
        while (iter.hasNext()) {
            if (upTree instanceof BlockTree) {
                return null;
            }
            if (upTree instanceof BinaryTree && upTree.getKind() == Tree.Kind.CONDITIONAL_OR) {
                return null;
            }
            if (upTree instanceof IfTree) {
                ifTree = (IfTree)upTree;
                break;
            }
            upTree = iter.next();
        }
        return ifTree;
    }

    private static class TreeScannerInside
    extends TreeScanner<Void, ExpressionTree> {
        private boolean hasGet = false;
        private boolean hasAssignment = false;

        private TreeScannerInside() {
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, ExpressionTree optionalVar) {
            ExpressionTree treeIdent;
            ExpressionTree receiver;
            if (tree.getArguments().stream().anyMatch(m -> ASTHelpers.sameVariable((ExpressionTree)m, (ExpressionTree)optionalVar))) {
                this.hasAssignment = true;
            }
            if ((receiver = ASTHelpers.getReceiver((ExpressionTree)tree)) != null && ASTHelpers.sameVariable((ExpressionTree)receiver, (ExpressionTree)optionalVar) && (treeIdent = tree.getMethodSelect()) instanceof MemberSelectTree && ((MemberSelectTree)treeIdent).getIdentifier().contentEquals("get")) {
                this.hasGet = true;
            }
            return (Void)super.visitMethodInvocation(tree, optionalVar);
        }

        @Override
        public Void visitAssignment(AssignmentTree assignmentTree, ExpressionTree optionalVar) {
            if (ASTHelpers.sameVariable((ExpressionTree)assignmentTree.getVariable(), (ExpressionTree)optionalVar)) {
                this.hasAssignment = true;
            }
            return (Void)super.visitAssignment(assignmentTree, optionalVar);
        }
    }
}

