/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.AnnotationMatcherUtils;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;

@BugPattern(name="ProvidesFix", summary="BugChecker has incorrect ProvidesFix tag, please update", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ProvidesFixChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> IS_BUGCHECKER = Matchers.isSubtypeOf((String)"com.google.errorprone.bugpatterns.BugChecker");
    private static final Matcher<MethodInvocationTree> DESCRIPTION_WITH_FIX = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.errorprone.matchers.Description.Builder").namedAnyOf(new String[]{"addFix", "addAllFixes"}), MethodMatchers.instanceMethod().onDescendantOf("com.google.errorprone.bugpatterns.BugChecker").named("describeMatch").withParameters(new String[]{"com.sun.source.tree.Tree", "com.google.errorprone.fixes.Fix"})});
    private static final Matcher<ExpressionTree> DESCRIPTION_CONSTRUCTOR = Matchers.constructor().forClass("com.google.errorprone.matchers.Description").withParameters(new String[]{"com.sun.source.tree.Tree", "java.lang.String", "com.google.errorprone.fixes.Fix", "com.google.errorprone.BugPattern.SeverityLevel"});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!IS_BUGCHECKER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        AnnotationTree bugPatternAnnotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"BugPattern");
        if (bugPatternAnnotation == null) {
            return Description.NO_MATCH;
        }
        if (!ProvidesFixChecker.providesFix(tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder().addImport("com.google.errorprone.BugPattern.ProvidesFix");
        ExpressionTree providesFixArgument = AnnotationMatcherUtils.getArgument((AnnotationTree)bugPatternAnnotation, (String)"providesFix");
        if (providesFixArgument == null) {
            fixBuilder.postfixWith((Tree)Iterables.getLast(bugPatternAnnotation.getArguments()), ", providesFix = ProvidesFix." + BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION.name());
        } else {
            if (!ASTHelpers.getSymbol((Tree)providesFixArgument).getSimpleName().contentEquals(BugPattern.ProvidesFix.NO_FIX.name())) {
                return Description.NO_MATCH;
            }
            fixBuilder.replace((Tree)providesFixArgument, "ProvidesFix." + BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION.name());
        }
        return this.describeMatch(bugPatternAnnotation, (Fix)fixBuilder.build());
    }

    private static boolean providesFix(Tree tree, final VisitorState state) {
        return tree.accept(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree callTree, Void unused) {
                return (Boolean)super.visitMethodInvocation(callTree, unused) != false || DESCRIPTION_WITH_FIX.matches((Tree)callTree, state);
            }

            @Override
            public Boolean visitNewClass(NewClassTree constructorTree, Void unused) {
                return (Boolean)super.visitNewClass(constructorTree, unused) != false || DESCRIPTION_CONSTRUCTOR.matches((Tree)constructorTree, state);
            }

            @Override
            public Boolean reduce(Boolean m1, Boolean m2) {
                return (Boolean)MoreObjects.firstNonNull((Object)m1, (Object)false) != false || (Boolean)MoreObjects.firstNonNull((Object)m2, (Object)false) != false;
            }
        }, null);
    }
}

