/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Objects;

@BugPattern(name="StaticQualifiedUsingExpression", summary="A static variable or method should be qualified with a class name, not expression", severity=BugPattern.SeverityLevel.WARNING, altNames={"static", "static-access", "StaticAccessedFromInstance"}, generateExamplesFromTestCases=false, tags={"FragileCode"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class StaticQualifiedUsingExpression
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        StatementTree statement;
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        switch (sym.getKind()) {
            case FIELD: {
                if (sym.getSimpleName().contentEquals("class") || sym.getSimpleName().contentEquals("super")) {
                    return Description.NO_MATCH;
                }
            }
            case METHOD: {
                if (sym.isStatic()) break;
                return Description.NO_MATCH;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        Symbol.ClassSymbol owner = sym.owner.enclClass();
        switch (tree.getExpression().getKind()) {
            case MEMBER_SELECT: 
            case IDENTIFIER: {
                Symbol base = ASTHelpers.getSymbol((Tree)tree.getExpression());
                if (!(base instanceof Symbol.ClassSymbol) || !base.isSubClass(owner, state.getTypes())) break;
                return Description.NO_MATCH;
            }
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        boolean isMethod = sym instanceof Symbol.MethodSymbol;
        String replacement = isMethod && Objects.equals(ASTHelpers.getSymbol((ClassTree)((ClassTree)state.findEnclosing(new Class[]{ClassTree.class}))), owner) ? sym.getSimpleName().toString() : SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (Symbol)sym);
        fix.replace((Tree)tree, replacement);
        if (tree.getExpression() instanceof MethodInvocationTree && (statement = (StatementTree)state.findEnclosing(new Class[]{StatementTree.class})) != null) {
            fix.prefixWith((Tree)statement, state.getSourceForNode((Tree)tree.getExpression()) + ";");
        }
        return this.buildDescription(tree).setMessage(String.format("Static %s %s should not be accessed from an object instance; instead use %s", isMethod ? "method" : "variable", sym.getSimpleName(), replacement)).addFix((Fix)fix.build()).build();
    }
}

