/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.SelfEquals;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Name;
import java.util.regex.Pattern;

@BugPattern(name="TruthSelfEquals", summary="isEqualTo should not be used to test an object for equality with itself; the assertion will never fail.", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class TruthSelfEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Pattern EQUALS_SAME = Pattern.compile("(isEqualTo|isSameAs)");
    private static final Pattern NOT_EQUALS_NOT_SAME = Pattern.compile("(isNotEqualTo|isNotSameAs)");
    private static final Matcher<MethodInvocationTree> EQUALS_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").withNameMatching(EQUALS_SAME).withParameters(new String[]{"java.lang.Object"}), TruthSelfEquals.receiverSameAsParentsArgument()});
    private static final Matcher<MethodInvocationTree> NOT_EQUALS_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").withNameMatching(NOT_EQUALS_NOT_SAME).withParameters(new String[]{"java.lang.Object"}), TruthSelfEquals.receiverSameAsParentsArgument()});
    private static final Matcher<ExpressionTree> ASSERT_THAT = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.TestVerb").named("that"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")});

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (methodInvocationTree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(methodInvocationTree);
        ExpressionTree toReplace = methodInvocationTree.getArguments().get(0);
        if (EQUALS_MATCHER.matches((Tree)methodInvocationTree, state)) {
            description.setMessage(TruthSelfEquals.generateSummary(((Name)ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree).getSimpleName()).toString(), "passes")).addFix(TruthSelfEquals.suggestEqualsTesterFix(methodInvocationTree, toReplace, state));
        } else if (NOT_EQUALS_MATCHER.matches((Tree)methodInvocationTree, state)) {
            description.setMessage(TruthSelfEquals.generateSummary(((Name)ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree).getSimpleName()).toString(), "fails"));
        } else {
            return Description.NO_MATCH;
        }
        Fix fix = SelfEquals.fieldFix(toReplace, state);
        if (fix != null) {
            description.addFix(fix);
        }
        return description.build();
    }

    private static String generateSummary(String methodName, String constantOutput) {
        return "The arguments to the " + methodName + " method are the same object, so it always " + constantOutput + ". Please change the arguments to point to different objects or consider using EqualsTester.";
    }

    private static Matcher<? super MethodInvocationTree> receiverSameAsParentsArgument() {
        return new Matcher<MethodInvocationTree>(){

            public boolean matches(MethodInvocationTree t, VisitorState state) {
                ExpressionTree rec = ASTHelpers.getReceiver((ExpressionTree)t);
                if (rec == null) {
                    return false;
                }
                if (!ASSERT_THAT.matches((Tree)rec, state)) {
                    return false;
                }
                return ASTHelpers.sameVariable((ExpressionTree)((ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)rec).getArguments())), (ExpressionTree)((ExpressionTree)Iterables.getOnlyElement(t.getArguments())));
            }
        };
    }

    private static Fix suggestEqualsTesterFix(MethodInvocationTree methodInvocationTree, ExpressionTree toReplace, VisitorState state) {
        String equalsTesterSuggest = "new EqualsTester().addEqualityGroup(" + state.getSourceForNode((Tree)toReplace) + ").testEquals()";
        return SuggestedFix.builder().replace((Tree)methodInvocationTree, equalsTesterSuggest).addImport("com.google.common.testing.EqualsTester").build();
    }
}

