/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.auto.common.AnnotationMirrors;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;

@BugPattern(name="RefersToDaggerCodegen", summary="Don't refer to Dagger's internal or generated code", severity=BugPattern.SeverityLevel.ERROR)
public final class RefersToDaggerCodegen
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> DAGGER_INTERNAL_PACKAGES = ImmutableSet.of((Object)"dagger.internal", (Object)"dagger.producers.internal", (Object)"dagger.producers.monitoring.internal", (Object)"dagger.android.internal");
    private static final ImmutableSet<String> GENERATED_BASE_TYPES = ImmutableSet.of((Object)"dagger.internal.Factory", (Object)"dagger.producers.internal.AbstractProducer");
    private static final ImmutableSet<String> DAGGER_1_GENERATED_BASE_TYPES = ImmutableSet.of((Object)"dagger.internal.Binding", (Object)"dagger.internal.ModuleAdapter");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        Symbol.ClassSymbol rootClassOfMethod = ASTHelpers.outermostClass((Symbol)method);
        if (!(RefersToDaggerCodegen.isGeneratedFactoryType(rootClassOfMethod, state) || this.isMembersInjectionInvocation(method, state) || RefersToDaggerCodegen.isDaggerInternalClass(rootClassOfMethod))) {
            return Description.NO_MATCH;
        }
        if (RefersToDaggerCodegen.isAllowedToReferenceDaggerInternals(state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private boolean isMembersInjectionInvocation(Symbol.MethodSymbol method, VisitorState state) {
        if (((Name)method.getSimpleName()).contentEquals("injectMembers")) {
            return false;
        }
        return RefersToDaggerCodegen.isGeneratedBaseType(ASTHelpers.outermostClass((Symbol)method), state, "dagger.MembersInjector");
    }

    private static boolean isGeneratedFactoryType(Symbol.ClassSymbol symbol, VisitorState state) {
        return GENERATED_BASE_TYPES.stream().anyMatch(baseType -> RefersToDaggerCodegen.isGeneratedBaseType(symbol, state, baseType));
    }

    private static boolean isGeneratedBaseType(Symbol.ClassSymbol symbol, VisitorState state, String baseTypeName) {
        Type baseType = state.getTypeFromString(baseTypeName);
        return ASTHelpers.isSubtype((Type)symbol.asType(), (Type)baseType, (VisitorState)state);
    }

    private static boolean isDaggerInternalClass(Symbol.ClassSymbol symbol) {
        return DAGGER_INTERNAL_PACKAGES.contains((Object)symbol.packge().getQualifiedName().toString());
    }

    private static boolean isAllowedToReferenceDaggerInternals(VisitorState state) {
        Symbol.ClassSymbol rootCallingClass = ASTHelpers.outermostClass((Symbol)ASTHelpers.getSymbol((ClassTree)((ClassTree)state.findEnclosing(new Class[]{ClassTree.class}))));
        if (rootCallingClass.getQualifiedName().toString().startsWith("dagger.")) {
            return true;
        }
        for (Attribute.Compound annotation : rootCallingClass.getAnnotationMirrors()) {
            Name annotationName = ((Symbol.ClassSymbol)annotation.getAnnotationType().asElement()).getQualifiedName();
            if (!annotationName.contentEquals("javax.annotation.Generated") && !annotationName.contentEquals("javax.annotation.processing.Generated")) continue;
            AnnotationValue valueAttribute = AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)"value");
            List valuesList = (List)valueAttribute.getValue();
            return valuesList.size() == 1 && ((Attribute)Iterables.getOnlyElement((Iterable)valuesList)).getValue().equals("dagger.internal.codegen.ComponentProcessor");
        }
        return DAGGER_1_GENERATED_BASE_TYPES.stream().anyMatch(dagger1Type -> RefersToDaggerCodegen.isGeneratedBaseType(rootCallingClass, state, dagger1Type));
    }
}

