/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.dataflow.nullnesspropagation.TrustingNullnessAnalysis;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeKind;

@BugPattern(name="NullableDereference", summary="Dereference of possibly-null value", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.NO_FIX)
public class NullableDereference
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        JCTree.JCExpression receiverTree = (JCTree.JCExpression)tree.getExpression();
        if (receiverTree == null || receiverTree.type == null || receiverTree.type.getKind() == TypeKind.PACKAGE) {
            return Description.NO_MATCH;
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (tree instanceof JCTree.JCFieldAccess && (sym == null || sym.isStatic())) {
            return Description.NO_MATCH;
        }
        Description result = this.checkExpression(receiverTree, state, qual -> String.format("Dereferencing method/field \"%s\" of %s null receiver %s", tree.getIdentifier(), qual, receiverTree));
        return result != null ? result : Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.checkCallArguments(tree.getArguments(), ASTHelpers.getSymbol((MethodInvocationTree)tree), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Description result;
        JCTree.JCExpression receiverTree = (JCTree.JCExpression)tree.getEnclosingExpression();
        if (receiverTree != null && (result = this.checkExpression(receiverTree, state, qual -> String.format("Outer object %s for %s is %s null", receiverTree, tree.getIdentifier(), qual))) != null) {
            return result;
        }
        return this.checkCallArguments(tree.getArguments(), ASTHelpers.getSymbol((NewClassTree)tree), state);
    }

    private Description checkCallArguments(java.util.List<? extends ExpressionTree> arguments, @Nullable Symbol.MethodSymbol sym, VisitorState state) {
        Symbol.VarSymbol param;
        if (sym == null) {
            return Description.NO_MATCH;
        }
        for (int i = 0; !(i >= ((List)sym.getParameters()).size() || (param = (Symbol.VarSymbol)((List)sym.getParameters()).get(i)).equals(((List)sym.getParameters()).last()) && sym.isVarArgs()); ++i) {
            ExpressionTree arg;
            Description result;
            if (NullnessAnnotations.fromAnnotationsOn((Symbol)param).orElse(null) != Nullness.NONNULL || (result = this.checkExpression(arg = arguments.get(i), state, qual -> String.format("argument %s is %s null but %s expects it to be non-null", arg, qual, sym.getSimpleName()))) == null) continue;
            return result;
        }
        return Description.NO_MATCH;
    }

    @Nullable
    private Description checkExpression(ExpressionTree tree, VisitorState state, Function<String, String> describer) {
        Nullness nullness = TrustingNullnessAnalysis.instance((Context)state.context).getNullness(new TreePath(state.getPath(), tree), state.context);
        if (nullness == null) {
            return null;
        }
        switch (nullness) {
            case NONNULL: 
            case BOTTOM: {
                return null;
            }
            case NULL: {
                return this.buildDescription(tree).setMessage(describer.apply("definitely")).build();
            }
            case NULLABLE: {
                return this.buildDescription(tree).setMessage(describer.apply("possibly")).build();
            }
        }
        throw new AssertionError((Object)("Unhandled: " + nullness));
    }
}

