/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.trace;

import com.google.instrumentation.common.NonThrowingCloseable;
import com.google.instrumentation.trace.Sampler;
import com.google.instrumentation.trace.ScopedSpanHandle;
import com.google.instrumentation.trace.Span;
import com.google.instrumentation.trace.SpanContext;
import com.google.instrumentation.trace.SpanFactory;
import com.google.instrumentation.trace.StartSpanOptions;
import java.util.List;
import javax.annotation.Nullable;

public final class SpanBuilder {
    private final SpanFactory spanFactory;
    private final String name;
    private final StartSpanOptions startSpanOption = new StartSpanOptions();
    private Span parentSpan;
    private SpanContext parentSpanContext;
    private boolean remoteParent;

    static SpanBuilder builder(SpanFactory spanFactory, Span parentSpan, String name) {
        return new SpanBuilder(spanFactory, parentSpan, null, false, name);
    }

    static SpanBuilder builderWithRemoteParent(SpanFactory spanFactory, SpanContext parentSpanContext, String name) {
        return new SpanBuilder(spanFactory, null, parentSpanContext, true, name);
    }

    public SpanBuilder setSampler(@Nullable Sampler sampler) {
        this.startSpanOption.setSampler(sampler);
        return this;
    }

    public SpanBuilder setParentLinks(@Nullable List<Span> parentLinks) {
        this.startSpanOption.setParentLinks(parentLinks);
        return this;
    }

    public SpanBuilder setRecordEvents(boolean recordEvents) {
        this.startSpanOption.setRecordEvents(recordEvents);
        return this;
    }

    public SpanBuilder becomeRoot() {
        this.parentSpan = null;
        this.parentSpanContext = null;
        this.remoteParent = false;
        return this;
    }

    public Span startSpan() {
        return this.start();
    }

    public NonThrowingCloseable startScopedSpan() {
        return new ScopedSpanHandle(this.start());
    }

    private SpanBuilder(SpanFactory spanFactory, @Nullable Span parentSpan, @Nullable SpanContext parentSpanContext, boolean remoteParent, String name) {
        this.parentSpan = parentSpan;
        this.parentSpanContext = parentSpanContext;
        this.remoteParent = remoteParent;
        this.name = name;
        this.spanFactory = spanFactory;
    }

    private Span start() {
        return this.remoteParent ? this.spanFactory.startSpanWithRemoteParent(this.parentSpanContext, this.name, this.startSpanOption) : this.spanFactory.startSpan(this.parentSpan, this.name, this.startSpanOption);
    }
}

