/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@BugPattern(name="Overrides", altNames={"overrides"}, summary="Varargs doesn't agree for overridden method", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class Overrides
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
        boolean isVarargs = (methodSymbol.flags() & 0x400000000L) != 0L;
        Set superMethods = ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes());
        if (superMethods.isEmpty()) {
            return Description.NO_MATCH;
        }
        Iterator superMethodsIterator = superMethods.iterator();
        boolean areSupersVarargs = ((Symbol.MethodSymbol)superMethodsIterator.next()).isVarArgs();
        while (superMethodsIterator.hasNext()) {
            if (areSupersVarargs == ((Symbol.MethodSymbol)superMethodsIterator.next()).isVarArgs()) continue;
            return this.describeMatch(methodTree);
        }
        if (isVarargs == areSupersVarargs) {
            return Description.NO_MATCH;
        }
        List<? extends VariableTree> parameterTree = methodTree.getParameters();
        Tree paramType = parameterTree.get(parameterTree.size() - 1).getType();
        String paramTypeSource = state.getSourceForNode(paramType);
        if (paramTypeSource == null) {
            return this.describeMatch(methodTree);
        }
        Description.Builder descriptionBuilder = this.buildDescription(methodTree);
        if (isVarargs) {
            descriptionBuilder.addFix((Fix)SuggestedFix.replace((Tree)paramType, (String)"[]", (int)(paramTypeSource.length() - 3), (int)0));
        } else {
            int arrayOpenIndex = paramTypeSource.length() - 2;
            while (paramTypeSource.charAt(arrayOpenIndex) == ' ') {
                --arrayOpenIndex;
            }
            if (paramTypeSource.charAt(arrayOpenIndex) == '[') {
                descriptionBuilder.addFix((Fix)SuggestedFix.replace((Tree)paramType, (String)"...", (int)arrayOpenIndex, (int)0));
            }
        }
        return descriptionBuilder.build();
    }
}

