/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import lombok.ast.CharLiteralTemplate;
import lombok.ast.StringLiteral;

class StringLiteralTemplate {
    String value1;

    StringLiteralTemplate() {
    }

    static String getDescription(StringLiteral self) {
        String v = self.astValue();
        if (v == null) {
            return null;
        }
        if (v.length() > 17) {
            return v.substring(0, 8) + "\u2026" + v.substring(v.length() - 8);
        }
        return v;
    }

    static String generateString(String literal) {
        StringBuilder raw = new StringBuilder().append('\"');
        char[] cs = literal.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            char next = i < cs.length - 1 ? cs[i + 1] : (char)'a';
            raw.append(CharLiteralTemplate.toEscape(c, false, next));
        }
        return raw.append('\"').toString();
    }

    static String parseString(String raw) {
        if (raw == null) {
            throw new IllegalArgumentException("missing string literal");
        }
        String v = raw.trim();
        if (!v.startsWith("\"") || !v.endsWith("\"")) {
            throw new IllegalArgumentException("String literals should be enclosed in double quotes: " + v);
        }
        String content = v.substring(1, v.length() - 1);
        char[] cs = content.toCharArray();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == '\n' || cs[i] == '\r') {
                throw new IllegalArgumentException("newlines not allowed in string literal: " + v);
            }
            if (cs[i] == '\"') {
                throw new IllegalArgumentException("unescaped double quotes not allowed in string literal: " + v);
            }
            if (cs[i] == '\\') {
                char x;
                char fromEscape;
                if (i == v.length() - 1) {
                    throw new IllegalArgumentException("Incomplete backslash escape: " + v);
                }
                if ((fromEscape = CharLiteralTemplate.fromEscape(x = cs[++i])) != '\u0000') {
                    value.append(fromEscape);
                    continue;
                }
                if (x >= '0' && x <= '7') {
                    boolean thirdFits;
                    char first = x;
                    int second = i < cs.length - 1 ? cs[i + 1] : 97;
                    int third = i < cs.length - 2 ? cs[i + 2] : 97;
                    boolean secondFits = second >= 48 && second <= 55;
                    boolean bl = thirdFits = third >= 48 && third <= 55;
                    if (first > '3') {
                        if (secondFits) {
                            ++i;
                            value.append((char)((first - 48) * 8 + (second - 48)));
                            continue;
                        }
                        value.append((char)(first - 48));
                        continue;
                    }
                    if (secondFits && thirdFits) {
                        i += 2;
                        value.append((char)((first - 48) * 64 + (second - 48) * 8 + (third - 48)));
                        continue;
                    }
                    if (secondFits) {
                        ++i;
                        value.append((char)((first - 48) * 8 + (second - 48)));
                        continue;
                    }
                    value.append((char)(first - 48));
                    continue;
                }
                throw new IllegalArgumentException("Invalid string literal (invalid backslash escape): " + v);
            }
            value.append(cs[i]);
        }
        return value.toString();
    }
}

