/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.AstVisitor;
import lombok.ast.BooleanLiteral;
import lombok.ast.CharLiteral;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StringFormatDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION_XML = new Implementation(StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    private static final Implementation IMPLEMENTATION_XML_AND_JAVA = new Implementation(StringFormatDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE), new EnumSet[]{Scope.JAVA_FILE_SCOPE});
    public static final Issue INVALID = Issue.create((String)"StringFormatInvalid", (String)"Invalid format string", (String)"If a string contains a '%' character, then the string may be a formatting string which will be passed to `String.format` from Java code to replace each '%' occurrence with specific values.\n\nThis lint warning checks for two related problems:\n(1) Formatting strings that are invalid, meaning that `String.format` will throw exceptions at runtime when attempting to use the format string.\n(2) Strings containing '%' that are not formatting strings getting passed to a `String.format` call. In this case the '%' will need to be escaped as '%%'.\n\nNOTE: Not all Strings which look like formatting strings are intended for use by `String.format`; for example, they may contain date formats intended for `android.text.format.Time#format()`. Lint cannot always figure out that a String is a date format, so you may get false warnings in those scenarios. See the suppress help topic for information on how to suppress errors in that case.", (Category)Category.MESSAGES, (int)9, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION_XML);
    public static final Issue ARG_COUNT = Issue.create((String)"StringFormatCount", (String)"Formatting argument types incomplete or inconsistent", (String)"When a formatted string takes arguments, it usually needs to reference the same arguments in all translations (or all arguments if there are no translations.\n\nThere are cases where this is not the case, so this issue is a warning rather than an error by default. However, this usually happens when a language is not translated or updated correctly.", (Category)Category.MESSAGES, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_XML);
    public static final Issue ARG_TYPES = Issue.create((String)"StringFormatMatches", (String)"`String.format` string doesn't match the XML format string", (String)"This lint check ensures the following:\n(1) If there are multiple translations of the format string, then all translations use the same type for the same numbered arguments\n(2) The usage of the format string in Java is consistent with the format string, meaning that the parameter types passed to String.format matches those in the format string.", (Category)Category.MESSAGES, (int)9, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION_XML_AND_JAVA);
    public static final Issue POTENTIAL_PLURAL = Issue.create((String)"PluralsCandidate", (String)"Potential Plurals", (String)"This lint check looks for potential errors in internationalization where you have translated a message which involves a quantity and it looks like other parts of the string may need grammatical changes.\n\nFor example, rather than something like this:\n  <string name=\"try_again\">Try again in %d seconds.</string>\nyou should be using a plural:\n   <plurals name=\"try_again\">\n        <item quantity=\"one\">Try again in %d second</item>\n        <item quantity=\"other\">Try again in %d seconds</item>\n    </plurals>\nThis will ensure that in other languages the right set of translations are provided for the different quantity classes.\n\n(This check depends on some heuristics, so it may not accurately determine whether a string really should be a quantity. You can use tools:ignore to filter out false positives.", (Category)Category.MESSAGES, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_XML).addMoreInfo("http://developer.android.com/guide/topics/resources/string-resource.html#Plurals");
    private Map<String, List<Pair<Location.Handle, String>>> mFormatStrings;
    private final Map<String, Location.Handle> mNotFormatStrings = new HashMap<String, Location.Handle>();
    private Set<String> mIgnoreStrings;
    private static final int CONVERSION_CLASS_UNKNOWN = 0;
    private static final int CONVERSION_CLASS_STRING = 1;
    private static final int CONVERSION_CLASS_CHARACTER = 2;
    private static final int CONVERSION_CLASS_INTEGER = 3;
    private static final int CONVERSION_CLASS_FLOAT = 4;
    private static final int CONVERSION_CLASS_BOOLEAN = 5;
    private static final int CONVERSION_CLASS_HASHCODE = 6;
    private static final int CONVERSION_CLASS_PERCENT = 7;
    private static final int CONVERSION_CLASS_NEWLINE = 8;
    private static final int CONVERSION_CLASS_DATETIME = 9;
    public static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    public boolean appliesTo(Context context, File file) {
        if (LintUtils.endsWith((String)file.getName(), (String)".java")) {
            return this.mFormatStrings != null;
        }
        return super.appliesTo(context, file);
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("string");
    }

    public void visitElement(XmlContext context, Element element) {
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() > 0) {
            if (childNodes.getLength() == 1) {
                org.w3c.dom.Node child = childNodes.item(0);
                if (child.getNodeType() == 3) {
                    this.checkTextNode(context, element, StringFormatDetector.strip(child.getNodeValue()));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                StringFormatDetector.addText(sb, element);
                if (sb.length() > 0) {
                    this.checkTextNode(context, element, sb.toString());
                }
            }
        }
    }

    private static void addText(StringBuilder sb, org.w3c.dom.Node node) {
        if (node.getNodeType() == 3) {
            sb.append(StringFormatDetector.strip(node.getNodeValue().trim()));
        } else {
            NodeList childNodes = node.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                StringFormatDetector.addText(sb, childNodes.item(i));
            }
        }
    }

    private static String strip(String s) {
        char last;
        if (s.length() < 2) {
            return s;
        }
        char first = s.charAt(0);
        if (first == (last = s.charAt(s.length() - 1)) && (first == '\'' || first == '\"')) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private void checkTextNode(XmlContext context, Element element, String text) {
        String name = element.getAttribute("name");
        boolean found = false;
        boolean foundPlural = false;
        int m = text.length();
        for (int j = 0; j < m; ++j) {
            char c = text.charAt(j);
            if (c == '\\') {
                ++j;
            }
            if (c != '%') continue;
            String formatted = element.getAttribute("formatted");
            if (!formatted.isEmpty() && !Boolean.parseBoolean(formatted)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context.createLocationHandle((org.w3c.dom.Node)element);
                    handle.setClientData((Object)element);
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            Matcher matcher = FORMAT.matcher(text);
            if (!matcher.find(j)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context.createLocationHandle((org.w3c.dom.Node)element);
                    handle.setClientData((Object)element);
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            String conversion = matcher.group(6);
            int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
            if (conversionClass == 0 || matcher.group(5) != null) {
                if (this.mIgnoreStrings == null) {
                    this.mIgnoreStrings = new HashSet<String>();
                }
                this.mIgnoreStrings.add(name);
                return;
            }
            if (conversionClass == 3 && !foundPlural) {
                for (int k = matcher.end(); k < m; ++k) {
                    char nc = text.charAt(k);
                    if (Character.isWhitespace(nc)) continue;
                    if (!Character.isLetter(nc)) break;
                    foundPlural = StringFormatDetector.checkPotentialPlural(context, element, text, k);
                    break;
                }
            }
            found = true;
            ++j;
        }
        if (!context.getProject().getReportIssues()) {
            return;
        }
        if (name != null) {
            Location.Handle handle = context.createLocationHandle((org.w3c.dom.Node)element);
            handle.setClientData((Object)element);
            if (found) {
                List<Pair<Location.Handle, String>> list;
                if (this.mFormatStrings == null) {
                    this.mFormatStrings = new HashMap<String, List<Pair<Location.Handle, String>>>();
                }
                if ((list = this.mFormatStrings.get(name)) == null) {
                    list = new ArrayList<Pair<Location.Handle, String>>();
                    this.mFormatStrings.put(name, list);
                }
                list.add((Pair<Location.Handle, String>)Pair.of((Object)handle, (Object)text));
            } else {
                this.mNotFormatStrings.put(name, handle);
            }
        }
    }

    private static boolean checkPotentialPlural(XmlContext context, Element element, String text, int wordBegin) {
        int wordEnd;
        assert (Character.isLetter(text.charAt(wordBegin)));
        for (wordEnd = wordBegin; wordEnd < text.length() && Character.isLetter(text.charAt(wordEnd)); ++wordEnd) {
        }
        if (wordEnd - wordBegin <= 2) {
            return false;
        }
        boolean hasVowel = false;
        for (int i = wordBegin; i < wordEnd; ++i) {
            char c = text.charAt(i);
            if (i > wordBegin && Character.isUpperCase(c)) {
                return false;
            }
            if (c != 'a' && c != 'e' && c != 'i' && c != 'o' && c != 'u' && c != 'y') continue;
            hasVowel = true;
        }
        if (!hasVowel) {
            return false;
        }
        String word = text.substring(wordBegin, wordEnd);
        if (word.equals("min")) {
            return false;
        }
        if (LintUtils.isEnglishResource((XmlContext)context, (boolean)true)) {
            String message = String.format("Formatting %%d followed by words (\"%1$s\"): This should probably be a plural rather than a string", word);
            context.report(POTENTIAL_PLURAL, (org.w3c.dom.Node)element, context.getLocation((org.w3c.dom.Node)element), message);
            return true;
        }
        return false;
    }

    public void afterCheckProject(Context context) {
        if (this.mFormatStrings != null) {
            boolean checkCount = context.isEnabled(ARG_COUNT);
            boolean checkValid = context.isEnabled(INVALID);
            boolean checkTypes = context.isEnabled(ARG_TYPES);
            for (Map.Entry<String, List<Pair<Location.Handle, String>>> entry : this.mFormatStrings.entrySet()) {
                String name = entry.getKey();
                ImmutableList list = entry.getValue();
                if (checkCount) {
                    Location.Handle notFormatted = this.mNotFormatStrings.get(name);
                    if (notFormatted != null) {
                        list = ImmutableList.builder().add((Object)Pair.of((Object)notFormatted, (Object)name)).addAll(list).build();
                    }
                    StringFormatDetector.checkArity(context, name, list);
                }
                if (!checkValid && !checkTypes) continue;
                StringFormatDetector.checkTypes(context, checkValid, checkTypes, name, list);
            }
        }
    }

    private static void checkTypes(Context context, boolean checkValid, boolean checkTypes, String name, List<Pair<Location.Handle, String>> list) {
        HashMap<Integer, String> types = new HashMap<Integer, String>();
        HashMap<Integer, Location.Handle> typeDefinition = new HashMap<Integer, Location.Handle>();
        block0: for (Pair<Location.Handle, String> pair : list) {
            Location.Handle handle = (Location.Handle)pair.getFirst();
            String formatString = (String)pair.getSecond();
            Matcher matcher = FORMAT.matcher(formatString);
            int index = 0;
            int prevIndex = 0;
            int nextNumber = 1;
            while (matcher.find(index)) {
                int number;
                char last;
                int matchStart = matcher.start();
                while (prevIndex < matchStart) {
                    char c = formatString.charAt(prevIndex);
                    if (c == '\\') {
                        ++prevIndex;
                    }
                    ++prevIndex;
                }
                if (prevIndex > matchStart) {
                    index = prevIndex;
                    continue;
                }
                index = matcher.end();
                String str = formatString.substring(matchStart, matcher.end());
                if (str.equals("%%") || str.equals("%n")) continue;
                if (checkValid && str.length() > 2 && str.charAt(str.length() - 2) == ' ' && (last = str.charAt(str.length() - 1)) != 'd' && last != 'o' && last != 'x' && last != 'X') {
                    Object clientData = handle.getClientData();
                    if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, INVALID, (org.w3c.dom.Node)clientData)) {
                        return;
                    }
                    Location location = handle.resolve();
                    String message = String.format("Incorrect formatting string `%1$s`; missing conversion character in '`%2$s`' ?", name, str);
                    context.report(INVALID, location, message);
                    continue;
                }
                if (!checkTypes) continue;
                String numberString = matcher.group(1);
                if (numberString != null) {
                    numberString = numberString.substring(0, numberString.length() - 1);
                    number = Integer.parseInt(numberString);
                    nextNumber = number + 1;
                } else {
                    number = nextNumber++;
                }
                String format = matcher.group(6);
                String currentFormat = (String)types.get(number);
                if (currentFormat == null) {
                    types.put(number, format);
                    typeDefinition.put(number, handle);
                    continue;
                }
                if (currentFormat.equals(format) || !StringFormatDetector.isIncompatible(currentFormat.charAt(0), format.charAt(0))) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, ARG_TYPES, (org.w3c.dom.Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                location = StringFormatDetector.refineLocation(context, location, formatString, matcher.start(), matcher.end());
                Location otherLocation = ((Location.Handle)typeDefinition.get(number)).resolve();
                otherLocation.setMessage("Conflicting argument type here");
                location.setSecondary(otherLocation);
                File f = otherLocation.getFile();
                String message = String.format("Inconsistent formatting types for argument #%1$d in format string `%2$s` ('%3$s'): Found both '`%4$s`' and '`%5$s`' (in %6$s)", number, name, str, currentFormat, format, f.getParentFile().getName() + File.separator + f.getName());
                context.report(ARG_TYPES, location, message);
                continue block0;
            }
        }
    }

    private static boolean isIncompatible(char conversion1, char conversion2) {
        int class2;
        int class1 = StringFormatDetector.getConversionClass(conversion1);
        return class1 != (class2 = StringFormatDetector.getConversionClass(conversion2)) && class1 != 0 && class2 != 0;
    }

    private static int getConversionClass(char conversion) {
        switch (conversion) {
            case 'T': 
            case 't': {
                return 9;
            }
            case 'S': 
            case 's': {
                return 1;
            }
            case 'C': 
            case 'c': {
                return 2;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                return 3;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                return 4;
            }
            case 'B': 
            case 'b': {
                return 5;
            }
            case 'H': 
            case 'h': {
                return 6;
            }
            case '%': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        return 0;
    }

    private static Location refineLocation(Context context, Location location, String formatString, int substringStart, int substringEnd) {
        Position startLocation = location.getStart();
        Position endLocation = location.getEnd();
        if (startLocation != null && endLocation != null) {
            int formatOffset;
            String contents;
            int startOffset = startLocation.getOffset();
            int endOffset = endLocation.getOffset();
            if (startOffset >= 0 && endOffset <= (contents = context.getClient().readFile(location.getFile())).length() && startOffset < endOffset && (formatOffset = contents.indexOf(formatString, startOffset)) != -1 && formatOffset <= endOffset) {
                return Location.create((File)location.getFile(), (String)contents, (int)(formatOffset + substringStart), (int)(formatOffset + substringEnd));
            }
        }
        return location;
    }

    private static void checkArity(Context context, String name, List<Pair<Location.Handle, String>> list) {
        int prevCount = -1;
        for (Pair<Location.Handle, String> pair : list) {
            HashSet<Integer> indices = new HashSet<Integer>();
            int count = StringFormatDetector.getFormatArgumentCount((String)pair.getSecond(), indices);
            Location.Handle handle = (Location.Handle)pair.getFirst();
            if (prevCount != -1 && prevCount != count) {
                Object clientData = handle.getClientData();
                if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, ARG_COUNT, (org.w3c.dom.Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                Location secondary = ((Location.Handle)list.get(0).getFirst()).resolve();
                secondary.setMessage("Conflicting number of arguments here");
                location.setSecondary(secondary);
                String message = String.format("Inconsistent number of arguments in formatting string `%1$s`; found both %2$d and %3$d", name, prevCount, count);
                context.report(ARG_COUNT, location, message);
                break;
            }
            for (int i = 1; i <= count; ++i) {
                if (indices.contains(i)) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, ARG_COUNT, (org.w3c.dom.Node)clientData)) {
                    return;
                }
                HashSet<Integer> all = new HashSet<Integer>();
                for (int j = 1; j < count; ++j) {
                    all.add(j);
                }
                all.removeAll(indices);
                ArrayList sorted = new ArrayList(all);
                Collections.sort(sorted);
                Location location = handle.resolve();
                String message = String.format("Formatting string '`%1$s`' is not referencing numbered arguments %2$s", name, sorted);
                context.report(ARG_COUNT, location, message);
                break;
            }
            prevCount = count;
        }
    }

    static String getFormatArgumentType(String s, int argument) {
        Matcher matcher = FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        while (matcher.find(index)) {
            int number;
            String value = matcher.group(6);
            if ("%".equals(value) || "n".equals(value)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number == argument) {
                return matcher.group(6);
            }
            index = matcher.end();
        }
        return null;
    }

    static int getFormatArgumentCount(String s, Set<Integer> seenArguments) {
        Matcher matcher = FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int max = 0;
        while (matcher.find(index)) {
            int number;
            String value = matcher.group(6);
            if ("%".equals(value) || "n".equals(value)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number > max) {
                max = number;
            }
            if (seenArguments != null) {
                seenArguments.add(number);
            }
            index = matcher.end();
        }
        return max;
    }

    public static boolean isLocaleSpecific(String format) {
        if (format.indexOf(37) == -1) {
            return false;
        }
        Matcher matcher = FORMAT.matcher(format);
        int index = 0;
        int prevIndex = 0;
        while (matcher.find(index)) {
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = format.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String type = matcher.group(6);
            if (!type.isEmpty()) {
                char t = type.charAt(0);
                switch (t) {
                    case 'E': 
                    case 'G': 
                    case 'T': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 't': {
                        return true;
                    }
                }
            }
            index = matcher.end();
        }
        return false;
    }

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("format", "getString");
    }

    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation node) {
        if (this.mFormatStrings == null && !context.getClient().supportsProjectResources()) {
            return;
        }
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (!(resolved instanceof JavaParser.ResolvedMethod)) {
            return;
        }
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
        String methodName = node.astName().astValue();
        if (methodName.equals("format")) {
            if (method.getContainingClass().matches("java.lang.String")) {
                this.checkFormatCall(context, node, method.getArgumentCount() == 3);
            }
        } else {
            if (method.getArgumentCount() < 2) {
                return;
            }
            JavaParser.ResolvedClass containingClass = method.getContainingClass();
            if (containingClass.isSubclassOf("android.content.res.Resources", false) || containingClass.isSubclassOf("android.content.Context", false) || containingClass.isSubclassOf("android.app.Fragment", false) || containingClass.isSubclassOf("android.support.v4.app.Fragment", false)) {
                this.checkFormatCall(context, node, false);
            }
        }
    }

    private void checkFormatCall(JavaContext context, MethodInvocation node, boolean specifiesLocale) {
        Node current = StringFormatDetector.getParentMethod((Node)node);
        if (current != null) {
            this.checkStringFormatCall(context, current, node, specifiesLocale);
        }
    }

    private static void checkNotFormattedHandle(JavaContext context, MethodInvocation call, String name, Location.Handle handle) {
        Object clientData = handle.getClientData();
        if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, INVALID, (org.w3c.dom.Node)clientData)) {
            return;
        }
        Location location = context.getLocation((Node)call);
        Location secondary = handle.resolve();
        secondary.setMessage("This definition does not require arguments");
        location.setSecondary(secondary);
        String message = String.format("Format string '`%1$s`' is not a valid format string so it should not be passed to `String.format`", name);
        context.report(INVALID, (Node)call, location, message);
    }

    private void checkStringFormatCall(JavaContext context, Node method, MethodInvocation call, boolean specifiesLocale) {
        ArrayList list;
        JavaParser.TypeDescriptor type;
        StrictListAccessor args = call.astArguments();
        if (args.isEmpty()) {
            return;
        }
        StringTracker tracker = new StringTracker(context, method, (Node)call, specifiesLocale ? 1 : 0);
        method.accept((AstVisitor)tracker);
        String name = tracker.getFormatStringName();
        if (name == null) {
            return;
        }
        if (this.mIgnoreStrings != null && this.mIgnoreStrings.contains(name)) {
            return;
        }
        boolean passingVarArgsArray = false;
        int callCount = args.size() - 1 - (specifiesLocale ? 1 : 0);
        if (callCount == 1 && (type = context.getType(args.last())) != null && type.isArray() && !type.isPrimitive()) {
            boolean knownArity = false;
            if (args.last() instanceof ArrayCreation) {
                ArrayDimension first;
                Expression expression;
                ArrayCreation creation = (ArrayCreation)args.last();
                ArrayInitializer initializer = creation.astInitializer();
                if (initializer != null) {
                    callCount = initializer.astExpressions().size();
                    knownArity = true;
                } else if (creation.astDimensions() != null && creation.astDimensions().size() == 1 && (expression = (first = (ArrayDimension)creation.astDimensions().first()).astDimension()) instanceof IntegralLiteral) {
                    callCount = ((IntegralLiteral)expression).astIntValue();
                    knownArity = true;
                }
            }
            if (!knownArity) {
                return;
            }
            passingVarArgsArray = true;
        }
        if (callCount > 0 && this.mNotFormatStrings.containsKey(name)) {
            StringFormatDetector.checkNotFormattedHandle(context, call, name, this.mNotFormatStrings.get(name));
            return;
        }
        ArrayList arrayList = list = this.mFormatStrings != null ? this.mFormatStrings.get(name) : null;
        if (list == null) {
            LintClient client = context.getClient();
            if (client.supportsProjectResources() && !context.getScope().contains(Scope.RESOURCE_FILE)) {
                AbstractResourceRepository resources = client.getProjectResources(context.getMainProject(), true);
                List items = resources != null ? resources.getResourceItem(ResourceType.STRING, name) : null;
                if (items != null) {
                    for (ResourceItem item : items) {
                        String value;
                        ResourceValue v = item.getResourceValue(false);
                        if (v == null || (value = v.getRawXmlValue()) == null) continue;
                        boolean isFormattingString = value.indexOf(37) != -1;
                        int m = value.length();
                        for (int j = 0; j < m && isFormattingString; ++j) {
                            char c = value.charAt(j);
                            if (c == '\\') {
                                ++j;
                                continue;
                            }
                            if (c != '%') continue;
                            Matcher matcher = FORMAT.matcher(value);
                            if (!matcher.find(j)) {
                                isFormattingString = false;
                            } else {
                                String conversion = matcher.group(6);
                                int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
                                if (conversionClass == 0 || matcher.group(5) != null) {
                                    return;
                                }
                            }
                            ++j;
                        }
                        Location.Handle handle = client.createResourceItemHandle(item);
                        if (isFormattingString) {
                            if (list == null) {
                                list = Lists.newArrayList();
                                if (this.mFormatStrings == null) {
                                    this.mFormatStrings = Maps.newHashMap();
                                }
                                this.mFormatStrings.put(name, list);
                            }
                            list.add(Pair.of((Object)handle, (Object)value));
                            continue;
                        }
                        if (callCount <= 0) continue;
                        StringFormatDetector.checkNotFormattedHandle(context, call, name, handle);
                    }
                }
            } else {
                return;
            }
        }
        if (list != null) {
            Set reported = null;
            for (Pair<Location.Handle, String> pair : list) {
                String s = (String)pair.getSecond();
                if (reported != null && reported.contains(s)) continue;
                int count = StringFormatDetector.getFormatArgumentCount(s, null);
                Location.Handle handle = (Location.Handle)pair.getFirst();
                if (count != callCount) {
                    Location location = context.getLocation((Node)call);
                    Location secondary = handle.resolve();
                    secondary.setMessage(String.format("This definition requires %1$d arguments", count));
                    location.setSecondary(secondary);
                    String message = String.format("Wrong argument count, format string `%1$s` requires `%2$d` but format call supplies `%3$d`", name, count, callCount);
                    context.report(ARG_TYPES, method, location, message);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                    continue;
                }
                if (passingVarArgsArray) {
                    return;
                }
                for (int i = 1; i <= count; ++i) {
                    int argumentIndex = i + (specifiesLocale ? 1 : 0);
                    Class<?> type2 = tracker.getArgumentType(argumentIndex);
                    if (type2 == null) continue;
                    boolean valid = true;
                    String formatType = StringFormatDetector.getFormatArgumentType(s, i);
                    if (formatType == null) continue;
                    char last = formatType.charAt(formatType.length() - 1);
                    if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') continue;
                    switch (last) {
                        case 'B': 
                        case 'b': {
                            valid = type2 == Boolean.TYPE;
                            break;
                        }
                        case 'A': 
                        case 'E': 
                        case 'G': 
                        case 'X': 
                        case 'a': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'o': 
                        case 'x': {
                            valid = type2 == Integer.TYPE || type2 == Float.TYPE || type2 == Double.TYPE || type2 == Long.TYPE || type2 == Byte.TYPE || type2 == Short.TYPE;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            valid = type2 == Character.TYPE;
                            break;
                        }
                        case 'H': 
                        case 'S': 
                        case 'h': 
                        case 's': {
                            boolean bl = valid = type2 != Boolean.TYPE && !Number.class.isAssignableFrom(type2);
                        }
                    }
                    if (valid) continue;
                    Expression argument = tracker.getArgument(argumentIndex);
                    Location location = context.getLocation((Node)argument);
                    Location secondary = handle.resolve();
                    secondary.setMessage("Conflicting argument declaration here");
                    location.setSecondary(secondary);
                    String message = String.format("Wrong argument type for formatting argument '#%1$d' in `%2$s`: conversion is '`%3$s`', received `%4$s` (argument #%5$d in method call)", i, name, formatType, type2.getSimpleName(), argumentIndex + 1);
                    context.report(ARG_TYPES, method, location, message);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                }
            }
        }
    }

    private static boolean isLocaleReference(JavaParser.TypeDescriptor reference) {
        return reference != null && StringFormatDetector.isLocaleReference(reference.getName());
    }

    private static boolean isLocaleReference(String typeName) {
        return typeName != null && (typeName.equals("Locale") || typeName.equals("java.util.Locale"));
    }

    public static Node getParentMethod(Node node) {
        Node current;
        for (current = node.getParent(); current != null && !(current instanceof MethodDeclaration) && !(current instanceof ConstructorDeclaration); current = current.getParent()) {
        }
        return current;
    }

    public static String getResourceForFirstArg(Node method, Node call) {
        assert (call instanceof MethodInvocation || call instanceof ConstructorInvocation);
        StringTracker tracker = new StringTracker(null, method, call, 0);
        method.accept((AstVisitor)tracker);
        return tracker.getFormatStringName();
    }

    public static String getResourceArg(Node method, Node call, int argIndex) {
        assert (call instanceof MethodInvocation || call instanceof ConstructorInvocation);
        StringTracker tracker = new StringTracker(null, method, call, argIndex);
        method.accept((AstVisitor)tracker);
        return tracker.getFormatStringName();
    }

    private static class StringTracker
    extends ForwardingAstVisitor {
        private final Node mTop;
        private final int mArgIndex;
        private final Map<String, String> mMap = new HashMap<String, String>();
        private final Map<String, Class<?>> mTypes = new HashMap();
        private final Node mTargetNode;
        private boolean mDone;
        private JavaContext mContext;
        private String mName;

        public StringTracker(JavaContext context, Node top, Node targetNode, int argIndex) {
            this.mContext = context;
            this.mTop = top;
            this.mArgIndex = argIndex;
            this.mTargetNode = targetNode;
        }

        public String getFormatStringName() {
            return this.mName;
        }

        public Class<?> getArgumentType(int argument) {
            Expression arg = this.getArgument(argument);
            if (arg != null) {
                Class<?> type = this.getType(arg);
                if (type != null) {
                    return type;
                }
                if (this.mContext != null) {
                    return StringTracker.getTypeClass(this.mContext.getType((Node)arg));
                }
            }
            return null;
        }

        private static Class<?> getTypeClass(JavaParser.TypeDescriptor type) {
            if (type != null) {
                return StringTracker.getTypeClass(type.getName());
            }
            return null;
        }

        private static Class<?> getTypeClass(String fqcn) {
            if (fqcn == null) {
                return null;
            }
            if (fqcn.equals("java.lang.String") || fqcn.equals("String")) {
                return String.class;
            }
            if (fqcn.equals("int")) {
                return Integer.TYPE;
            }
            if (fqcn.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (fqcn.equals("null")) {
                return Object.class;
            }
            if (fqcn.equals("long")) {
                return Long.TYPE;
            }
            if (fqcn.equals("float")) {
                return Float.TYPE;
            }
            if (fqcn.equals("double")) {
                return Double.TYPE;
            }
            if (fqcn.equals("char")) {
                return Character.TYPE;
            }
            if (fqcn.equals("BigDecimal") || fqcn.equals("java.math.BigDecimal")) {
                return Float.TYPE;
            }
            if (fqcn.equals("BigInteger") || fqcn.equals("java.math.BigInteger")) {
                return Integer.TYPE;
            }
            if (fqcn.equals("java.lang.Object")) {
                return null;
            }
            if (fqcn.startsWith("java.lang.")) {
                if (fqcn.equals("java.lang.Integer") || fqcn.equals("java.lang.Short") || fqcn.equals("java.lang.Byte") || fqcn.equals("java.lang.Long")) {
                    return Integer.TYPE;
                }
                if (fqcn.equals("java.lang.Float") || fqcn.equals("java.lang.Double")) {
                    return Float.TYPE;
                }
                return null;
            }
            if (fqcn.equals("byte")) {
                return Byte.TYPE;
            }
            if (fqcn.equals("short")) {
                return Short.TYPE;
            }
            return null;
        }

        public Expression getArgument(int argument) {
            if (!(this.mTargetNode instanceof MethodInvocation)) {
                return null;
            }
            MethodInvocation call = (MethodInvocation)this.mTargetNode;
            StrictListAccessor args = call.astArguments();
            if (argument >= args.size()) {
                return null;
            }
            Iterator iterator = args.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Expression arg = (Expression)iterator.next();
                if (index++ != argument) continue;
                return arg;
            }
            return null;
        }

        public boolean visitNode(Node node) {
            return this.mDone || super.visitNode(node);
        }

        public boolean visitVariableReference(VariableReference node) {
            if (node.astIdentifier().astValue().equals("R") && node.getParent() instanceof Select && node.getParent().getParent() instanceof Select) {
                Node current;
                String reference = ((Select)current).astIdentifier().astValue();
                Node prev = current;
                for (current = node.getParent().getParent(); current != this.mTop && !(current instanceof VariableDefinitionEntry); current = current.getParent()) {
                    if (current == this.mTargetNode) {
                        MethodInvocation call;
                        boolean isParameterArg = false;
                        Iterator iterator = null;
                        if (this.mTargetNode instanceof MethodInvocation) {
                            call = (MethodInvocation)this.mTargetNode;
                            iterator = call.astArguments().iterator();
                        } else if (this.mTargetNode instanceof ConstructorInvocation) {
                            call = (ConstructorInvocation)this.mTargetNode;
                            iterator = call.astArguments().iterator();
                        }
                        if (iterator != null) {
                            Expression arg = null;
                            for (int i = 0; i <= this.mArgIndex; ++i) {
                                arg = iterator.hasNext() ? (Expression)iterator.next() : null;
                            }
                            if (arg == prev) {
                                isParameterArg = true;
                            }
                        } else {
                            isParameterArg = true;
                        }
                        if (isParameterArg) {
                            this.mName = reference;
                            this.mDone = true;
                            return false;
                        }
                    }
                    prev = current;
                }
                if (current instanceof VariableDefinitionEntry) {
                    VariableDefinitionEntry entry = (VariableDefinitionEntry)current;
                    String variable = entry.astName().astValue();
                    this.mMap.put(variable, reference);
                }
            }
            return false;
        }

        private Expression getTargetArgument() {
            Iterator iterator;
            if (this.mTargetNode instanceof MethodInvocation) {
                iterator = ((MethodInvocation)this.mTargetNode).astArguments().iterator();
            } else if (this.mTargetNode instanceof ConstructorInvocation) {
                iterator = ((ConstructorInvocation)this.mTargetNode).astArguments().iterator();
            } else {
                return null;
            }
            for (int i = 0; i < this.mArgIndex && iterator.hasNext(); ++i) {
                iterator.next();
            }
            if (iterator.hasNext()) {
                Expression next = (Expression)iterator.next();
                if (next != null && this.mContext != null && iterator.hasNext()) {
                    JavaParser.TypeDescriptor type = this.mContext.getType((Node)next);
                    if (StringFormatDetector.isLocaleReference(type)) {
                        next = (Expression)iterator.next();
                    } else if (type == null && next.toString().startsWith("Locale.")) {
                        next = (Expression)iterator.next();
                    }
                }
                return next;
            }
            return null;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            Expression arg;
            if (node == this.mTargetNode && (arg = this.getTargetArgument()) instanceof VariableReference) {
                VariableReference reference = (VariableReference)arg;
                String variable = reference.astIdentifier().astValue();
                this.mName = this.mMap.get(variable);
                this.mDone = true;
                return true;
            }
            return super.visitMethodInvocation(node);
        }

        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            Expression arg;
            if (node == this.mTargetNode && (arg = this.getTargetArgument()) instanceof VariableReference) {
                VariableReference reference = (VariableReference)arg;
                String variable = reference.astIdentifier().astValue();
                this.mName = this.mMap.get(variable);
                this.mDone = true;
                return true;
            }
            return super.visitConstructorInvocation(node);
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
            String name = node.astName().astValue();
            Expression rhs = node.astInitializer();
            Class<?> type = this.getType(rhs);
            if (type != null) {
                this.mTypes.put(name, type);
            } else if (rhs != this.mTargetNode) {
                this.mTypes.remove(name);
            }
            return super.visitVariableDefinitionEntry(node);
        }

        private Class<?> getType(Expression expression) {
            JavaParser.TypeDescriptor type;
            if (expression == null) {
                return null;
            }
            if (expression instanceof VariableReference) {
                VariableReference reference = (VariableReference)expression;
                String variable = reference.astIdentifier().astValue();
                Class<?> type2 = this.mTypes.get(variable);
                if (type2 != null) {
                    return type2;
                }
            } else if (expression instanceof MethodInvocation) {
                MethodInvocation method = (MethodInvocation)expression;
                String methodName = method.astName().astValue();
                if (methodName.equals("getString")) {
                    return String.class;
                }
            } else {
                if (expression instanceof StringLiteral) {
                    return String.class;
                }
                if (expression instanceof IntegralLiteral) {
                    return Integer.TYPE;
                }
                if (expression instanceof FloatingPointLiteral) {
                    return Float.TYPE;
                }
                if (expression instanceof CharLiteral) {
                    return Character.TYPE;
                }
                if (expression instanceof BooleanLiteral) {
                    return Boolean.TYPE;
                }
                if (expression instanceof NullLiteral) {
                    return Object.class;
                }
            }
            if (this.mContext != null && (type = this.mContext.getType((Node)expression)) != null) {
                Class<?> typeClass = StringTracker.getTypeClass(type);
                if (typeClass != null) {
                    return typeClass;
                }
                return Object.class;
            }
            return null;
        }
    }
}

