/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import javax.lang.model.element.ElementKind;

@BugPattern(name="MissingDefault", summary="The Google Java Style Guide requires that each switch statement includes a default statement group, even if it contains no code. (This requirement is lifted for any switch statement that covers all values of an enum.)", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class MissingDefault
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        Type switchType = ASTHelpers.getType((Tree)tree.getExpression());
        if (switchType.asElement().getKind() == ElementKind.ENUM) {
            return Description.NO_MATCH;
        }
        Optional<CaseTree> maybeDefault = tree.getCases().stream().filter(c -> c.getExpression() == null).findFirst();
        if (!maybeDefault.isPresent()) {
            Description.Builder description = this.buildDescription(tree);
            if (!tree.getCases().isEmpty()) {
                CaseTree lastCase = (CaseTree)Iterables.getLast(tree.getCases());
                String replacement = lastCase.getStatements().isEmpty() || Reachability.canCompleteNormally((StatementTree)((StatementTree)Iterables.getLast(lastCase.getStatements()))) ? "\nbreak;\ndefault: // fall out\n" : "\ndefault: // fall out\n";
                description.addFix((Fix)SuggestedFix.postfixWith((Tree)((Tree)Iterables.getLast(tree.getCases())), (String)replacement));
            }
            return description.build();
        }
        CaseTree defaultCase = maybeDefault.get();
        if (!defaultCase.getStatements().isEmpty()) {
            return Description.NO_MATCH;
        }
        int idx = tree.getCases().indexOf(defaultCase);
        if (idx != tree.getCases().size() - 1) {
            return Description.NO_MATCH;
        }
        if (state.getOffsetTokens(state.getEndPosition((Tree)defaultCase), state.getEndPosition((Tree)tree)).stream().anyMatch(t -> !t.comments().isEmpty())) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(defaultCase).setMessage("Default case should be documented with a comment").addFix((Fix)SuggestedFix.postfixWith((Tree)defaultCase, (String)" // fall out")).build();
    }
}

