/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.errorprone.bugpatterns.AbstractMustBeClosedChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="MustBeClosedChecker", summary="The result of this method must be closed.", severity=BugPattern.SeverityLevel.ERROR, generateExamplesFromTestCases=false)
public class MustBeClosedChecker
extends AbstractMustBeClosedChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final Matcher<Tree> IS_AUTOCLOSEABLE = Matchers.isSubtypeOf(AutoCloseable.class);
    private static final Matcher<MethodTree> METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.methodIsConstructor()), Matchers.methodReturns(IS_AUTOCLOSEABLE)});
    private static final Matcher<MethodTree> AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf(AutoCloseable.class))});
    private static final Matcher<ExpressionTree> CONSTRUCTOR = MethodMatchers.constructor();

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        boolean isAConstructor = Matchers.methodIsConstructor().matches((Tree)tree, state);
        if (isAConstructor && !AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate constructors of AutoCloseables.").build();
        }
        if (!isAConstructor && !METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate methods that return an AutoCloseable.").build();
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (CONSTRUCTOR.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.matchNewClassOrMethodInvocation(tree, state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.matchNewClassOrMethodInvocation(tree, state);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!IS_AUTOCLOSEABLE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        for (Tree tree2 : tree.getMembers()) {
            MethodTree methodTree;
            if (!(tree2 instanceof MethodTree) || !ASTHelpers.getSymbol((MethodTree)(methodTree = (MethodTree)tree2)).isConstructor() || ASTHelpers.hasAnnotation((Tree)methodTree, MustBeClosed.class, (VisitorState)state) || !MustBeClosedChecker.invokedConstructorMustBeClosed(state, methodTree)) continue;
            if (ASTHelpers.isGeneratedConstructor((MethodTree)methodTree)) {
                state.reportMatch(this.buildDescription(tree).setMessage("Implicitly invoked constructor is marked @MustBeClosed, so this class must have an explicit constructor with @MustBeClosed also.").build());
                continue;
            }
            SuggestedFix.Builder builder = SuggestedFix.builder();
            String suggestedFixName = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (TypeMirror)state.getTypeFromString(MustBeClosed.class.getCanonicalName()));
            SuggestedFix fix = builder.prefixWith((Tree)methodTree, "@" + suggestedFixName + " ").build();
            state.reportMatch(this.buildDescription(methodTree).addFix((Fix)fix).setMessage("Invoked constructor is marked @MustBeClosed, so this constructors must be marked @MustBeClosed too.").build());
        }
        return Description.NO_MATCH;
    }

    private static boolean invokedConstructorMustBeClosed(VisitorState state, MethodTree methodTree) {
        List<? extends StatementTree> statements = methodTree.getBody().getStatements();
        if (statements.isEmpty()) {
            return false;
        }
        ExpressionStatementTree est = (ExpressionStatementTree)statements.get(0);
        MethodInvocationTree mit = (MethodInvocationTree)est.getExpression();
        Symbol.MethodSymbol invokedConstructorSymbol = ASTHelpers.getSymbol((MethodInvocationTree)mit);
        return ASTHelpers.hasAnnotation((Symbol)invokedConstructorSymbol, MustBeClosed.class, (VisitorState)state);
    }
}

