/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.cfg.node.NodeVisitor;

public class MarkerNode
extends Node {
    protected final @Nullable Tree tree;
    protected final String message;

    public MarkerNode(@Nullable Tree tree, String message, Types types) {
        super(types.getNoType(TypeKind.NONE));
        this.tree = tree;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public @Nullable Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitMarker(this, p);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("marker (");
        sb.append(this.message);
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof MarkerNode)) {
            return false;
        }
        MarkerNode other = (MarkerNode)obj;
        return Objects.equals(this.getTree(), other.getTree()) && this.getMessage().equals(other.getMessage());
    }

    public int hashCode() {
        return Objects.hash(this.tree, this.getMessage());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.emptyList();
    }
}

