/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibilityUtils;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="EqualsIncompatibleType", summary="An equality test between objects with incompatible types always returns false", severity=BugPattern.SeverityLevel.WARNING)
public class EqualsIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> STATIC_EQUALS_MATCHER = Matchers.staticEqualsInvocation();
    private static final Matcher<ExpressionTree> INSTANCE_EQUALS_MATCHER = Matchers.instanceEqualsInvocation();
    private static final Matcher<Tree> ASSERT_FALSE_MATCHER = Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("assertFalse"), Matchers.staticMethod().anyClass().named("assertFalse")}));

    public Description matchMethodInvocation(MethodInvocationTree invocationTree, VisitorState state) {
        Type argumentType;
        Type receiverType;
        if (!STATIC_EQUALS_MATCHER.matches((Tree)invocationTree, state) && !INSTANCE_EQUALS_MATCHER.matches((Tree)invocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (STATIC_EQUALS_MATCHER.matches((Tree)invocationTree, state)) {
            receiverType = ASTHelpers.getType((Tree)invocationTree.getArguments().get(0));
            argumentType = ASTHelpers.getType((Tree)invocationTree.getArguments().get(1));
        } else {
            receiverType = ASTHelpers.getReceiverType((ExpressionTree)invocationTree);
            argumentType = ASTHelpers.getType((Tree)invocationTree.getArguments().get(0));
        }
        TypeCompatibilityUtils.TypeCompatibilityReport compatibilityReport = TypeCompatibilityUtils.compatibilityOfTypes(receiverType, argumentType, state);
        if (compatibilityReport.compatible()) {
            return Description.NO_MATCH;
        }
        if (ASSERT_FALSE_MATCHER.matches(state.getPath().getParentPath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(invocationTree).setMessage(EqualsIncompatibleType.getMessage(invocationTree, receiverType, argumentType, compatibilityReport.lhs(), compatibilityReport.rhs(), state)).build();
    }

    private static String getMessage(MethodInvocationTree invocationTree, Type receiverType, Type argumentType, Type conflictingReceiverType, Type conflictingArgumentType, VisitorState state) {
        TypeStringPair typeStringPair = new TypeStringPair(receiverType, argumentType);
        String baseMessage = "Calling " + ASTHelpers.getSymbol((MethodInvocationTree)invocationTree).getSimpleName() + " on incompatible types " + typeStringPair.getReceiverTypeString() + " and " + typeStringPair.getArgumentTypeString();
        if (!state.getTypes().isSameType(receiverType, conflictingReceiverType)) {
            TypeStringPair conflictingTypes = new TypeStringPair(conflictingReceiverType, conflictingArgumentType);
            baseMessage = baseMessage + ". They are incompatible because " + conflictingTypes.getReceiverTypeString() + " and " + conflictingTypes.getArgumentTypeString() + " are incompatible.";
        }
        return baseMessage;
    }

    private static class TypeStringPair {
        private String receiverTypeString;
        private String argumentTypeString;

        private TypeStringPair(Type receiverType, Type argumentType) {
            this.receiverTypeString = Signatures.prettyType((Type)receiverType);
            this.argumentTypeString = Signatures.prettyType((Type)argumentType);
            if (this.argumentTypeString.equals(this.receiverTypeString)) {
                this.receiverTypeString = receiverType.toString();
                this.argumentTypeString = argumentType.toString();
            }
        }

        private String getReceiverTypeString() {
            return this.receiverTypeString;
        }

        private String getArgumentTypeString() {
            return this.argumentTypeString;
        }
    }
}

