/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;

@BugPattern(name="ToStringReturnsNull", summary="An implementation of Object.toString() should never return null.", severity=BugPattern.SeverityLevel.WARNING)
public class ToStringReturnsNull
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!Matchers.toStringMethodDeclaration().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        boolean hasReturnNull = tree.accept(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return false;
            }

            @Override
            public Boolean visitClass(ClassTree node, Void unused) {
                return false;
            }

            @Override
            public Boolean visitReturn(ReturnTree node, Void unused) {
                return node.getExpression().getKind() == Tree.Kind.NULL_LITERAL;
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 != null && r1 != false || r2 != null && r2 != false;
            }
        }, null);
        return hasReturnNull ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

