/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.util.List;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.stream.Collectors;

@BugPattern(name="MultiVariableDeclaration", summary="Variable declarations should declare only one variable", severity=BugPattern.SeverityLevel.SUGGESTION, linkType=BugPattern.LinkType.CUSTOM, tags={"Style"}, link="https://google.github.io/styleguide/javaguide.html#s4.8.2.1-variables-per-declaration")
public class MultiVariableDeclaration
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.BlockTreeMatcher {
    public Description matchBlock(BlockTree tree, VisitorState state) {
        return this.checkDeclarations(tree.getStatements(), state);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        return this.checkDeclarations(tree.getMembers(), state);
    }

    private Description checkDeclarations(java.util.List<? extends Tree> children, VisitorState state) {
        PeekingIterator it = Iterators.peekingIterator(children.iterator());
        while (it.hasNext()) {
            if (((Tree)it.peek()).getKind() != Tree.Kind.VARIABLE) {
                it.next();
                continue;
            }
            VariableTree variableTree = (VariableTree)it.next();
            ArrayList<JCTree.JCVariableDecl> fragments = new ArrayList<JCTree.JCVariableDecl>();
            fragments.add((JCTree.JCVariableDecl)variableTree);
            while (it.hasNext() && ((Tree)it.peek()).getKind() == Tree.Kind.VARIABLE && ((JCTree)((Object)variableTree)).getStartPosition() == ((JCTree)it.peek()).getStartPosition()) {
                fragments.add((JCTree.JCVariableDecl)it.next());
            }
            if (fragments.size() == 1) continue;
            SuggestedFix fix = SuggestedFix.replace((int)((JCTree.JCVariableDecl)fragments.get(0)).getStartPosition(), (int)state.getEndPosition((Tree)Iterables.getLast(fragments)), (String)fragments.stream().map(this::pretty).collect(Collectors.joining("")));
            state.reportMatch(this.describeMatch((JCTree)fragments.get(0), (Fix)fix));
        }
        return Description.NO_MATCH;
    }

    private String pretty(JCTree.JCVariableDecl variableDecl) {
        StringWriter sw = new StringWriter();
        try {
            new Pretty(sw, true){

                @Override
                public void visitAnnotation(JCTree.JCAnnotation anno) {
                    if (((List)anno.getArguments()).isEmpty()) {
                        try {
                            this.print("@");
                            this.printExpr(anno.annotationType);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    } else {
                        super.visitAnnotation(anno);
                    }
                }
            }.printStat(variableDecl);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return sw.toString();
    }
}

