/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.MemberVisitor;

public class ClassMemberChecker
extends SimplifiedVisitor
implements MemberVisitor {
    private final ClassPool programClassPool;
    private final WarningPrinter notePrinter;

    public ClassMemberChecker(ClassPool classPool, WarningPrinter warningPrinter) {
        this.programClassPool = classPool;
        this.notePrinter = warningPrinter;
    }

    public void checkClassSpecifications(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Clazz clazz;
                ClassSpecification classSpecification = (ClassSpecification)list.get(i);
                String string = classSpecification.className;
                if (string == null || ClassMemberChecker.containsWildCards(string) || !this.notePrinter.accepts(string) || (clazz = this.programClassPool.getClass(string)) == null) continue;
                this.checkMemberSpecifications(clazz, classSpecification.fieldSpecifications, true);
                this.checkMemberSpecifications(clazz, classSpecification.methodSpecifications, false);
            }
        }
    }

    private void checkMemberSpecifications(Clazz clazz, List list, boolean bl) {
        if (list != null) {
            String string = clazz.getName();
            for (int i = 0; i < list.size(); ++i) {
                MemberSpecification memberSpecification = (MemberSpecification)list.get(i);
                String string2 = memberSpecification.name;
                String string3 = memberSpecification.descriptor;
                if (string2 == null || ClassMemberChecker.containsWildCards(string2) || string3 == null || ClassMemberChecker.containsWildCards(string3)) continue;
                if (bl) {
                    if (clazz.findField(string2, string3) != null) continue;
                    this.notePrinter.print(string, "Note: the configuration refers to the unknown field '" + ClassUtil.externalFullFieldDescription(0, string2, string3) + "' in class '" + ClassUtil.externalClassName(string) + "'");
                    continue;
                }
                if (clazz.findMethod(string2, string3) != null) continue;
                this.notePrinter.print(string, "Note: the configuration refers to the unknown method '" + ClassUtil.externalFullMethodDescription(string, 0, string2, string3) + "' in class '" + ClassUtil.externalClassName(string) + "'");
            }
        }
    }

    private static boolean containsWildCards(String string) {
        return string != null && (string.indexOf(33) >= 0 || string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(44) >= 0 || string.indexOf("///") >= 0);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        System.out.println("      Maybe you meant the field '" + ClassUtil.externalFullFieldDescription(0, programField.getName(programClass), programField.getDescriptor(programClass)) + "'?");
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        System.out.println("      Maybe you meant the method '" + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)) + "'?");
    }
}

