/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMustBeClosedChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Objects;

@BugPattern(name="StreamResourceLeak", altNames={"FilesLinesLeak"}, summary="Streams that encapsulate a closeable resource should be closed using try-with-resources", severity=BugPattern.SeverityLevel.WARNING)
public class StreamResourceLeak
extends AbstractMustBeClosedChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.nio.file.Files").namedAnyOf(new String[]{"lines", "newDirectoryStream", "list", "walk", "find"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.matchNewClassOrMethodInvocation(tree, state);
    }

    @Override
    protected void addFix(Description.Builder description, ExpressionTree tree, VisitorState state) {
        TreePath parentPath = state.getPath().getParentPath();
        final Tree parent = parentPath.getLeaf();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String streamType = SuggestedFixes.prettyType((VisitorState)state, (SuggestedFix.Builder)fix, (Type)ASTHelpers.getReturnType((ExpressionTree)tree));
        if (parent instanceof MemberSelectTree) {
            StatementTree statement = (StatementTree)state.findEnclosing(new Class[]{StatementTree.class});
            if (statement instanceof VariableTree) {
                VariableTree var = (VariableTree)statement;
                int pos = ((JCTree)((Object)var)).getStartPosition();
                int initPos = ((JCTree)((Object)var.getInitializer())).getStartPosition();
                int eqPos = pos + state.getSourceForNode((Tree)var).substring(0, initPos - pos).lastIndexOf(61);
                fix.replace(eqPos, initPos, String.format(";\ntry (%s stream = %s) {\n%s =", streamType, state.getSourceForNode((Tree)tree), var.getName()));
            } else {
                fix.prefixWith((Tree)statement, String.format("try (%s stream = %s) {\n", streamType, state.getSourceForNode((Tree)tree)));
            }
            fix.replace((Tree)tree, "stream");
            fix.postfixWith((Tree)statement, "}");
            description.addFix((Fix)fix.build());
        } else if (parent instanceof VariableTree) {
            int idx;
            Tree grandParent = parentPath.getParentPath().getLeaf();
            if (!(grandParent instanceof BlockTree)) {
                return;
            }
            List<? extends StatementTree> statements = ((BlockTree)grandParent).getStatements();
            int lastUse = idx = statements.indexOf(parent);
            for (int i = idx + 1; i < statements.size(); ++i) {
                final boolean[] found = new boolean[]{false};
                statements.get(i).accept(new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree tree, Void unused) {
                        if (Objects.equals(ASTHelpers.getSymbol((Tree)tree), ASTHelpers.getSymbol((Tree)parent))) {
                            found[0] = true;
                        }
                        return null;
                    }
                }, null);
                if (!found[0]) continue;
                lastUse = i;
            }
            fix.prefixWith(parent, "try (");
            fix.replace(state.getEndPosition((Tree)((VariableTree)parent).getInitializer()), state.getEndPosition(parent), ") {");
            fix.postfixWith((Tree)statements.get(lastUse), "}");
            description.addFix((Fix)fix.build());
        } else if (parent instanceof EnhancedForLoopTree) {
            fix.prefixWith(parent, String.format("try (%s stream = %s) {\n", streamType, state.getSourceForNode((Tree)tree)));
            fix.replace((Tree)tree, "stream");
            fix.postfixWith(parent, "}");
            description.addFix((Fix)fix.build());
        } else if (parent instanceof MethodInvocationTree) {
            Tree grandParent = parentPath.getParentPath().getLeaf();
            if (!(grandParent instanceof ExpressionStatementTree)) {
                return;
            }
            fix.prefixWith(parent, String.format("try (%s stream = %s) {\n", streamType, state.getSourceForNode((Tree)tree)));
            fix.replace((Tree)tree, "stream");
            fix.postfixWith(grandParent, "}");
            description.addFix((Fix)fix.build());
        }
    }
}

