/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractUseSwitch
extends BugChecker
implements BugChecker.IfTreeMatcher {
    private static final int MIN_BRANCHES = 3;
    private static final Matcher<ExpressionTree> EQUALS = Matchers.instanceMethod().anyClass().named("equals").withParameters("java.lang.Object", new String[0]);

    protected abstract @Nullable String getExpressionForCase(VisitorState var1, ExpressionTree var2);

    private static boolean isValidCaseBlock(StatementTree tree) {
        if (!(tree instanceof JCTree.JCBlock)) {
            return false;
        }
        final boolean[] good = new boolean[]{true};
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitBreak(BreakTree t, Void v) {
                good[0] = false;
                return null;
            }

            @Override
            public Void visitVariable(VariableTree t, Void v) {
                good[0] = false;
                return null;
            }
        }.scan(tree, null);
        return good[0];
    }

    private static CharSequence getBlockContents(BlockTree block, VisitorState state) {
        java.util.List<? extends StatementTree> statements = block.getStatements();
        if (statements.isEmpty()) {
            return "";
        }
        int start = ((JCTree)((Object)statements.get(0))).getStartPosition();
        int end = state.getEndPosition((Tree)Iterables.getLast(statements));
        return state.getSourceCode().subSequence(start, end);
    }

    public Description matchIf(IfTree tree, VisitorState state) {
        Optional defaultBranch;
        IfTree ifTree;
        if (state.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.IF) {
            return Description.NO_MATCH;
        }
        ArrayList<String> stringConstants = new ArrayList<String>();
        ArrayList<JCTree.JCBlock> branches = new ArrayList<JCTree.JCBlock>();
        IdentifierTree var = null;
        StatementTree statementTree = tree;
        do {
            ExpressionTree rhs;
            ExpressionTree lhs;
            JCTree.JCExpression cond;
            if (EQUALS.matches((Tree)(cond = TreeInfo.skipParens((JCTree.JCExpression)(ifTree = statementTree).getCondition())), state)) {
                MethodInvocationTree call = (MethodInvocationTree)((Object)cond);
                lhs = ASTHelpers.getReceiver((ExpressionTree)call);
                rhs = (ExpressionTree)Iterables.getOnlyElement(call.getArguments());
            } else if (cond.getKind().equals((Object)Tree.Kind.EQUAL_TO)) {
                BinaryTree equalTo = (BinaryTree)((Object)cond);
                lhs = equalTo.getLeftOperand();
                rhs = equalTo.getRightOperand();
            } else {
                return Description.NO_MATCH;
            }
            if (!(lhs instanceof IdentifierTree)) {
                return Description.NO_MATCH;
            }
            IdentifierTree identifierTree = (IdentifierTree)lhs;
            if (var == null) {
                var = identifierTree;
            } else if (!identifierTree.getName().equals(var.getName()) || !AbstractUseSwitch.isValidCaseBlock(ifTree.getThenStatement())) {
                return Description.NO_MATCH;
            }
            String expressionForCase = this.getExpressionForCase(state, rhs);
            if (expressionForCase == null) {
                return Description.NO_MATCH;
            }
            stringConstants.add(expressionForCase);
            if (ifTree.getThenStatement().getKind() == Tree.Kind.BLOCK) {
                branches.add((JCTree.JCBlock)ifTree.getThenStatement());
                continue;
            }
            TreeMaker maker = TreeMaker.instance(state.context);
            branches.add(maker.Block(0L, List.of((JCTree.JCStatement)ifTree.getThenStatement())));
        } while ((statementTree = ifTree.getElseStatement()) instanceof IfTree);
        Optional optional = defaultBranch = statementTree instanceof JCTree.JCBlock ? Optional.of((Object)((JCTree.JCBlock)statementTree)) : Optional.absent();
        if (stringConstants.size() + defaultBranch.asSet().size() < 3) {
            return Description.NO_MATCH;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("switch (").append(var.getName()).append(") {\n");
        for (int i = 0; i < stringConstants.size(); ++i) {
            builder.append("case ").append((String)stringConstants.get(i)).append(":\n").append(AbstractUseSwitch.getBlockContents((BlockTree)branches.get(i), state));
            if (!Reachability.canCompleteNormally((StatementTree)((StatementTree)branches.get(i)))) continue;
            builder.append("\nbreak;\n");
        }
        builder.append("default:\n").append(defaultBranch.isPresent() ? AbstractUseSwitch.getBlockContents((BlockTree)defaultBranch.get(), state) : "// fall through").append("\n}");
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)builder.toString()));
    }
}

