/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.EqualsHashCode;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(name="HashCodeToString", summary="Classes that override hashCode should also consider overriding toString.", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"FragileCode"})
public class HashCodeToString
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodTree> NON_TRIVIAL_HASHCODE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hashCodeMethodDeclaration(), Matchers.not((Matcher)Matchers.singleStatementReturnMatcher((Matcher)Matchers.instanceHashCodeInvocation()))});

    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (ASTHelpers.hasAnnotation((Tree)classTree, (String)"com.google.auto.value.AutoValue", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        MethodTree methodTree = EqualsHashCode.checkMethodPresence(classTree, state, NON_TRIVIAL_HASHCODE, "toString");
        if (methodTree == null || this.isSuppressed(methodTree)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodTree);
    }
}

