/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_ParameterName_FixInfo;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NamedParameterComment;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Comments;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.regex.Matcher;

@BugPattern(name="ParameterName", summary="Detects `/* name= */`-style comments on actual parameters where the name doesn't match the formal parameter", severity=BugPattern.SeverityLevel.WARNING)
public class ParameterName
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private final ImmutableList<String> exemptPackages;

    public ParameterName() {
        this(ErrorProneFlags.empty());
    }

    public ParameterName(ErrorProneFlags errorProneFlags) {
        this.exemptPackages = (ImmutableList)((java.util.List)errorProneFlags.getList("ParameterName:exemptPackagePrefixes").orElse(ImmutableList.of())).stream().map(p -> p.endsWith(".") ? p : p + ".").collect(ImmutableList.toImmutableList());
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        this.checkArguments(tree, tree.getArguments(), state);
        return Description.NO_MATCH;
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        this.checkArguments(tree, tree.getArguments(), state);
        return Description.NO_MATCH;
    }

    private void checkArguments(Tree tree, java.util.List<? extends ExpressionTree> arguments, VisitorState state) {
        if (arguments.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol sym = (Symbol.MethodSymbol)ASTHelpers.getSymbol((Tree)tree);
        if (NamedParameterComment.containsSyntheticParameterName(sym)) {
            return;
        }
        int start = ASTHelpers.getStartPosition((Tree)tree);
        int end = state.getEndPosition((Tree)Iterables.getLast(arguments));
        if (start == -1 || end == -1) {
            return;
        }
        String source = state.getSourceCode().subSequence(start, end).toString();
        if (!source.contains("/*")) {
            return;
        }
        String enclosingClass = ASTHelpers.enclosingClass((Symbol)sym).toString();
        if (this.exemptPackages.stream().anyMatch(enclosingClass::startsWith)) {
            return;
        }
        ArrayDeque<ErrorProneToken> tokens = new ArrayDeque<ErrorProneToken>((Collection<ErrorProneToken>)ErrorProneTokens.getTokens((String)source, (int)start, (Context)state.context));
        Streams.forEachPair(sym.getParameters().stream(), arguments.stream(), (p, a) -> {
            if (ParameterName.advanceTokens(tokens, a, state)) {
                this.checkArgument((Symbol.VarSymbol)p, (ExpressionTree)a, (ErrorProneToken)tokens.removeFirst(), state);
            }
        });
        int numParams = ((List)sym.getParameters()).size();
        int numArgs = arguments.size();
        if (numParams < numArgs) {
            for (ExpressionTree expressionTree : arguments.subList(numParams, numArgs)) {
                if (!ParameterName.advanceTokens(tokens, expressionTree, state)) continue;
                this.checkComment(expressionTree, (ErrorProneToken)tokens.removeFirst(), state);
            }
        }
    }

    private static boolean advanceTokens(Deque<ErrorProneToken> tokens, ExpressionTree actual, VisitorState state) {
        while (!tokens.isEmpty() && tokens.getFirst().pos() < ASTHelpers.getStartPosition((Tree)actual)) {
            tokens.removeFirst();
        }
        if (tokens.isEmpty()) {
            return false;
        }
        Range argRange = Range.closedOpen((Comparable)Integer.valueOf(ASTHelpers.getStartPosition((Tree)actual)), (Comparable)Integer.valueOf(state.getEndPosition((Tree)actual)));
        return argRange.contains((Comparable)Integer.valueOf(tokens.getFirst().pos()));
    }

    private void checkArgument(Symbol.VarSymbol formal, ExpressionTree actual, ErrorProneToken token, VisitorState state) {
        ArrayList<FixInfo> matches = new ArrayList<FixInfo>();
        for (Tokens.Comment comment : token.comments()) {
            Matcher m = NamedParameterComment.PARAMETER_COMMENT_PATTERN.matcher(Comments.getTextFromComment((Tokens.Comment)comment));
            if (!m.matches()) continue;
            boolean isFormatCorrect = ParameterName.isVarargs(formal) ^ Strings.isNullOrEmpty((String)m.group(2));
            String name = m.group(1);
            boolean isNameCorrect = ((Name)formal.getSimpleName()).contentEquals(name);
            if (isNameCorrect && isFormatCorrect) {
                matches.clear();
                break;
            }
            matches.add(FixInfo.create(isFormatCorrect, isNameCorrect, comment, name));
        }
        String fixTemplate = ParameterName.isVarargs(formal) ? "/* %s...= */" : "/* %s= */";
        for (FixInfo match : matches) {
            Description description;
            SuggestedFix rewriteCommentFix = ParameterName.rewriteComment(match.comment(), String.format(fixTemplate, formal.getSimpleName()));
            SuggestedFix rewriteToRegularCommentFix = ParameterName.rewriteComment(match.comment(), String.format("/* %s */", match.name()));
            if (match.isFormatCorrect() && !match.isNameCorrect()) {
                description = this.buildDescription(actual).setMessage(String.format("`%s` does not match formal parameter name `%s`; either fix the name or use a regular comment", match.comment().getText(), formal.getSimpleName())).addFix((Fix)rewriteCommentFix).addFix((Fix)rewriteToRegularCommentFix).build();
            } else if (!match.isFormatCorrect() && match.isNameCorrect()) {
                description = this.buildDescription(actual).setMessage(String.format("parameter name comment `%s` uses incorrect format", match.comment().getText())).addFix((Fix)rewriteCommentFix).build();
            } else if (!match.isFormatCorrect() && !match.isNameCorrect()) {
                description = this.buildDescription(actual).setMessage(String.format("`%s` does not match formal parameter name `%s` and uses incorrect format; either fix the format or use a regular comment", match.comment().getText(), formal.getSimpleName())).addFix((Fix)rewriteCommentFix).addFix((Fix)rewriteToRegularCommentFix).build();
            } else {
                throw new AssertionError((Object)("Unexpected match with both isNameCorrect and isFormatCorrect true: " + match));
            }
            state.reportMatch(description);
        }
    }

    private static SuggestedFix rewriteComment(Tokens.Comment comment, String format) {
        int replacementStartPos = comment.getSourcePos(0);
        int replacementEndPos = comment.getSourcePos(comment.getText().length() - 1) + 1;
        return SuggestedFix.replace((int)replacementStartPos, (int)replacementEndPos, (String)format);
    }

    private void checkComment(ExpressionTree arg, ErrorProneToken token, VisitorState state) {
        for (Tokens.Comment comment : token.comments()) {
            Matcher m = NamedParameterComment.PARAMETER_COMMENT_PATTERN.matcher(Comments.getTextFromComment((Tokens.Comment)comment));
            if (!m.matches()) continue;
            SuggestedFix rewriteCommentFix = ParameterName.rewriteComment(comment, String.format("/* %s%s */", m.group(1), MoreObjects.firstNonNull((Object)m.group(2), (Object)"")));
            state.reportMatch(this.buildDescription(arg).addFix((Fix)rewriteCommentFix).setMessage("parameter name comment only allowed on first varargs argument").build());
        }
    }

    private static boolean isVarargs(Symbol.VarSymbol sym) {
        Preconditions.checkArgument((boolean)(sym.owner instanceof Symbol.MethodSymbol), (Object)"sym must be a parameter to a method");
        Symbol.MethodSymbol method = (Symbol.MethodSymbol)sym.owner;
        return method.isVarArgs() && ((List)method.getParameters()).last() == sym;
    }

    @AutoValue
    static abstract class FixInfo {
        FixInfo() {
        }

        abstract boolean isFormatCorrect();

        abstract boolean isNameCorrect();

        abstract Tokens.Comment comment();

        abstract String name();

        static FixInfo create(boolean isFormatCorrect, boolean isNameCorrect, Tokens.Comment comment, String name) {
            return new AutoValue_ParameterName_FixInfo(isFormatCorrect, isNameCorrect, comment, name);
        }
    }
}

