/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.FixedPosition;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.ArrayList;
import java.util.stream.Stream;

@BugPattern(name="UnicodeInCode", severity=BugPattern.SeverityLevel.ERROR, summary="Avoid using non-ASCII Unicode characters outside of comments and literals, as they can be confusing.")
public final class UnicodeInCode
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableRangeSet<Integer> commentsAndLiterals = UnicodeInCode.commentsAndLiterals(state);
        ArrayList<Integer> violatingLocations = new ArrayList<Integer>();
        CharSequence sourceCode = state.getSourceCode();
        for (int i = 0; i < sourceCode.length(); ++i) {
            char c = sourceCode.charAt(i);
            if (UnicodeInCode.isAcceptableAscii(c) || commentsAndLiterals.contains((Comparable)Integer.valueOf(i))) continue;
            violatingLocations.add(i);
        }
        if (violatingLocations.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableRangeSet suppressedRegions = this.suppressedRegions(state);
        for (Integer violatingLocation : violatingLocations) {
            if (suppressedRegions.contains((Comparable)violatingLocation)) continue;
            state.reportMatch(this.describeMatch((JCDiagnostic.DiagnosticPosition)new FixedPosition((Tree)tree, violatingLocation.intValue())));
        }
        return Description.NO_MATCH;
    }

    private static boolean isAcceptableAscii(char c) {
        return c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t';
    }

    private static ImmutableRangeSet<Integer> commentsAndLiterals(VisitorState state) {
        ImmutableList tokens = ErrorProneTokens.getTokens((String)state.getSourceCode().toString(), (Context)state.context);
        return ImmutableRangeSet.unionOf((Iterable)((Iterable)Streams.concat((Stream[])new Stream[]{tokens.stream().filter(t -> t.kind().equals(Tokens.TokenKind.STRINGLITERAL) || t.kind().equals(Tokens.TokenKind.CHARLITERAL)).map(t -> Range.closed((Comparable)Integer.valueOf(t.pos()), (Comparable)Integer.valueOf(t.endPos()))), tokens.stream().flatMap(t -> t.comments().stream()).map(c -> Range.closed((Comparable)Integer.valueOf(c.getSourcePos(0)), (Comparable)Integer.valueOf(c.getSourcePos(0) + c.getText().length())))}).collect(ImmutableList.toImmutableList())));
    }
}

