/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.FieldMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.stream.Stream;

@BugPattern(name="JodaDateTimeConstants", summary="Using the `_PER_` constants in `DateTimeConstants` is problematic because they encourage manual date/time math.", explanation="Manual date/time math leads to overflows, unit mismatches, and weak typing. Prefer to use strong types (e.g., `java.time.Duration` or `java.time.Instant`) and their APIs to perform date/time math.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaDateTimeConstants
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher,
BugChecker.IdentifierTreeMatcher {
    private static final Matcher<ExpressionTree> DATE_TIME_CONSTANTS_MATCHER = Matchers.anyOf((Iterable)((Iterable)Stream.of("HOURS_PER_DAY", "HOURS_PER_WEEK", "MILLIS_PER_DAY", "MILLIS_PER_HOUR", "MILLIS_PER_MINUTE", "MILLIS_PER_SECOND", "MILLIS_PER_WEEK", "MINUTES_PER_DAY", "MINUTES_PER_HOUR", "MINUTES_PER_WEEK", "SECONDS_PER_DAY", "SECONDS_PER_HOUR", "SECONDS_PER_MINUTE", "SECONDS_PER_WEEK").map(constant -> FieldMatchers.staticField((String)"org.joda.time.DateTimeConstants", (String)constant)).collect(ImmutableSet.toImmutableSet())));

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    private Description match(ExpressionTree tree, VisitorState state) {
        return DATE_TIME_CONSTANTS_MATCHER.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

