/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="PeriodTimeMath", summary="When adding or subtracting from a Period, Duration is incompatible.", explanation="Period.(plus|minus)(TemporalAmount) will always throw a DateTimeException when passed a Duration.", severity=BugPattern.SeverityLevel.ERROR)
public final class PeriodTimeMath
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private final Matcher<MethodInvocationTree> matcherToCheck;
    private static final Matcher<ExpressionTree> PERIOD_MATH = Matchers.instanceMethod().onExactClass("java.time.Period").namedAnyOf(new String[]{"plus", "minus"});
    private static final Matcher<ExpressionTree> DURATION = Matchers.isSameType((String)"java.time.Duration");
    private static final Matcher<ExpressionTree> PERIOD = Matchers.isSameType((String)"java.time.Period");

    public PeriodTimeMath(ErrorProneFlags flags) {
        boolean requireStrictCompatibility = flags.getBoolean("PeriodTimeMath:RequireStaticPeriodArgument").orElse(false);
        this.matcherToCheck = Matchers.allOf((Matcher[])new Matcher[]{PERIOD_MATH, Matchers.argument((int)0, (Matcher)(requireStrictCompatibility ? Matchers.not(PERIOD) : DURATION))});
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.matcherToCheck.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

