/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Node;
import lombok.ast.Statement;

public class Throw
extends AbstractNode
implements Statement {
    private AbstractNode throwable = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astThrowable() {
        if (!(this.throwable instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.throwable);
    }

    public Throw astThrowable(Expression throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is mandatory");
        }
        return this.rawThrowable(throwable);
    }

    public Node rawThrowable() {
        return this.throwable;
    }

    public Throw rawThrowable(Node throwable) {
        if (throwable == this.throwable) {
            return this;
        }
        if (throwable != null) {
            this.adopt((AbstractNode)throwable);
        }
        if (this.throwable != null) {
            this.disown(this.throwable);
        }
        this.throwable = (AbstractNode)throwable;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.throwable != null) {
            result.add(this.throwable);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.throwable == original) {
            this.rawThrowable(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.throwable == child) {
            this.disown((AbstractNode)child);
            this.throwable = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitThrow(this)) {
            return;
        }
        if (this.throwable != null) {
            this.throwable.accept(visitor);
        }
        visitor.afterVisitThrow(this);
        visitor.endVisit(this);
    }

    @Override
    public Throw copy() {
        Throw result = new Throw();
        if (this.throwable != null) {
            result.rawThrowable(this.throwable.copy());
        }
        return result;
    }
}

