/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableSortedSet;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

class ImmutableSortedSetCodec<E>
implements ObjectCodec<ImmutableSortedSet<E>> {
    ImmutableSortedSetCodec() {
    }

    @Override
    public Class<ImmutableSortedSet<E>> getEncodedClass() {
        return ImmutableSortedSet.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableSortedSet<E> object, CodedOutputStream codedOut) throws SerializationException, IOException {
        context.serialize(object.comparator(), codedOut);
        codedOut.writeInt32NoTag(object.size());
        for (Object obj : object) {
            context.serialize(obj, codedOut);
        }
    }

    @Override
    public ImmutableSortedSet<E> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        Comparator comparator = (Comparator)context.deserialize(codedIn);
        int size = codedIn.readInt32();
        Object[] sortedElementsArray = new Object[size];
        for (int i = 0; i < size; ++i) {
            sortedElementsArray[i] = context.deserialize(codedIn);
        }
        SortedSetShimForEfficientDeserialization sortedSetShimForEfficientDeserialization = new SortedSetShimForEfficientDeserialization(comparator, sortedElementsArray);
        return ImmutableSortedSet.copyOfSorted(sortedSetShimForEfficientDeserialization);
    }

    private static class SortedSetShimForEfficientDeserialization<E>
    implements SortedSet<E> {
        private final Comparator<E> comparator;
        private final Object[] sortedElementsArray;

        private SortedSetShimForEfficientDeserialization(Comparator<E> comparator, Object[] sortedElementsArray) {
            this.comparator = comparator;
            this.sortedElementsArray = sortedElementsArray;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.comparator;
        }

        @Override
        public Object[] toArray() {
            return this.sortedElementsArray;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E first() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E e) {
            return false;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

