/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;

public class SessionInfoStore
implements ISessionInfoVisitor {
    private final List<SessionInfo> infos = new ArrayList<SessionInfo>();

    public boolean isEmpty() {
        return this.infos.isEmpty();
    }

    public List<SessionInfo> getInfos() {
        ArrayList<SessionInfo> copy = new ArrayList<SessionInfo>(this.infos);
        Collections.sort(copy);
        return copy;
    }

    public SessionInfo getMerged(String id) {
        if (this.infos.isEmpty()) {
            return new SessionInfo(id, 0L, 0L);
        }
        long start = Long.MAX_VALUE;
        long dump = Long.MIN_VALUE;
        for (SessionInfo i : this.infos) {
            start = Math.min(start, i.getStartTimeStamp());
            dump = Math.max(dump, i.getDumpTimeStamp());
        }
        return new SessionInfo(id, start, dump);
    }

    public void accept(ISessionInfoVisitor visitor) {
        for (SessionInfo i : this.getInfos()) {
            visitor.visitSessionInfo(i);
        }
    }

    @Override
    public void visitSessionInfo(SessionInfo info) {
        this.infos.add(info);
    }
}

