/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.text;

import com.github.difflib.DiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiffRowGenerator {
    public static final BiPredicate<String, String> DEFAULT_EQUALIZER = Object::equals;
    public static final BiPredicate<String, String> IGNORE_WHITESPACE_EQUALIZER = (original, revised) -> DiffRowGenerator.adjustWhitespace(original).equals(DiffRowGenerator.adjustWhitespace(revised));
    public static final Function<String, List<String>> SPLITTER_BY_CHARACTER = line -> {
        ArrayList<String> list = new ArrayList<String>(line.length());
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            list.add(character.toString());
        }
        return list;
    };
    public static final Pattern SPLIT_BY_WORD_PATTERN = Pattern.compile("\\s+|[,.\\[\\](){}/\\\\*+\\-#]");
    public static final Function<String, List<String>> SPLITTER_BY_WORD = line -> DiffRowGenerator.splitStringPreserveDelimiter(line, SPLIT_BY_WORD_PATTERN);
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private final int columnWidth;
    private final BiPredicate<String, String> equalizer;
    private final boolean ignoreWhiteSpaces;
    private final Function<String, List<String>> inlineDiffSplitter;
    private final boolean mergeOriginalRevised;
    private final Function<Boolean, String> newTag;
    private final Function<Boolean, String> oldTag;
    private final boolean reportLinesUnchanged;
    private final boolean showInlineDiffs;

    public static Builder create() {
        return new Builder();
    }

    private static String adjustWhitespace(String raw) {
        return WHITESPACE_PATTERN.matcher(raw.trim()).replaceAll(" ");
    }

    protected static final List<String> splitStringPreserveDelimiter(String str, Pattern SPLIT_PATTERN) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            Matcher matcher = SPLIT_PATTERN.matcher(str);
            int pos = 0;
            while (matcher.find()) {
                if (pos < matcher.start()) {
                    list.add(str.substring(pos, matcher.start()));
                }
                list.add(matcher.group());
                pos = matcher.end();
            }
            if (pos < str.length()) {
                list.add(str.substring(pos));
            }
        }
        return list;
    }

    static void wrapInTag(List<String> sequence, int startPosition, int endPosition, Function<Boolean, String> tagGenerator) {
        for (int endPos = endPosition; endPos >= startPosition; --endPos) {
            while (endPos > startPosition && "\n".equals(sequence.get(endPos - 1))) {
                --endPos;
            }
            if (endPos == startPosition) break;
            sequence.add(endPos, tagGenerator.apply(false));
            --endPos;
            while (endPos > startPosition && !"\n".equals(sequence.get(endPos - 1))) {
                --endPos;
            }
            sequence.add(endPos, tagGenerator.apply(true));
        }
    }

    private DiffRowGenerator(Builder builder) {
        this.showInlineDiffs = builder.showInlineDiffs;
        this.ignoreWhiteSpaces = builder.ignoreWhiteSpaces;
        this.oldTag = builder.oldTag;
        this.newTag = builder.newTag;
        this.columnWidth = builder.columnWidth;
        this.mergeOriginalRevised = builder.mergeOriginalRevised;
        this.inlineDiffSplitter = builder.inlineDiffSplitter;
        this.equalizer = this.ignoreWhiteSpaces ? IGNORE_WHITESPACE_EQUALIZER : DEFAULT_EQUALIZER;
        this.reportLinesUnchanged = builder.reportLinesUnchanged;
        Objects.requireNonNull(this.inlineDiffSplitter);
    }

    public List<DiffRow> generateDiffRows(List<String> original, List<String> revised) throws DiffException {
        return this.generateDiffRows(original, DiffUtils.diff(original, revised, this.equalizer));
    }

    public List<DiffRow> generateDiffRows(List<String> original, Patch<String> patch) throws DiffException {
        ArrayList<DiffRow> diffRows = new ArrayList<DiffRow>();
        int endPos = 0;
        List<AbstractDelta<String>> deltaList = patch.getDeltas();
        for (int i = 0; i < deltaList.size(); ++i) {
            AbstractDelta<String> delta = deltaList.get(i);
            Chunk<String> orig = delta.getSource();
            Chunk<String> rev = delta.getTarget();
            for (String line : original.subList(endPos, orig.getPosition())) {
                diffRows.add(this.buildDiffRow(DiffRow.Tag.EQUAL, line, line));
            }
            if (delta instanceof InsertDelta) {
                endPos = orig.last() + 1;
                for (String line : rev.getLines()) {
                    diffRows.add(this.buildDiffRow(DiffRow.Tag.INSERT, "", line));
                }
                continue;
            }
            if (delta instanceof DeleteDelta) {
                endPos = orig.last() + 1;
                for (String line : orig.getLines()) {
                    diffRows.add(this.buildDiffRow(DiffRow.Tag.DELETE, line, ""));
                }
                continue;
            }
            if (this.showInlineDiffs) {
                diffRows.addAll(this.generateInlineDiffs(delta));
            } else {
                for (int j = 0; j < Math.max(orig.size(), rev.size()); ++j) {
                    diffRows.add(this.buildDiffRow(DiffRow.Tag.CHANGE, orig.getLines().size() > j ? orig.getLines().get(j) : "", rev.getLines().size() > j ? rev.getLines().get(j) : ""));
                }
            }
            endPos = orig.last() + 1;
        }
        for (String line : original.subList(endPos, original.size())) {
            diffRows.add(this.buildDiffRow(DiffRow.Tag.EQUAL, line, line));
        }
        return diffRows;
    }

    private DiffRow buildDiffRow(DiffRow.Tag type, String orgline, String newline) {
        if (this.reportLinesUnchanged) {
            return new DiffRow(type, orgline, newline);
        }
        String wrapOrg = this.preprocessLine(orgline);
        if (DiffRow.Tag.DELETE == type && (this.mergeOriginalRevised || this.showInlineDiffs)) {
            wrapOrg = this.oldTag.apply(true) + wrapOrg + this.oldTag.apply(false);
        }
        String wrapNew = this.preprocessLine(newline);
        if (DiffRow.Tag.INSERT == type) {
            if (this.mergeOriginalRevised) {
                wrapOrg = this.newTag.apply(true) + wrapNew + this.newTag.apply(false);
            } else if (this.showInlineDiffs) {
                wrapNew = this.newTag.apply(true) + wrapNew + this.newTag.apply(false);
            }
        }
        return new DiffRow(type, wrapOrg, wrapNew);
    }

    private DiffRow buildDiffRowWithoutNormalizing(DiffRow.Tag type, String orgline, String newline) {
        return new DiffRow(type, StringUtils.wrapText(orgline, this.columnWidth), StringUtils.wrapText(newline, this.columnWidth));
    }

    private List<DiffRow> generateInlineDiffs(AbstractDelta<String> delta) throws DiffException {
        List<String> orig = StringUtils.normalize(delta.getSource().getLines());
        List<String> rev = StringUtils.normalize(delta.getTarget().getLines());
        String joinedOrig = String.join((CharSequence)"\n", orig);
        String joinedRev = String.join((CharSequence)"\n", rev);
        List<String> origList = this.inlineDiffSplitter.apply(joinedOrig);
        List<String> revList = this.inlineDiffSplitter.apply(joinedRev);
        List<AbstractDelta<String>> inlineDeltas = DiffUtils.diff(origList, revList).getDeltas();
        Collections.reverse(inlineDeltas);
        for (AbstractDelta<String> inlineDelta : inlineDeltas) {
            Iterator<String> inlineOrig = inlineDelta.getSource();
            Chunk<String> inlineRev = inlineDelta.getTarget();
            if (inlineDelta instanceof DeleteDelta) {
                DiffRowGenerator.wrapInTag(origList, ((Chunk)((Object)inlineOrig)).getPosition(), ((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size(), this.oldTag);
                continue;
            }
            if (inlineDelta instanceof InsertDelta) {
                if (this.mergeOriginalRevised) {
                    origList.addAll(((Chunk)((Object)inlineOrig)).getPosition(), revList.subList(inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size()));
                    DiffRowGenerator.wrapInTag(origList, ((Chunk)((Object)inlineOrig)).getPosition(), ((Chunk)((Object)inlineOrig)).getPosition() + inlineRev.size(), this.newTag);
                    continue;
                }
                DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size(), this.newTag);
                continue;
            }
            if (!(inlineDelta instanceof ChangeDelta)) continue;
            if (this.mergeOriginalRevised) {
                origList.addAll(((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size(), revList.subList(inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size()));
                DiffRowGenerator.wrapInTag(origList, ((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size(), ((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size() + inlineRev.size(), this.newTag);
            } else {
                DiffRowGenerator.wrapInTag(revList, inlineRev.getPosition(), inlineRev.getPosition() + inlineRev.size(), this.newTag);
            }
            DiffRowGenerator.wrapInTag(origList, ((Chunk)((Object)inlineOrig)).getPosition(), ((Chunk)((Object)inlineOrig)).getPosition() + ((Chunk)((Object)inlineOrig)).size(), this.oldTag);
        }
        StringBuilder origResult = new StringBuilder();
        StringBuilder revResult = new StringBuilder();
        for (String character : origList) {
            origResult.append(character);
        }
        for (String character : revList) {
            revResult.append(character);
        }
        List<String> original = Arrays.asList(origResult.toString().split("\n"));
        List<String> revised = Arrays.asList(revResult.toString().split("\n"));
        ArrayList<DiffRow> diffRows = new ArrayList<DiffRow>();
        for (int j = 0; j < Math.max(original.size(), revised.size()); ++j) {
            diffRows.add(this.buildDiffRowWithoutNormalizing(DiffRow.Tag.CHANGE, original.size() > j ? original.get(j) : "", revised.size() > j ? revised.get(j) : ""));
        }
        return diffRows;
    }

    private String preprocessLine(String line) {
        if (this.columnWidth == 0) {
            return StringUtils.normalize(line);
        }
        return StringUtils.wrapText(StringUtils.normalize(line), this.columnWidth);
    }

    public static class Builder {
        private boolean showInlineDiffs = false;
        private boolean ignoreWhiteSpaces = false;
        private Function<Boolean, String> oldTag = f -> f != false ? "<span class=\"editOldInline\">" : "</span>";
        private Function<Boolean, String> newTag = f -> f != false ? "<span class=\"editNewInline\">" : "</span>";
        private int columnWidth = 0;
        private boolean mergeOriginalRevised = false;
        private boolean reportLinesUnchanged = false;
        private Function<String, List<String>> inlineDiffSplitter = SPLITTER_BY_CHARACTER;

        private Builder() {
        }

        public Builder showInlineDiffs(boolean val) {
            this.showInlineDiffs = val;
            return this;
        }

        public Builder ignoreWhiteSpaces(boolean val) {
            this.ignoreWhiteSpaces = val;
            return this;
        }

        public Builder reportLinesUnchanged(boolean val) {
            this.reportLinesUnchanged = val;
            return this;
        }

        public Builder oldTag(Function<Boolean, String> generator) {
            this.oldTag = generator;
            return this;
        }

        public Builder newTag(Function<Boolean, String> generator) {
            this.newTag = generator;
            return this;
        }

        public Builder columnWidth(int width) {
            if (width >= 0) {
                this.columnWidth = width;
            }
            return this;
        }

        public DiffRowGenerator build() {
            return new DiffRowGenerator(this);
        }

        public Builder mergeOriginalRevised(boolean mergeOriginalRevised) {
            this.mergeOriginalRevised = mergeOriginalRevised;
            return this;
        }

        public Builder inlineDiffByWord(boolean inlineDiffByWord) {
            this.inlineDiffSplitter = inlineDiffByWord ? SPLITTER_BY_WORD : SPLITTER_BY_CHARACTER;
            return this;
        }

        public Builder inlineDiffBySplitter(Function<String, List<String>> inlineDiffSplitter) {
            this.inlineDiffSplitter = inlineDiffSplitter;
            return this;
        }
    }
}

