/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.analysis;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import javax.lang.model.element.Element;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.errorprone.checker.interning.qual.FindDistinct;
import org.checkerframework.errorprone.checker.interning.qual.InternedDistinct;
import org.checkerframework.errorprone.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.errorprone.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.errorprone.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;
import org.checkerframework.errorprone.dataflow.analysis.Analysis;
import org.checkerframework.errorprone.dataflow.analysis.AnalysisResult;
import org.checkerframework.errorprone.dataflow.analysis.RegularTransferResult;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.analysis.TransferFunction;
import org.checkerframework.errorprone.dataflow.analysis.TransferInput;
import org.checkerframework.errorprone.dataflow.analysis.TransferResult;
import org.checkerframework.errorprone.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.errorprone.dataflow.cfg.block.Block;
import org.checkerframework.errorprone.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.errorprone.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.javacutil.BugInCF;
import org.checkerframework.errorprone.javacutil.ElementUtils;

public abstract class AbstractAnalysis<V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>>
implements Analysis<V, S, T> {
    protected final Analysis.Direction direction;
    protected boolean isRunning = false;
    protected @Nullable T transferFunction;
    protected @MonotonicNonNull ControlFlowGraph cfg;
    protected final IdentityHashMap<Block, TransferInput<V, S>> inputs = new IdentityHashMap();
    protected final Worklist worklist;
    protected final IdentityHashMap<Node, V> nodeValues = new IdentityHashMap();
    protected final HashMap<Element, V> finalLocalValues = new HashMap();
    protected @InternedDistinct @Nullable Node currentNode;
    protected @InternedDistinct @Nullable Tree currentTree;
    protected @Nullable TransferInput<V, S> currentInput;

    public @Nullable Tree getCurrentTree() {
        return this.currentTree;
    }

    public void setCurrentTree(@FindDistinct Tree currentTree) {
        this.currentTree = currentTree;
    }

    protected void setCurrentNode(@FindDistinct @Nullable Node currentNode) {
        this.currentNode = currentNode;
    }

    protected AbstractAnalysis(Analysis.Direction direction) {
        this.direction = direction;
        this.worklist = new Worklist(this.direction);
    }

    @RequiresNonNull(value={"cfg"})
    protected abstract void initInitialInputs();

    protected abstract void propagateStoresTo(Block var1, Node var2, TransferInput<V, S> var3, Store.FlowRule var4, boolean var5);

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public Analysis.Direction getDirection() {
        return this.direction;
    }

    @Override
    @RequiresNonNull(value={"cfg"})
    public AnalysisResult<V, S> getResult() {
        if (this.isRunning) {
            throw new BugInCF("AbstractAnalysis::getResult() shouldn't be called when the analysis is running.");
        }
        return new AnalysisResult<V, S>(this.nodeValues, this.inputs, this.cfg.getTreeLookup(), this.cfg.getUnaryAssignNodeLookup(), this.finalLocalValues);
    }

    @Override
    public @Nullable T getTransferFunction() {
        return this.transferFunction;
    }

    @Override
    public @Nullable V getValue(Node n) {
        if (this.isRunning) {
            if (this.currentNode == null || this.currentNode == n || this.currentTree != null && this.currentTree == n.getTree()) {
                return null;
            }
            assert (!n.isLValue()) : "Did not expect an lvalue, but got " + n;
            if (this.currentNode == n || !this.currentNode.getOperands().contains(n) && !this.currentNode.getTransitiveOperands().contains(n)) {
                return null;
            }
        }
        return (V)((AbstractValue)this.nodeValues.get(n));
    }

    public IdentityHashMap<Node, V> getNodeValues() {
        return this.nodeValues;
    }

    void setNodeValues(IdentityHashMap<Node, V> in) {
        assert (!this.isRunning);
        this.nodeValues.clear();
        this.nodeValues.putAll(in);
    }

    @Override
    @RequiresNonNull(value={"cfg"})
    public @Nullable S getRegularExitStore() {
        SpecialBlock regularExitBlock = this.cfg.getRegularExitBlock();
        if (this.inputs.containsKey(regularExitBlock)) {
            return this.inputs.get(regularExitBlock).getRegularStore();
        }
        return null;
    }

    @Override
    @RequiresNonNull(value={"cfg"})
    public @Nullable S getExceptionalExitStore() {
        SpecialBlock exceptionalExitBlock = this.cfg.getExceptionalExitBlock();
        if (this.inputs.containsKey(exceptionalExitBlock)) {
            S exceptionalExitStore = this.inputs.get(exceptionalExitBlock).getRegularStore();
            return exceptionalExitStore;
        }
        return null;
    }

    public @Nullable Set<Node> getNodesForTree(Tree t2) {
        if (this.cfg == null) {
            return null;
        }
        return this.cfg.getNodesCorrespondingToTree(t2);
    }

    @Override
    public @Nullable V getValue(Tree t2) {
        if (t2 == this.currentTree) {
            return null;
        }
        Set<Node> nodesCorrespondingToTree = this.getNodesForTree(t2);
        if (nodesCorrespondingToTree == null) {
            return null;
        }
        AbstractValue merged = null;
        for (Node aNode : nodesCorrespondingToTree) {
            if (aNode.isLValue()) {
                return null;
            }
            V v = this.getValue(aNode);
            if (merged == null) {
                merged = (AbstractValue)v;
                continue;
            }
            if (v == null) continue;
            merged = merged.leastUpperBound(v);
        }
        return (V)merged;
    }

    public @Nullable MethodTree getContainingMethod(Tree t2) {
        if (this.cfg == null) {
            return null;
        }
        return this.cfg.getContainingMethod(t2);
    }

    public @Nullable ClassTree getContainingClass(Tree t2) {
        if (this.cfg == null) {
            return null;
        }
        return this.cfg.getContainingClass(t2);
    }

    protected TransferResult<V, S> callTransferFunction(Node node, TransferInput<V, S> transferInput) {
        Object resval;
        LocalVariableNode lhs;
        Element elem;
        AssignmentNode assignment;
        Node lhst;
        assert (this.transferFunction != null) : "@AssumeAssertion(nullness): invariant";
        if (node.isLValue()) {
            return new RegularTransferResult<Object, S>(null, transferInput.getRegularStore());
        }
        transferInput.node = node;
        this.setCurrentNode(node);
        TransferResult transferResult = (TransferResult)node.accept(this.transferFunction, transferInput);
        this.setCurrentNode(null);
        if (node instanceof AssignmentNode && (lhst = (assignment = (AssignmentNode)node).getTarget()) instanceof LocalVariableNode && ElementUtils.isEffectivelyFinal(elem = (lhs = (LocalVariableNode)lhst).getElement()) && (resval = transferResult.getResultValue()) != null) {
            this.finalLocalValues.put(elem, resval);
        }
        return transferResult;
    }

    protected final void init(ControlFlowGraph cfg) {
        this.initFields(cfg);
        this.initInitialInputs();
    }

    @EnsuresNonNull(value={"this.cfg"})
    protected void initFields(ControlFlowGraph cfg) {
        this.inputs.clear();
        this.nodeValues.clear();
        this.finalLocalValues.clear();
        this.cfg = cfg;
    }

    protected boolean updateNodeValues(Node node, TransferResult<V, S> transferResult) {
        V newVal = transferResult.getResultValue();
        boolean nodeValueChanged = false;
        if (newVal != null) {
            AbstractValue oldVal = (AbstractValue)this.nodeValues.get(node);
            this.nodeValues.put(node, newVal);
            nodeValueChanged = !Objects.equals(oldVal, newVal);
        }
        return nodeValueChanged || transferResult.storeChanged();
    }

    protected static <S> @Nullable S readFromStore(Map<Block, S> stores, Block b) {
        return stores.get(b);
    }

    protected void addToWorklist(Block b) {
        if (!this.worklist.contains(b)) {
            this.worklist.add(b);
        }
    }

    protected static class Worklist {
        protected final IdentityHashMap<Block, Integer> depthFirstOrder = new IdentityHashMap();
        protected final PriorityQueue<Block> queue;

        public Worklist(Analysis.Direction direction) {
            if (direction == Analysis.Direction.FORWARD) {
                this.queue = new PriorityQueue<Block>(new ForwardDFOComparator());
            } else if (direction == Analysis.Direction.BACKWARD) {
                this.queue = new PriorityQueue<Block>(new BackwardDFOComparator());
            } else {
                throw new BugInCF("Unexpected Direction meet: " + direction.name());
            }
        }

        public void process(ControlFlowGraph cfg) {
            this.depthFirstOrder.clear();
            int count = 1;
            for (Block b : cfg.getDepthFirstOrderedBlocks()) {
                this.depthFirstOrder.put(b, count++);
            }
            this.queue.clear();
        }

        @Pure
        @EnsuresNonNullIf(result=false, expression={"poll()"})
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public boolean contains(Block block) {
            return this.queue.contains(block);
        }

        public void add(Block block) {
            this.queue.add(block);
        }

        @Pure
        public @Nullable Block poll() {
            return this.queue.poll();
        }

        public String toString() {
            return "Worklist(" + this.queue + ")";
        }

        public class BackwardDFOComparator
        implements Comparator<Block> {
            @Override
            public int compare(Block b1, Block b2) {
                return Worklist.this.depthFirstOrder.get(b2) - Worklist.this.depthFirstOrder.get(b1);
            }
        }

        public class ForwardDFOComparator
        implements Comparator<Block> {
            @Override
            public int compare(Block b1, Block b2) {
                return Worklist.this.depthFirstOrder.get(b1) - Worklist.this.depthFirstOrder.get(b2);
            }
        }
    }
}

