/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.analysis;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.interning.qual.FindDistinct;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.errorprone.dataflow.analysis.AbstractAnalysis;
import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;
import org.checkerframework.errorprone.dataflow.analysis.Analysis;
import org.checkerframework.errorprone.dataflow.analysis.ForwardAnalysis;
import org.checkerframework.errorprone.dataflow.analysis.ForwardTransferFunction;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.analysis.TransferInput;
import org.checkerframework.errorprone.dataflow.analysis.TransferResult;
import org.checkerframework.errorprone.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.errorprone.dataflow.cfg.UnderlyingAST;
import org.checkerframework.errorprone.dataflow.cfg.block.Block;
import org.checkerframework.errorprone.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.errorprone.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.errorprone.dataflow.cfg.block.RegularBlock;
import org.checkerframework.errorprone.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.ReturnNode;
import org.checkerframework.errorprone.javacutil.BugInCF;
import org.checkerframework.errorprone.javacutil.Pair;
import org.checkerframework.errorprone.org.plumelib.util.CollectionsPlume;

public class ForwardAnalysisImpl<V extends AbstractValue<V>, S extends Store<S>, T extends ForwardTransferFunction<V, S>>
extends AbstractAnalysis<V, S, T>
implements ForwardAnalysis<V, S, T> {
    protected final @Nullable IdentityHashMap<Block, Integer> blockCount;
    protected final int maxCountBeforeWidening;
    protected final IdentityHashMap<Block, S> thenStores;
    protected final IdentityHashMap<Block, S> elseStores;
    protected final IdentityHashMap<ReturnNode, TransferResult<V, S>> storesAtReturnStatements;

    public ForwardAnalysisImpl(int maxCountBeforeWidening) {
        super(Analysis.Direction.FORWARD);
        this.maxCountBeforeWidening = maxCountBeforeWidening;
        this.blockCount = maxCountBeforeWidening == -1 ? null : new IdentityHashMap();
        this.thenStores = new IdentityHashMap();
        this.elseStores = new IdentityHashMap();
        this.storesAtReturnStatements = new IdentityHashMap();
    }

    public ForwardAnalysisImpl(@Nullable T transfer) {
        this(-1);
        this.transferFunction = transfer;
    }

    @Override
    public void performAnalysis(ControlFlowGraph cfg) {
        if (this.isRunning) {
            throw new BugInCF("ForwardAnalysisImpl::performAnalysis() shouldn't be called when the analysis is running.");
        }
        this.isRunning = true;
        try {
            this.init(cfg);
            while (!this.worklist.isEmpty()) {
                Block b = this.worklist.poll();
                this.performAnalysisBlock(b);
            }
        }
        finally {
            assert (this.isRunning);
            this.isRunning = false;
        }
    }

    @Override
    public void performAnalysisBlock(Block b) {
        switch (b.getType()) {
            case REGULAR_BLOCK: {
                RegularBlock rb = (RegularBlock)b;
                TransferInput<V, S> inputBefore = this.getInputBefore(rb);
                assert (inputBefore != null) : "@AssumeAssertion(nullness): invariant";
                this.currentInput = inputBefore.copy();
                Node lastNode = null;
                boolean addToWorklistAgain = false;
                for (Node n : rb.getNodes()) {
                    assert (this.currentInput != null) : "@AssumeAssertion(nullness): invariant";
                    TransferResult<V, S> transferResult = this.callTransferFunction(n, this.currentInput);
                    addToWorklistAgain |= this.updateNodeValues(n, transferResult);
                    this.currentInput = new TransferInput(n, this, transferResult);
                    lastNode = n;
                }
                assert (this.currentInput != null) : "@AssumeAssertion(nullness): invariant";
                Block succ = rb.getSuccessor();
                assert (succ != null) : "@AssumeAssertion(nullness): regular basic block without non-exceptional successor unexpected";
                this.propagateStoresTo(succ, lastNode, this.currentInput, rb.getFlowRule(), addToWorklistAgain);
                break;
            }
            case EXCEPTION_BLOCK: {
                ExceptionBlock eb = (ExceptionBlock)b;
                TransferInput<V, S> inputBefore = this.getInputBefore(eb);
                assert (inputBefore != null) : "@AssumeAssertion(nullness): invariant";
                this.currentInput = inputBefore.copy();
                Node node = eb.getNode();
                TransferResult<V, S> transferResult = this.callTransferFunction(node, this.currentInput);
                boolean addToWorklistAgain = this.updateNodeValues(node, transferResult);
                Block succ = eb.getSuccessor();
                if (succ != null) {
                    this.currentInput = new TransferInput(node, this, transferResult);
                    this.propagateStoresTo(succ, node, this.currentInput, eb.getFlowRule(), addToWorklistAgain);
                }
                for (Map.Entry<TypeMirror, Set<Block>> e : eb.getExceptionalSuccessors().entrySet()) {
                    TypeMirror cause = e.getKey();
                    S exceptionalStore = transferResult.getExceptionalStore(cause);
                    if (exceptionalStore != null) {
                        for (Block exceptionSucc : e.getValue()) {
                            this.addStoreBefore(exceptionSucc, node, exceptionalStore, Store.Kind.BOTH, addToWorklistAgain);
                        }
                        continue;
                    }
                    for (Block exceptionSucc : e.getValue()) {
                        this.addStoreBefore(exceptionSucc, node, inputBefore.copy().getRegularStore(), Store.Kind.BOTH, addToWorklistAgain);
                    }
                }
                break;
            }
            case CONDITIONAL_BLOCK: {
                ConditionalBlock cb = (ConditionalBlock)b;
                TransferInput<V, S> inputBefore = this.getInputBefore(cb);
                assert (inputBefore != null) : "@AssumeAssertion(nullness): invariant";
                TransferInput<V, S> input = inputBefore.copy();
                Block thenSucc = cb.getThenSuccessor();
                Block elseSucc = cb.getElseSuccessor();
                this.propagateStoresTo(thenSucc, null, input, cb.getThenFlowRule(), false);
                this.propagateStoresTo(elseSucc, null, input, cb.getElseFlowRule(), false);
                break;
            }
            case SPECIAL_BLOCK: {
                SpecialBlock sb = (SpecialBlock)b;
                Block succ = sb.getSuccessor();
                if (succ == null) break;
                TransferInput<V, S> input = this.getInputBefore(b);
                assert (input != null) : "@AssumeAssertion(nullness): invariant";
                this.propagateStoresTo(succ, null, input, sb.getFlowRule(), false);
                break;
            }
            default: {
                throw new BugInCF("Unexpected block type: " + (Object)((Object)b.getType()));
            }
        }
    }

    @Override
    public @Nullable TransferInput<V, S> getInput(Block b) {
        return this.getInputBefore(b);
    }

    @Override
    @RequiresNonNull(value={"cfg"})
    public List<Pair<ReturnNode, @Nullable TransferResult<V, S>>> getReturnStatementStores() {
        return CollectionsPlume.mapList(returnNode -> Pair.of(returnNode, this.storesAtReturnStatements.get(returnNode)), this.cfg.getReturnNodes());
    }

    @Override
    public S runAnalysisFor(@FindDistinct Node node, Analysis.BeforeOrAfter preOrPost, TransferInput<V, S> blockTransferInput, IdentityHashMap<Node, V> nodeValues, Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches) {
        Block block = node.getBlock();
        assert (block != null) : "@AssumeAssertion(nullness): invariant";
        Node oldCurrentNode = this.currentNode;
        IdentityHashMap cache = analysisCaches != null ? analysisCaches.computeIfAbsent(blockTransferInput, __ -> new IdentityHashMap()) : null;
        if (this.isRunning) {
            assert (this.currentInput != null) : "@AssumeAssertion(nullness): invariant";
            return this.currentInput.getRegularStore();
        }
        this.setNodeValues(nodeValues);
        this.isRunning = true;
        try {
            switch (block.getType()) {
                case REGULAR_BLOCK: {
                    RegularBlock rb = (RegularBlock)block;
                    TransferInput<V, Object> store = blockTransferInput;
                    for (Node n : rb.getNodes()) {
                        TransferResult transferResult;
                        this.setCurrentNode(n);
                        if (n == node && preOrPost == Analysis.BeforeOrAfter.BEFORE) {
                            S s2 = store.getRegularStore();
                            return s2;
                        }
                        if (cache != null && cache.containsKey(n)) {
                            transferResult = (TransferResult)cache.get(n);
                        } else {
                            transferResult = this.callTransferFunction(n, store.copy());
                            if (cache != null) {
                                cache.put(n, transferResult);
                            }
                        }
                        if (n == node) {
                            Object s3 = transferResult.getRegularStore();
                            return s3;
                        }
                        store = new TransferInput(n, this, transferResult);
                    }
                    throw new BugInCF("node %s is not in node.getBlock()=%s", node, block);
                }
                case EXCEPTION_BLOCK: {
                    TransferResult transferResult;
                    ExceptionBlock eb = (ExceptionBlock)block;
                    if (eb.getNode() != node) {
                        throw new BugInCF("Node should be equal to eb.getNode(). But get: node: " + node + "\teb.getNode(): " + eb.getNode());
                    }
                    if (preOrPost == Analysis.BeforeOrAfter.BEFORE) {
                        S store = blockTransferInput.getRegularStore();
                        return store;
                    }
                    this.setCurrentNode(node);
                    if (cache != null && cache.containsKey(node)) {
                        transferResult = (TransferResult)cache.get(node);
                    } else {
                        transferResult = this.callTransferFunction(node, blockTransferInput.copy());
                        if (cache != null) {
                            cache.put(node, transferResult);
                        }
                    }
                    Object s4 = transferResult.getRegularStore();
                    return s4;
                }
            }
            throw new BugInCF("Unexpected block type: " + (Object)((Object)block.getType()));
        }
        finally {
            this.setCurrentNode(oldCurrentNode);
            this.isRunning = false;
        }
    }

    @Override
    protected void initFields(ControlFlowGraph cfg) {
        this.thenStores.clear();
        this.elseStores.clear();
        if (this.blockCount != null) {
            this.blockCount.clear();
        }
        this.storesAtReturnStatements.clear();
        super.initFields(cfg);
    }

    @Override
    @RequiresNonNull(value={"cfg"})
    protected void initInitialInputs() {
        this.worklist.process(this.cfg);
        SpecialBlock entry = this.cfg.getEntryBlock();
        this.worklist.add(entry);
        UnderlyingAST underlyingAST = this.cfg.getUnderlyingAST();
        List<LocalVariableNode> parameters = this.getParameters(underlyingAST);
        assert (this.transferFunction != null) : "@AssumeAssertion(nullness): invariant";
        Object initialStore = ((ForwardTransferFunction)this.transferFunction).initialStore(underlyingAST, parameters);
        this.thenStores.put(entry, initialStore);
        this.elseStores.put(entry, initialStore);
        this.inputs.put(entry, new TransferInput(null, this, initialStore));
    }

    @SideEffectFree
    private List<LocalVariableNode> getParameters(UnderlyingAST underlyingAST) {
        switch (underlyingAST.getKind()) {
            case METHOD: {
                MethodTree tree = ((UnderlyingAST.CFGMethod)underlyingAST).getMethod();
                return CollectionsPlume.mapList(LocalVariableNode::new, tree.getParameters());
            }
            case LAMBDA: {
                LambdaExpressionTree lambda = ((UnderlyingAST.CFGLambda)underlyingAST).getLambdaTree();
                return CollectionsPlume.mapList(LocalVariableNode::new, lambda.getParameters());
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected TransferResult<V, S> callTransferFunction(Node node, TransferInput<V, S> input) {
        TransferResult<V, S> transferResult = super.callTransferFunction(node, input);
        if (node instanceof ReturnNode) {
            this.storesAtReturnStatements.put((ReturnNode)node, transferResult);
        }
        return transferResult;
    }

    @Override
    protected void propagateStoresTo(Block succ, @Nullable Node node, TransferInput<V, S> currentInput, Store.FlowRule flowRule, boolean addToWorklistAgain) {
        switch (flowRule) {
            case EACH_TO_EACH: {
                if (currentInput.containsTwoStores()) {
                    this.addStoreBefore(succ, node, currentInput.getThenStore(), Store.Kind.THEN, addToWorklistAgain);
                    this.addStoreBefore(succ, node, currentInput.getElseStore(), Store.Kind.ELSE, addToWorklistAgain);
                    break;
                }
                this.addStoreBefore(succ, node, currentInput.getRegularStore(), Store.Kind.BOTH, addToWorklistAgain);
                break;
            }
            case THEN_TO_BOTH: {
                this.addStoreBefore(succ, node, currentInput.getThenStore(), Store.Kind.BOTH, addToWorklistAgain);
                break;
            }
            case ELSE_TO_BOTH: {
                this.addStoreBefore(succ, node, currentInput.getElseStore(), Store.Kind.BOTH, addToWorklistAgain);
                break;
            }
            case THEN_TO_THEN: {
                this.addStoreBefore(succ, node, currentInput.getThenStore(), Store.Kind.THEN, addToWorklistAgain);
                break;
            }
            case ELSE_TO_ELSE: {
                this.addStoreBefore(succ, node, currentInput.getElseStore(), Store.Kind.ELSE, addToWorklistAgain);
                break;
            }
            case BOTH_TO_THEN: {
                this.addStoreBefore(succ, node, currentInput.getRegularStore(), Store.Kind.THEN, addToWorklistAgain);
                break;
            }
            case BOTH_TO_ELSE: {
                this.addStoreBefore(succ, node, currentInput.getRegularStore(), Store.Kind.ELSE, addToWorklistAgain);
            }
        }
    }

    protected void addStoreBefore(Block b, @Nullable Node node, S s2, Store.Kind kind, boolean addBlockToWorklist) {
        S thenStore = this.getStoreBefore(b, Store.Kind.THEN);
        S elseStore = this.getStoreBefore(b, Store.Kind.ELSE);
        boolean shouldWiden = false;
        if (this.blockCount != null) {
            Integer count = this.blockCount.getOrDefault(b, 0);
            boolean bl = shouldWiden = count >= this.maxCountBeforeWidening;
            if (shouldWiden) {
                this.blockCount.put(b, 0);
            } else {
                this.blockCount.put(b, count + 1);
            }
        }
        switch (kind) {
            case THEN: {
                S newThenStore = this.mergeStores(s2, thenStore, shouldWiden);
                if (newThenStore.equals(thenStore)) break;
                this.thenStores.put(b, newThenStore);
                if (elseStore == null) break;
                this.inputs.put(b, new TransferInput(node, this, newThenStore, elseStore));
                addBlockToWorklist = true;
                break;
            }
            case ELSE: {
                S newElseStore = this.mergeStores(s2, elseStore, shouldWiden);
                if (newElseStore.equals(elseStore)) break;
                this.elseStores.put(b, newElseStore);
                if (thenStore == null) break;
                this.inputs.put(b, new TransferInput(node, this, thenStore, newElseStore));
                addBlockToWorklist = true;
                break;
            }
            case BOTH: {
                S newElseStore;
                boolean sameStore;
                boolean bl = sameStore = thenStore == elseStore;
                if (sameStore) {
                    S newStore = this.mergeStores(s2, thenStore, shouldWiden);
                    if (newStore.equals(thenStore)) break;
                    this.thenStores.put(b, newStore);
                    this.elseStores.put(b, newStore);
                    this.inputs.put(b, new TransferInput(node, this, newStore));
                    addBlockToWorklist = true;
                    break;
                }
                boolean storeChanged = false;
                S newThenStore = this.mergeStores(s2, thenStore, shouldWiden);
                if (!newThenStore.equals(thenStore)) {
                    this.thenStores.put(b, newThenStore);
                    storeChanged = true;
                }
                if (!(newElseStore = this.mergeStores(s2, elseStore, shouldWiden)).equals(elseStore)) {
                    this.elseStores.put(b, newElseStore);
                    storeChanged = true;
                }
                if (!storeChanged) break;
                this.inputs.put(b, new TransferInput(node, this, newThenStore, newElseStore));
                addBlockToWorklist = true;
            }
        }
        if (addBlockToWorklist) {
            this.addToWorklist(b);
        }
    }

    private S mergeStores(S newStore, @Nullable S previousStore, boolean shouldWiden) {
        if (previousStore == null) {
            return newStore;
        }
        if (shouldWiden) {
            return newStore.widenedUpperBound(previousStore);
        }
        return newStore.leastUpperBound(previousStore);
    }

    protected @Nullable S getStoreBefore(Block b, Store.Kind kind) {
        switch (kind) {
            case THEN: {
                return (S)((Store)ForwardAnalysisImpl.readFromStore(this.thenStores, b));
            }
            case ELSE: {
                return (S)((Store)ForwardAnalysisImpl.readFromStore(this.elseStores, b));
            }
        }
        throw new BugInCF("Unexpected Store.Kind: " + (Object)((Object)kind));
    }

    protected @Nullable TransferInput<V, S> getInputBefore(Block b) {
        return (TransferInput)this.inputs.get(b);
    }
}

