/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jspecify.nullness.Nullable;

public class TurbineProcessingEnvironment
implements ProcessingEnvironment {
    private final Filer filer;
    private final Types types;
    private final Map<String, String> processorOptions;
    private final Elements elements;
    private final Map<String, byte[]> statistics;
    private final SourceVersion sourceVersion;
    private final Messager messager;
    private final ClassLoader processorLoader;

    public TurbineProcessingEnvironment(Filer filer, Types types, Elements elements, Messager messager, Map<String, String> processorOptions, SourceVersion sourceVersion, @Nullable ClassLoader processorLoader, Map<String, byte[]> statistics) {
        this.filer = filer;
        this.types = types;
        this.processorOptions = processorOptions;
        this.sourceVersion = sourceVersion;
        this.elements = elements;
        this.statistics = statistics;
        this.messager = messager;
        this.processorLoader = processorLoader;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.processorOptions;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public Filer getFiler() {
        return this.filer;
    }

    @Override
    public Elements getElementUtils() {
        return this.elements;
    }

    @Override
    public Types getTypeUtils() {
        return this.types;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return this.sourceVersion;
    }

    @Override
    public Locale getLocale() {
        return Locale.ENGLISH;
    }

    public ClassLoader processorLoader() {
        return this.processorLoader;
    }

    public void addStatistics(String key, byte[] extension) {
        byte[] existing = this.statistics.put(key, extension);
        if (existing != null) {
            throw new IllegalStateException("duplicate statistics reported for " + key);
        }
    }
}

