/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Optional;

@BugPattern(summary="toString() on lite protos will not generate a useful representation of the proto from optimized builds. Consider whether using some subset of fields instead would provide useful information.", severity=BugPattern.SeverityLevel.WARNING)
public final class LiteProtoToString
extends AbstractToString {
    private static final String LITE_ENUM_MESSAGE = "toString() on lite proto enums will generate different representations of the value from development and optimized builds. Consider using #getNumber if you only need a serialized representation of the value, or #name if you really need the name.";
    private static final TypePredicate IS_LITE_PROTO = TypePredicates.allOf((TypePredicate[])new TypePredicate[]{TypePredicates.isDescendantOf((String)"com.google.protobuf.MessageLite"), TypePredicates.not((TypePredicate)TypePredicates.isDescendantOf((String)"com.google.protobuf.Message")), TypePredicates.not((TypePredicate)TypePredicates.isExactType((String)"com.google.protobuf.UnknownFieldSet"))});
    private static final TypePredicate IS_LITE_ENUM = TypePredicates.allOf((TypePredicate[])new TypePredicate[]{TypePredicates.isDescendantOf((String)"com.google.protobuf.Internal.EnumLite"), TypePredicates.not((TypePredicate)TypePredicates.isDescendantOf((String)"com.google.protobuf.ProtocolMessageEnum")), TypePredicates.not((TypePredicate)TypePredicates.isDescendantOf((String)"com.google.protobuf.Descriptors.EnumValueDescriptor")), TypePredicates.not((TypePredicate)TypePredicates.isDescendantOf((String)"com.google.protobuf.AbstractMessageLite.InternalOneOfEnum"))});
    private static final ImmutableSet<String> METHODS_STRIPPED_BY_OPTIMIZER = ImmutableSet.builder().add((Object[])new String[]{"atVerbose", "atFine", "atFiner", "atFinest", "atDebug", "atConfig", "atInfo"}).add((Object[])new String[]{"v", "d", "i"}).build();

    @Override
    protected TypePredicate typePredicate() {
        return LiteProtoToString::matches;
    }

    private static boolean matches(Type type, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return false;
        }
        if (LiteProtoToString.isStrippedLogMessage(state)) {
            return false;
        }
        return IS_LITE_PROTO.apply(type, state) || IS_LITE_ENUM.apply(type, state);
    }

    private static boolean isStrippedLogMessage(VisitorState state) {
        return Streams.stream((Iterable)state.getPath()).anyMatch(LiteProtoToString::isStrippedLogMessage);
    }

    private static boolean isStrippedLogMessage(Tree tree) {
        while (tree instanceof MethodInvocationTree) {
            if (METHODS_STRIPPED_BY_OPTIMIZER.contains((Object)ASTHelpers.getSymbol((Tree)tree).getSimpleName().toString())) {
                return true;
            }
            tree = ASTHelpers.getReceiver((ExpressionTree)((MethodInvocationTree)tree));
        }
        return false;
    }

    @Override
    protected Optional<String> descriptionMessageForDefaultMatch(Type type, VisitorState state) {
        return Optional.of(IS_LITE_ENUM.apply(type, state) ? LITE_ENUM_MESSAGE : this.message());
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return Optional.empty();
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        return Optional.empty();
    }
}

