/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.List;

@BugPattern(summary="It is not necessary to wrap a MethodMatcher with methodInvocation().", severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryMethodInvocationMatcher
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String MATCHERS = Matchers.class.getCanonicalName();
    private static final Matcher<ExpressionTree> METHOD_INVOCATION = Matchers.staticMethod().onClass(MATCHERS).named("methodInvocation");
    private static final Matcher<ExpressionTree> COMBINATOR = Matchers.staticMethod().onClass(MATCHERS).namedAnyOf(new String[]{"allOf", "anyOf", "not"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHOD_INVOCATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.size() != 1) {
            return Description.NO_MATCH;
        }
        Type methodMatcherType = state.getTypeFromString(MethodMatchers.MethodMatcher.class.getCanonicalName());
        ExpressionTree argument = arguments.get(0);
        if (!UnnecessaryMethodInvocationMatcher.containsOnlyMethodMatchers(argument, methodMatcherType, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)argument)));
    }

    private static boolean containsOnlyMethodMatchers(ExpressionTree expressionTree, Type methodMatcherType, VisitorState state) {
        if (ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)expressionTree), (Type)methodMatcherType, (VisitorState)state)) {
            return true;
        }
        if (!COMBINATOR.matches((Tree)expressionTree, state)) {
            return false;
        }
        for (ExpressionTree expressionTree2 : ((MethodInvocationTree)expressionTree).getArguments()) {
            if (UnnecessaryMethodInvocationMatcher.containsOnlyMethodMatchers(expressionTree2, methodMatcherType, state)) continue;
            return false;
        }
        return true;
    }
}

