/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.dagger.DaggerAnnotations;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;

@BugPattern(summary="Scopes on modules have no function and will soon be an error.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class ScopeOnModule
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!DaggerAnnotations.isAnyModule().matches((Tree)classTree, state)) {
            return Description.NO_MATCH;
        }
        ArrayList<SuggestedFix> fixes = new ArrayList<SuggestedFix>();
        for (AnnotationTree annotationTree : classTree.getModifiers().getAnnotations()) {
            Symbol annotationType = ASTHelpers.getSymbol((Tree)annotationTree.getAnnotationType());
            if (!ASTHelpers.hasAnnotation((Symbol)annotationType, (String)"javax.inject.Scope", (VisitorState)state)) continue;
            fixes.add(SuggestedFix.delete((Tree)annotationTree));
        }
        if (fixes.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(classTree).addAllFixes(fixes).build();
    }
}

