/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class Bindings
extends ForwardingMap<Key<?>, Object> {
    private final Map<Key<?>, Object> contents;

    public static Bindings create() {
        return new Bindings();
    }

    public static <V> Bindings create(Key<V> key, V value) {
        Bindings result = Bindings.create();
        result.putBinding(key, value);
        return result;
    }

    public static <V1, V2> Bindings create(Key<V1> key1, V1 value1, Key<V2> key2, V2 value2) {
        Bindings result = Bindings.create();
        result.putBinding(key1, value1);
        result.putBinding(key2, value2);
        return result;
    }

    public static Bindings create(Bindings bindings) {
        return new Bindings(bindings);
    }

    private Bindings() {
        this(new HashMap());
    }

    Bindings(Bindings bindings) {
        this(Maps.newHashMap(bindings.contents));
    }

    private Bindings(Map<Key<?>, Object> contents) {
        this.contents = contents;
    }

    protected Map<Key<?>, Object> delegate() {
        return this.contents;
    }

    public <V> V getBinding(Key<V> key) {
        Preconditions.checkNotNull(key);
        return (V)super.get(key);
    }

    public <V> V putBinding(Key<V> key, V value) {
        Preconditions.checkNotNull(value);
        return (V)super.put(key, value);
    }

    @Nullable
    @CanIgnoreReturnValue
    public Object put(Key<?> key, Object value) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        return super.put(key, key.getValueType().getRawType().cast(value));
    }

    public void putAll(Map<? extends Key<?>, ? extends Object> map) {
        this.standardPutAll(map);
    }

    public Bindings unmodifiable() {
        return new Bindings(Collections.unmodifiableMap(this.contents));
    }

    public static abstract class Key<V> {
        private final String identifier;

        protected Key(String identifier) {
            this.identifier = (String)Preconditions.checkNotNull((Object)identifier);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        TypeToken<V> getValueType() {
            return new TypeToken<V>(this.getClass()){};
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getClass(), this.identifier});
        }

        public boolean equals(@Nullable Object obj) {
            if (obj != null && this.getClass() == obj.getClass()) {
                Key key = (Key)obj;
                return this.identifier.equals(key.identifier);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.identifier).toString();
        }
    }
}

