/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.io.Files;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="Java classes shouldn't use default package", severity=BugPattern.SeverityLevel.WARNING)
public final class DefaultPackage
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        if (tree.getTypeDecls().stream().anyMatch(s -> this.isSuppressed((Tree)s, state))) {
            return Description.NO_MATCH;
        }
        if (tree.getTypeDecls().stream().map(ASTHelpers::getSymbol).filter(x -> x != null).anyMatch(s -> !ASTHelpers.getGeneratedBy((Symbol)s, (VisitorState)state).isEmpty())) {
            return Description.NO_MATCH;
        }
        if (tree.getPackageName() != null) {
            return Description.NO_MATCH;
        }
        if (Files.getNameWithoutExtension((String)ASTHelpers.getFileName((CompilationUnitTree)tree)).equals("module-info")) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

