/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Map;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="It is confusing to have a field and a parameter under the same scope that differ only in capitalization.", severity=BugPattern.SeverityLevel.WARNING)
public class InconsistentCapitalization
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableSet<Symbol> fields = FieldScanner.findFields(tree);
        if (fields.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableMap fieldNamesMap = (ImmutableMap)fields.stream().collect(ImmutableMap.toImmutableMap(symbol -> Ascii.toLowerCase((String)symbol.toString()), x -> x, (x, y) -> x));
        ImmutableMap<TreePath, Symbol> matchedParameters = MatchingParametersScanner.findMatchingParameters((ImmutableMap<String, Symbol>)fieldNamesMap, state.getPath());
        if (matchedParameters.isEmpty()) {
            return Description.NO_MATCH;
        }
        for (Map.Entry entry : matchedParameters.entrySet()) {
            TreePath parameterPath = (TreePath)entry.getKey();
            final Symbol field = (Symbol)entry.getValue();
            String fieldName = field.getSimpleName().toString();
            VariableTree parameterTree = (VariableTree)parameterPath.getLeaf();
            final SuggestedFix.Builder fix = SuggestedFix.builder().merge(SuggestedFixes.renameVariable((VariableTree)parameterTree, (String)fieldName, (VisitorState)state));
            if (parameterPath.getParentPath() != null) {
                final String qualifiedName = InconsistentCapitalization.getExplicitQualification(parameterPath, tree, state) + field.getSimpleName();
                parameterPath.getParentPath().getLeaf().accept(new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree tree, Void unused) {
                        if (field.equals(ASTHelpers.getSymbol((Tree)tree))) {
                            fix.replace((Tree)tree, qualifiedName);
                        }
                        return null;
                    }
                }, null);
            }
            state.reportMatch(this.buildDescription(parameterPath.getLeaf()).setMessage(String.format("Found the field '%s' with the same name as the parameter '%s' but with different capitalization.", fieldName, ((VariableTree)parameterPath.getLeaf()).getName())).addFix((Fix)fix.build()).build());
        }
        return Description.NO_MATCH;
    }

    private static String getExplicitQualification(TreePath path, ClassTree tree, VisitorState state) {
        for (Tree node : path) {
            if (node.equals(tree)) break;
            if (!(node instanceof ClassTree)) continue;
            if (ASTHelpers.getSymbol((Tree)node).isSubClass(ASTHelpers.getSymbol((ClassTree)tree), state.getTypes())) {
                return "super.";
            }
            return tree.getSimpleName() + ".this.";
        }
        return "this.";
    }

    private static boolean isUpperCaseAndStatic(Symbol symbol) {
        return ASTHelpers.isStatic((Symbol)symbol) && symbol.name.contentEquals(Ascii.toUpperCase((String)symbol.name.toString()));
    }

    private static class FieldScanner
    extends TreeScanner<Void, Void> {
        private final ImmutableSet.Builder<Symbol> fields;
        private final Symbol classSymbol;

        static ImmutableSet<Symbol> findFields(ClassTree tree) {
            ImmutableSet.Builder fieldsBuilder = ImmutableSet.builder();
            new FieldScanner((ImmutableSet.Builder<Symbol>)fieldsBuilder, tree).scan(tree, null);
            return fieldsBuilder.build();
        }

        private FieldScanner(ImmutableSet.Builder<Symbol> fields, Tree classTree) {
            this.fields = fields;
            this.classSymbol = ASTHelpers.getSymbol((Tree)classTree);
        }

        @Override
        public Void visitVariable(VariableTree tree, Void unused) {
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
            if (((Symbol)symbol).getKind().equals((Object)ElementKind.FIELD) && !InconsistentCapitalization.isUpperCaseAndStatic(symbol) && ASTHelpers.enclosingClass((Symbol)symbol).equals(this.classSymbol)) {
                this.fields.add((Object)symbol);
            }
            return (Void)super.visitVariable(tree, unused);
        }
    }

    private static class MatchingParametersScanner
    extends TreePathScanner<Void, Void> {
        private final ImmutableMap<String, Symbol> fields;
        private final ImmutableMap.Builder<TreePath, Symbol> matchedParameters;

        static ImmutableMap<TreePath, Symbol> findMatchingParameters(ImmutableMap<String, Symbol> fieldNamesMap, TreePath path) {
            ImmutableMap.Builder matchedParametersBuilder = ImmutableMap.builder();
            new MatchingParametersScanner(fieldNamesMap, (ImmutableMap.Builder<TreePath, Symbol>)matchedParametersBuilder).scan(path, null);
            return matchedParametersBuilder.buildOrThrow();
        }

        private MatchingParametersScanner(ImmutableMap<String, Symbol> fields, ImmutableMap.Builder<TreePath, Symbol> matchedParameters) {
            this.fields = fields;
            this.matchedParameters = matchedParameters;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void unused) {
            if (ASTHelpers.isGeneratedConstructor((MethodTree)tree)) {
                return null;
            }
            return (Void)super.visitMethod(tree, null);
        }

        @Override
        public Void visitVariable(VariableTree tree, Void unused) {
            String fieldName;
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
            if (!((Symbol)symbol).getKind().equals((Object)ElementKind.PARAMETER)) {
                return (Void)super.visitVariable(tree, unused);
            }
            String variableName = ((Symbol)symbol).toString();
            Symbol matchedField = (Symbol)this.fields.get((Object)Ascii.toLowerCase((String)variableName));
            if (matchedField != null && !variableName.equals(fieldName = matchedField.toString())) {
                this.matchedParameters.put((Object)this.getCurrentPath(), (Object)matchedField);
            }
            return (Void)super.visitVariable(tree, unused);
        }
    }
}

