/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.overloading;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.bugpatterns.overloading.AutoValue_ParameterTree;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;

@AutoValue
abstract class ParameterTree {
    ParameterTree() {
    }

    public abstract Name getName();

    public abstract Tree getType();

    public abstract boolean isVarArgs();

    public static ParameterTree create(VariableTree variableTree) {
        Preconditions.checkArgument((boolean)ParameterTree.isValidParameterTree(variableTree));
        Name name = variableTree.getName();
        Tree type = variableTree.getType();
        boolean isVarargs = ParameterTree.isVariableTreeVarArgs(variableTree);
        return new AutoValue_ParameterTree(name, type, isVarargs);
    }

    private static boolean isValidParameterTree(VariableTree variableTree) {
        if (variableTree.getInitializer() != null) {
            return false;
        }
        Set<Modifier> flags = variableTree.getModifiers().getFlags();
        return flags.isEmpty() || flags.size() == 1 && flags.contains((Object)Modifier.FINAL);
    }

    public final String toString() {
        Object type = this.getType().toString();
        String name = this.getName().toString();
        if (this.isVarArgs()) {
            type = ((String)type).substring(0, ((String)type).length() - 2) + "...";
        }
        return (String)type + " " + name;
    }

    private static boolean isVariableTreeVarArgs(VariableTree variableTree) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)variableTree);
        Preconditions.checkArgument((boolean)(sym.owner instanceof Symbol.MethodSymbol), (Object)"sym must be a parameter to a method");
        Symbol.MethodSymbol method = (Symbol.MethodSymbol)sym.owner;
        return method.isVarArgs() && ((List)method.getParameters()).last() == sym;
    }
}

