/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pcollections.ConsPStack;
import org.pcollections.PMap;
import org.pcollections.PSequence;

public final class HashPMap<K, V>
extends AbstractMap<K, V>
implements PMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final PMap<Integer, PSequence<Map.Entry<K, V>>> intMap;
    private final int size;
    private transient Set<Map.Entry<K, V>> entrySet = null;

    public static <K, V> HashPMap<K, V> empty(PMap<Integer, PSequence<Map.Entry<K, V>>> intMap) {
        return new HashPMap<K, V>(intMap.minusAll(intMap.keySet()), 0);
    }

    private HashPMap(PMap<Integer, PSequence<Map.Entry<K, V>>> intMap, int size) {
        this.intMap = intMap;
        this.size = size;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return HashPMap.this.size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new SequenceIterator(HashPMap.this.intMap.values().iterator());
                }

                @Override
                public boolean contains(Object e) {
                    if (!(e instanceof Map.Entry)) {
                        return false;
                    }
                    Object value = HashPMap.this.get(((Map.Entry)e).getKey());
                    return value != null && value.equals(((Map.Entry)e).getValue());
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return HashPMap.keyIndexIn(this.getEntries(key.hashCode()), key) != -1;
    }

    @Override
    public V get(Object key) {
        PSequence<Map.Entry<K, V>> entries = this.getEntries(key.hashCode());
        for (Map.Entry entry : entries) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public HashPMap<K, V> plusAll(Map<? extends K, ? extends V> map) {
        PMap<K, V> result = this;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result = result.plus((Object)entry.getKey(), (Object)entry.getValue());
        }
        return result;
    }

    @Override
    public HashPMap<K, V> minusAll(Collection<?> keys) {
        PMap<K, V> result = this;
        for (Object key : keys) {
            result = result.minus(key);
        }
        return result;
    }

    @Override
    public HashPMap<K, V> plus(K key, V value) {
        PSequence<Map.Entry<K, V>> entries = this.getEntries(key.hashCode());
        int size0 = entries.size();
        int i = HashPMap.keyIndexIn(entries, key);
        if (i != -1) {
            entries = entries.minus(i);
        }
        entries = entries.plus(new AbstractMap.SimpleImmutableEntry<K, V>(key, value));
        return new HashPMap<K, V>(this.intMap.plus(key.hashCode(), entries), this.size - size0 + entries.size());
    }

    @Override
    public HashPMap<K, V> minus(Object key) {
        PSequence<Map.Entry<K, V>> entries = this.getEntries(key.hashCode());
        int i = HashPMap.keyIndexIn(entries, key);
        if (i == -1) {
            return this;
        }
        if ((entries = entries.minus(i)).size() == 0) {
            return new HashPMap<K, V>(this.intMap.minus(key.hashCode()), this.size - 1);
        }
        return new HashPMap<K, V>(this.intMap.plus(key.hashCode(), entries), this.size - 1);
    }

    private PSequence<Map.Entry<K, V>> getEntries(int hash) {
        PSequence entries = (PSequence)this.intMap.get(hash);
        if (entries == null) {
            return ConsPStack.empty();
        }
        return entries;
    }

    private static <K, V> int keyIndexIn(PSequence<Map.Entry<K, V>> entries, Object key) {
        int i = 0;
        for (Map.Entry entry : entries) {
            if (entry.getKey().equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static class SequenceIterator<E>
    implements Iterator<E> {
        private final Iterator<PSequence<E>> i;
        private PSequence<E> seq = ConsPStack.empty();

        SequenceIterator(Iterator<PSequence<E>> i) {
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.seq.size() > 0 || this.i.hasNext();
        }

        @Override
        public E next() {
            if (this.seq.size() == 0) {
                this.seq = this.i.next();
            }
            Object result = this.seq.get(0);
            this.seq = this.seq.subList(1, this.seq.size());
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

