/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingClassException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Type;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NegationExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BlockScope;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.classgen.ClassGeneratorException;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.MethodCaller;
import org.codehaus.groovy.classgen.Variable;
import org.codehaus.groovy.classgen.VariableScopeCodeVisitor;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.parser.RuntimeParserException;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Constants;
import org.objectweb.asm.Label;

public class ClassGenerator
extends CodeVisitorSupport
implements GroovyClassVisitor,
Constants {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private ClassVisitor cw;
    private ClassLoader classLoader;
    private CodeVisitor cv;
    private GeneratorContext context;
    private String sourceFile;
    private ClassNode classNode;
    private ClassNode outermostClass;
    private String internalClassName;
    private String internalBaseClassName;
    private Map variableStack = new HashMap();
    private boolean outputReturn;
    private boolean leftHandExpression;
    MethodCaller invokeMethodMethod = MethodCaller.newStatic(InvokerHelper.class, "invokeMethod");
    MethodCaller invokeMethodSafeMethod = MethodCaller.newStatic(InvokerHelper.class, "invokeMethodSafe");
    MethodCaller invokeStaticMethodMethod = MethodCaller.newStatic(InvokerHelper.class, "invokeStaticMethod");
    MethodCaller invokeConstructorMethod = MethodCaller.newStatic(InvokerHelper.class, "invokeConstructor");
    MethodCaller invokeConstructorOfMethod = MethodCaller.newStatic(InvokerHelper.class, "invokeConstructorOf");
    MethodCaller invokeClosureMethod = MethodCaller.newStatic(InvokerHelper.class, "invokeClosure");
    MethodCaller invokeSuperMethodMethod = MethodCaller.newStatic(InvokerHelper.class, "invokeSuperMethod");
    MethodCaller invokeNoArgumentsMethod = MethodCaller.newStatic(InvokerHelper.class, "invokeNoArgumentsMethod");
    MethodCaller invokeStaticNoArgumentsMethod = MethodCaller.newStatic(InvokerHelper.class, "invokeStaticNoArgumentsMethod");
    MethodCaller asIntMethod = MethodCaller.newStatic(InvokerHelper.class, "asInt");
    MethodCaller asTypeMethod = MethodCaller.newStatic(InvokerHelper.class, "asType");
    MethodCaller getPropertyMethod = MethodCaller.newStatic(InvokerHelper.class, "getProperty");
    MethodCaller getPropertySafeMethod = MethodCaller.newStatic(InvokerHelper.class, "getPropertySafe");
    MethodCaller setPropertyMethod = MethodCaller.newStatic(InvokerHelper.class, "setProperty");
    MethodCaller setPropertyMethod2 = MethodCaller.newStatic(InvokerHelper.class, "setProperty2");
    MethodCaller setPropertySafeMethod2 = MethodCaller.newStatic(InvokerHelper.class, "setPropertySafe2");
    MethodCaller asIteratorMethod = MethodCaller.newStatic(InvokerHelper.class, "asIterator");
    MethodCaller asBool = MethodCaller.newStatic(InvokerHelper.class, "asBool");
    MethodCaller notBoolean = MethodCaller.newStatic(InvokerHelper.class, "notBoolean");
    MethodCaller notObject = MethodCaller.newStatic(InvokerHelper.class, "notObject");
    MethodCaller regexPattern = MethodCaller.newStatic(InvokerHelper.class, "regexPattern");
    MethodCaller negation = MethodCaller.newStatic(InvokerHelper.class, "negate");
    MethodCaller compareIdenticalMethod = MethodCaller.newStatic(InvokerHelper.class, "compareIdentical");
    MethodCaller compareEqualMethod = MethodCaller.newStatic(InvokerHelper.class, "compareEqual");
    MethodCaller compareNotEqualMethod = MethodCaller.newStatic(InvokerHelper.class, "compareNotEqual");
    MethodCaller compareToMethod = MethodCaller.newStatic(InvokerHelper.class, "compareTo");
    MethodCaller findRegexMethod = MethodCaller.newStatic(InvokerHelper.class, "findRegex");
    MethodCaller matchRegexMethod = MethodCaller.newStatic(InvokerHelper.class, "matchRegex");
    MethodCaller compareLessThanMethod = MethodCaller.newStatic(InvokerHelper.class, "compareLessThan");
    MethodCaller compareLessThanEqualMethod = MethodCaller.newStatic(InvokerHelper.class, "compareLessThanEqual");
    MethodCaller compareGreaterThanMethod = MethodCaller.newStatic(InvokerHelper.class, "compareGreaterThan");
    MethodCaller compareGreaterThanEqualMethod = MethodCaller.newStatic(InvokerHelper.class, "compareGreaterThanEqual");
    MethodCaller isCaseMethod = MethodCaller.newStatic(InvokerHelper.class, "isCase");
    MethodCaller createListMethod = MethodCaller.newStatic(InvokerHelper.class, "createList");
    MethodCaller createTupleMethod = MethodCaller.newStatic(InvokerHelper.class, "createTuple");
    MethodCaller createMapMethod = MethodCaller.newStatic(InvokerHelper.class, "createMap");
    MethodCaller createRangeMethod = MethodCaller.newStatic(InvokerHelper.class, "createRange");
    MethodCaller assertFailedMethod = MethodCaller.newStatic(InvokerHelper.class, "assertFailed");
    MethodCaller iteratorNextMethod = MethodCaller.newInterface(Iterator.class, "next");
    MethodCaller iteratorHasNextMethod = MethodCaller.newInterface(Iterator.class, "hasNext");
    private int lastVariableIndex;
    private static int tempVariableNameCounter;
    private List exceptionBlocks = new ArrayList();
    private LinkedList innerClasses = new LinkedList();
    private boolean definingParameters;
    private Set syntheticStaticFields = new HashSet();
    private Set mutableVars = new HashSet();
    private boolean passingClosureParams;
    private ConstructorNode constructorNode;
    private MethodNode methodNode;
    private BlockScope scope;
    private BytecodeHelper helper = new BytecodeHelper(null);
    private VariableScope variableScope;
    static /* synthetic */ Class class$groovy$lang$Reference;

    public ClassGenerator(GeneratorContext context, ClassVisitor classVisitor, ClassLoader classLoader, String sourceFile) {
        this.context = context;
        this.cw = classVisitor;
        this.classLoader = classLoader;
        this.sourceFile = sourceFile;
    }

    public LinkedList getInnerClasses() {
        return this.innerClasses;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void visitClass(ClassNode classNode) {
        try {
            this.syntheticStaticFields.clear();
            this.classNode = classNode;
            this.outermostClass = null;
            this.internalClassName = BytecodeHelper.getClassInternalName(classNode.getName());
            this.internalBaseClassName = BytecodeHelper.getClassInternalName(classNode.getSuperClass());
            this.cw.visit(classNode.getModifiers(), this.internalClassName, this.internalBaseClassName, BytecodeHelper.getClassInternalNames(classNode.getInterfaces()), this.sourceFile);
            classNode.visitContents(this);
            this.createSyntheticStaticFields();
            Iterator iter = this.innerClasses.iterator();
            while (iter.hasNext()) {
                ClassNode innerClass = (ClassNode)iter.next();
                String innerClassName = innerClass.getName();
                String innerClassInternalName = BytecodeHelper.getClassInternalName(innerClassName);
                this.cw.visitInnerClass(innerClassInternalName, this.internalClassName, innerClassName, innerClass.getModifiers());
            }
            this.cw.visitEnd();
        }
        catch (GroovyRuntimeException e) {
            e.setModule(classNode.getModule());
            throw e;
        }
    }

    public void visitConstructor(ConstructorNode node) {
        this.constructorNode = node;
        this.methodNode = null;
        this.variableScope = null;
        String methodType = BytecodeHelper.getMethodDescriptor("void", node.getParameters());
        this.cv = this.cw.visitMethod(node.getModifiers(), "<init>", methodType, null, null);
        this.helper = new BytecodeHelper(this.cv);
        this.findMutableVariables();
        this.resetVariableStack(node.getParameters());
        Statement code = node.getCode();
        if (code == null || !this.firstStatementIsSuperMethodCall(code)) {
            this.cv.visitVarInsn(25, 0);
            this.cv.visitMethodInsn(183, this.internalBaseClassName, "<init>", "()V");
        }
        if (code != null) {
            code.visit(this);
        }
        this.cv.visitInsn(177);
        this.cv.visitMaxs(0, 0);
    }

    public void visitMethod(MethodNode node) {
        this.constructorNode = null;
        this.methodNode = node;
        this.variableScope = null;
        String methodType = BytecodeHelper.getMethodDescriptor(node.getReturnType(), node.getParameters());
        this.cv = this.cw.visitMethod(node.getModifiers(), node.getName(), methodType, null, null);
        this.helper = new BytecodeHelper(this.cv);
        this.findMutableVariables();
        this.resetVariableStack(node.getParameters());
        this.outputReturn = false;
        node.getCode().visit(this);
        if (!this.outputReturn) {
            this.cv.visitInsn(177);
        }
        Iterator iter = this.exceptionBlocks.iterator();
        while (iter.hasNext()) {
            Runnable runnable = (Runnable)iter.next();
            runnable.run();
        }
        this.exceptionBlocks.clear();
        this.cv.visitMaxs(0, 0);
    }

    public void visitField(FieldNode fieldNode) {
        this.onLineNumber(fieldNode);
        Object fieldValue = null;
        Expression expression = fieldNode.getInitialValueExpression();
        if (expression instanceof ConstantExpression) {
            ConstantExpression constantExp = (ConstantExpression)expression;
            Object value = constantExp.getValue();
            if (this.isPrimitiveFieldType(fieldNode.getType())) {
                Class type = null;
                try {
                    type = this.loadClass(fieldNode.getType());
                    fieldValue = InvokerHelper.asType(value, type);
                }
                catch (Exception e) {
                    this.log.warning("Caught unexpected: " + e);
                }
            }
        }
        this.cw.visitField(fieldNode.getModifiers(), fieldNode.getName(), BytecodeHelper.getTypeDescription(fieldNode.getType()), fieldValue, null);
    }

    public void visitProperty(PropertyNode statement) {
        this.onLineNumber(statement);
        this.methodNode = null;
    }

    public void visitForLoop(ForStatement loop) {
        this.onLineNumber(loop);
        Type variableType = this.checkValidType(loop.getVariableType(), (ASTNode)loop, "for loop variable");
        int iIdx = this.defineVariable(loop.getVariable(), variableType, true).getIndex();
        loop.getCollectionExpression().visit(this);
        this.asIteratorMethod.call(this.cv);
        final int iteratorIdx = this.defineVariable(this.createVariableName("iterator"), "java.util.Iterator", false).getIndex();
        this.cv.visitVarInsn(58, iteratorIdx);
        this.pushBlockScope();
        Label continueLabel = this.scope.getContinueLabel();
        this.cv.visitJumpInsn(167, continueLabel);
        Label label2 = new Label();
        this.cv.visitLabel(label2);
        BytecodeExpression expression = new BytecodeExpression(){

            public void visit(GroovyCodeVisitor visitor) {
                ClassGenerator.this.cv.visitVarInsn(25, iteratorIdx);
                ClassGenerator.this.iteratorNextMethod.call(ClassGenerator.this.cv);
            }
        };
        this.evaluateEqual(new BinaryExpression(new VariableExpression(loop.getVariable()), Token.equal(-1, -1), expression));
        loop.getLoopBlock().visit(this);
        this.cv.visitLabel(continueLabel);
        this.cv.visitVarInsn(25, iteratorIdx);
        this.iteratorHasNextMethod.call(this.cv);
        this.cv.visitJumpInsn(154, label2);
        this.cv.visitLabel(this.scope.getBreakLabel());
        this.popScope();
    }

    public void visitWhileLoop(WhileStatement loop) {
        this.onLineNumber(loop);
        this.pushBlockScope();
        Label continueLabel = this.scope.getContinueLabel();
        this.cv.visitJumpInsn(167, continueLabel);
        Label l1 = new Label();
        this.cv.visitLabel(l1);
        loop.getLoopBlock().visit(this);
        this.cv.visitLabel(continueLabel);
        loop.getBooleanExpression().visit(this);
        this.cv.visitJumpInsn(154, l1);
        this.cv.visitLabel(this.scope.getBreakLabel());
        this.popScope();
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.onLineNumber(loop);
        this.pushBlockScope();
        Label breakLabel = this.scope.getBreakLabel();
        Label continueLabel = this.scope.getContinueLabel();
        this.cv.visitLabel(continueLabel);
        Label l1 = new Label();
        loop.getLoopBlock().visit(this);
        this.cv.visitLabel(l1);
        loop.getBooleanExpression().visit(this);
        this.cv.visitJumpInsn(154, continueLabel);
        this.cv.visitLabel(breakLabel);
        this.popScope();
    }

    public void visitIfElse(IfStatement ifElse) {
        this.onLineNumber(ifElse);
        ifElse.getBooleanExpression().visit(this);
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        ifElse.getIfBlock().visit(this);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        ifElse.getElseBlock().visit(this);
        this.cv.visitLabel(l1);
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        this.onLineNumber(expression);
        expression.getBooleanExpression().visit(this);
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        expression.getTrueExpression().visit(this);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        expression.getFalseExpression().visit(this);
        this.cv.visitLabel(l1);
    }

    public void visitAssertStatement(AssertStatement statement) {
        this.onLineNumber(statement);
        BooleanExpression booleanExpression = statement.getBooleanExpression();
        booleanExpression.visit(this);
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        String expressionText = booleanExpression.getText();
        ArrayList list = new ArrayList();
        this.addVariableNames(booleanExpression, list);
        if (list.isEmpty()) {
            this.cv.visitLdcInsn((Object)expressionText);
        } else {
            boolean first = true;
            this.cv.visitTypeInsn(187, "java/lang/StringBuffer");
            this.cv.visitInsn(89);
            this.cv.visitLdcInsn((Object)(expressionText + ". Values: "));
            this.cv.visitMethodInsn(183, "java/lang/StringBuffer", "<init>", "(Ljava/lang/String;)V");
            int tempIndex = this.defineVariable(this.createVariableName("assert"), "java.lang.Object", false).getIndex();
            this.cv.visitVarInsn(58, tempIndex);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String text = name + " = ";
                if (first) {
                    first = false;
                } else {
                    text = ", " + text;
                }
                this.cv.visitVarInsn(25, tempIndex);
                this.cv.visitLdcInsn((Object)text);
                this.cv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                this.cv.visitInsn(87);
                this.cv.visitVarInsn(25, tempIndex);
                new VariableExpression(name).visit(this);
                this.cv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuffer;");
                this.cv.visitInsn(87);
            }
            this.cv.visitVarInsn(25, tempIndex);
        }
        statement.getMessageExpression().visit(this);
        this.assertFailedMethod.call(this.cv);
        this.cv.visitLabel(l1);
    }

    private void addVariableNames(Expression expression, List list) {
        if (expression instanceof BooleanExpression) {
            BooleanExpression boolExp = (BooleanExpression)expression;
            this.addVariableNames(boolExp.getExpression(), list);
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binExp = (BinaryExpression)expression;
            this.addVariableNames(binExp.getLeftExpression(), list);
            this.addVariableNames(binExp.getRightExpression(), list);
        } else if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            list.add(varExp.getVariable());
        }
    }

    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.onLineNumber(statement);
        CatchStatement catchStatement = statement.getCatchStatement(0);
        Statement tryStatement = statement.getTryStatement();
        if (tryStatement.isEmpty()) {
            return;
        }
        if (catchStatement == null) {
            final Label l0 = new Label();
            this.cv.visitLabel(l0);
            tryStatement.visit(this);
            int index1 = this.defineVariable(this.createVariableName("exception"), "java.lang.Object").getIndex();
            int index2 = this.defineVariable(this.createVariableName("exception"), "java.lang.Object").getIndex();
            Label l1 = new Label();
            this.cv.visitJumpInsn(168, l1);
            final Label l2 = new Label();
            this.cv.visitLabel(l2);
            Label l3 = new Label();
            this.cv.visitJumpInsn(167, l3);
            final Label l4 = new Label();
            this.cv.visitLabel(l4);
            this.cv.visitVarInsn(58, index1);
            this.cv.visitJumpInsn(168, l1);
            final Label l5 = new Label();
            this.cv.visitLabel(l5);
            this.cv.visitVarInsn(25, index1);
            this.cv.visitInsn(191);
            this.cv.visitLabel(l1);
            this.cv.visitVarInsn(58, index2);
            statement.getFinallyStatement().visit(this);
            this.cv.visitVarInsn(169, index2);
            this.cv.visitLabel(l3);
            this.exceptionBlocks.add(new Runnable(){

                public void run() {
                    ClassGenerator.this.cv.visitTryCatchBlock(l0, l2, l4, null);
                    ClassGenerator.this.cv.visitTryCatchBlock(l4, l5, l4, null);
                }
            });
        } else {
            String exceptionVar = catchStatement.getVariable();
            String exceptionType = this.checkValidType(catchStatement.getExceptionType(), (ASTNode)catchStatement, "in catch statement");
            int exceptionIndex = this.defineVariable(exceptionVar, exceptionType, false).getIndex();
            int index2 = this.defineVariable(this.createVariableName("exception"), "java.lang.Object").getIndex();
            int index3 = this.defineVariable(this.createVariableName("exception"), "java.lang.Object").getIndex();
            final Label l0 = new Label();
            this.cv.visitLabel(l0);
            tryStatement.visit(this);
            final Label l1 = new Label();
            this.cv.visitLabel(l1);
            Label l2 = new Label();
            this.cv.visitJumpInsn(168, l2);
            final Label l3 = new Label();
            this.cv.visitLabel(l3);
            Label l4 = new Label();
            this.cv.visitJumpInsn(167, l4);
            final Label l5 = new Label();
            this.cv.visitLabel(l5);
            this.cv.visitVarInsn(58, exceptionIndex);
            if (catchStatement != null) {
                catchStatement.visit(this);
            }
            this.cv.visitJumpInsn(168, l2);
            final Label l6 = new Label();
            this.cv.visitLabel(l6);
            this.cv.visitJumpInsn(167, l4);
            final Label l7 = new Label();
            this.cv.visitLabel(l7);
            this.cv.visitVarInsn(58, index2);
            this.cv.visitJumpInsn(168, l2);
            final Label l8 = new Label();
            this.cv.visitLabel(l8);
            this.cv.visitVarInsn(25, index2);
            this.cv.visitInsn(191);
            this.cv.visitLabel(l2);
            this.cv.visitVarInsn(58, index3);
            statement.getFinallyStatement().visit(this);
            this.cv.visitVarInsn(169, index3);
            this.cv.visitLabel(l4);
            final String exceptionTypeInternalName = catchStatement != null ? BytecodeHelper.getClassInternalName(exceptionType) : null;
            this.exceptionBlocks.add(new Runnable(){

                public void run() {
                    ClassGenerator.this.cv.visitTryCatchBlock(l0, l1, l5, exceptionTypeInternalName);
                    ClassGenerator.this.cv.visitTryCatchBlock(l0, l3, l7, null);
                    ClassGenerator.this.cv.visitTryCatchBlock(l5, l6, l7, null);
                    ClassGenerator.this.cv.visitTryCatchBlock(l7, l8, l7, null);
                }
            });
        }
    }

    public void visitSwitch(SwitchStatement statement) {
        int i;
        this.onLineNumber(statement);
        statement.getExpression().visit(this);
        this.pushBlockScope();
        int switchVariableIndex = this.defineVariable(this.createVariableName("switch"), "java.lang.Object").getIndex();
        this.cv.visitVarInsn(58, switchVariableIndex);
        List caseStatements = statement.getCaseStatements();
        int caseCount = caseStatements.size();
        Label[] labels = new Label[caseCount + 1];
        for (i = 0; i < caseCount; ++i) {
            labels[i] = new Label();
        }
        i = 0;
        Iterator iter = caseStatements.iterator();
        while (iter.hasNext()) {
            CaseStatement caseStatement = (CaseStatement)iter.next();
            this.visitCaseStatement(caseStatement, switchVariableIndex, labels[i], labels[i + 1]);
            ++i;
        }
        statement.getDefaultStatement().visit(this);
        this.cv.visitLabel(this.scope.getBreakLabel());
        this.popScope();
    }

    public void visitCaseStatement(CaseStatement statement) {
    }

    public void visitCaseStatement(CaseStatement statement, int switchVariableIndex, Label thisLabel, Label nextLabel) {
        this.onLineNumber(statement);
        this.cv.visitVarInsn(25, switchVariableIndex);
        statement.getExpression().visit(this);
        this.isCaseMethod.call(this.cv);
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        this.cv.visitLabel(thisLabel);
        statement.getCode().visit(this);
        if (nextLabel != null) {
            this.cv.visitJumpInsn(167, nextLabel);
        }
        this.cv.visitLabel(l0);
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.onLineNumber(statement);
        this.cv.visitJumpInsn(167, this.scope.getBreakLabel());
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.onLineNumber(statement);
        this.cv.visitJumpInsn(167, this.scope.getContinueLabel());
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.onLineNumber(statement);
        statement.getExpression().visit(this);
        int index = this.defineVariable(this.createVariableName("synchronized"), "java.lang.Integer").getIndex();
        this.cv.visitVarInsn(58, index);
        this.cv.visitInsn(194);
        final Label l0 = new Label();
        this.cv.visitLabel(l0);
        statement.getCode().visit(this);
        this.cv.visitVarInsn(25, index);
        this.cv.visitInsn(195);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        final Label l2 = new Label();
        this.cv.visitLabel(l2);
        this.cv.visitVarInsn(25, index);
        this.cv.visitInsn(195);
        this.cv.visitInsn(191);
        this.cv.visitLabel(l1);
        this.exceptionBlocks.add(new Runnable(){

            public void run() {
                ClassGenerator.this.cv.visitTryCatchBlock(l0, l2, l2, null);
            }
        });
    }

    public void visitThrowStatement(ThrowStatement statement) {
        statement.getExpression().visit(this);
        this.cv.visitTypeInsn(192, "java/lang/Throwable");
        this.cv.visitInsn(191);
    }

    public void visitReturnStatement(ReturnStatement statement) {
        this.onLineNumber(statement);
        statement.getExpression().visit(this);
        Expression assignExpr = this.createReturnLHSExpression(statement.getExpression());
        if (assignExpr != null) {
            this.leftHandExpression = false;
            assignExpr.visit(this);
        }
        Class c = this.getExpressionType(statement.getExpression());
        String returnType = this.methodNode.getReturnType();
        this.helper.unbox(returnType);
        if (returnType.equals("double")) {
            this.cv.visitInsn(175);
        } else if (returnType.equals("float")) {
            this.cv.visitInsn(174);
        } else if (returnType.equals("long")) {
            this.cv.visitInsn(173);
        } else if (returnType.equals("boolean")) {
            this.cv.visitInsn(172);
        } else if (returnType.equals("char") || returnType.equals("byte") || returnType.equals("int") || returnType.equals("short")) {
            this.cv.visitInsn(172);
        } else if (c == Boolean.class) {
            Label l0 = new Label();
            this.cv.visitJumpInsn(153, l0);
            this.cv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            this.cv.visitInsn(176);
            this.cv.visitLabel(l0);
            this.cv.visitFieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.cv.visitInsn(176);
        } else {
            if (this.isValidTypeForCast(returnType) && !returnType.equals(c.getName())) {
                this.doConvertAndCast(returnType);
            }
            this.cv.visitInsn(176);
        }
        this.outputReturn = true;
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        this.onLineNumber(statement);
        Expression expression = statement.getExpression();
        this.visitAndAutobox(expression);
        if (this.isPopRequired(expression)) {
            this.cv.visitInsn(87);
        }
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        switch (expression.getOperation().getType()) {
            case 100: {
                this.evaluateEqual(expression);
                break;
            }
            case 110: {
                this.evaluateBinaryExpression(this.compareIdenticalMethod, expression);
                break;
            }
            case 115: {
                this.evaluateBinaryExpression(this.compareEqualMethod, expression);
                break;
            }
            case 90: {
                this.evaluateBinaryExpression(this.compareNotEqualMethod, expression);
                break;
            }
            case 155: {
                this.evaluateCompareTo(expression);
                break;
            }
            case 140: {
                this.evaluateBinaryExpression(this.compareGreaterThanMethod, expression);
                break;
            }
            case 150: {
                this.evaluateBinaryExpression(this.compareGreaterThanEqualMethod, expression);
                break;
            }
            case 120: {
                this.evaluateBinaryExpression(this.compareLessThanMethod, expression);
                break;
            }
            case 130: {
                this.evaluateBinaryExpression(this.compareLessThanEqualMethod, expression);
                break;
            }
            case 170: {
                this.evaluateLogicalAndExpression(expression);
                break;
            }
            case 160: {
                this.evaluateLogicalOrExpression(expression);
                break;
            }
            case 180: {
                this.evaluateBinaryExpression("plus", expression);
                break;
            }
            case 200: {
                this.evaluateBinaryExpressionWithAsignment("plus", expression);
                break;
            }
            case 210: {
                this.evaluateBinaryExpression("minus", expression);
                break;
            }
            case 230: {
                this.evaluateBinaryExpressionWithAsignment("minus", expression);
                break;
            }
            case 280: {
                this.evaluateBinaryExpression("multiply", expression);
                break;
            }
            case 290: {
                this.evaluateBinaryExpressionWithAsignment("multiply", expression);
                break;
            }
            case 240: {
                this.evaluateBinaryExpression("div", expression);
                break;
            }
            case 250: {
                this.evaluateBinaryExpressionWithAsignment("div", expression);
                break;
            }
            case 317: {
                this.evaluateBinaryExpression("leftShift", expression);
                break;
            }
            case 318: {
                this.evaluateBinaryExpression("rightShift", expression);
                break;
            }
            case 520: {
                this.evaluateInstanceof(expression);
                break;
            }
            case 105: {
                this.evaluateBinaryExpression(this.findRegexMethod, expression);
                break;
            }
            case 106: {
                this.evaluateBinaryExpression(this.matchRegexMethod, expression);
                break;
            }
            case 30: {
                if (this.leftHandExpression) {
                    throw new RuntimeException("Should not be called");
                }
                this.evaluateBinaryExpression("getAt", expression);
                break;
            }
            default: {
                throw new ClassGeneratorException("Operation: " + expression.getOperation() + " not supported");
            }
        }
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        switch (expression.getOperation().getType()) {
            case 190: {
                this.evaluatePostfixMethod("next", expression.getExpression());
                break;
            }
            case 220: {
                this.evaluatePostfixMethod("previous", expression.getExpression());
            }
        }
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        switch (expression.getOperation().getType()) {
            case 190: {
                this.evaluatePrefixMethod("next", expression.getExpression());
                break;
            }
            case 220: {
                this.evaluatePrefixMethod("previous", expression.getExpression());
            }
        }
    }

    public void visitClosureExpression(ClosureExpression expression) {
        String name;
        Parameter param;
        int i;
        ClassNode innerClass = this.createClosureClass(expression);
        this.addInnerClass(innerClass);
        String innerClassinternalName = BytecodeHelper.getClassInternalName(innerClass.getName());
        ClassNode owner = innerClass.getOuterClass();
        String ownerTypeName = owner.getName();
        if (this.classNode.isStaticClass() || this.isStaticMethod()) {
            ownerTypeName = "java.lang.Class";
        }
        this.passingClosureParams = true;
        List constructors = innerClass.getConstructors();
        ConstructorNode node = (ConstructorNode)constructors.get(0);
        Parameter[] localVariableParams = node.getParameters();
        for (i = 2; i < localVariableParams.length; ++i) {
            param = localVariableParams[i];
            name = param.getName();
            if (this.variableStack.get(name) != null || this.classNode.getField(name) != null) continue;
            this.defineVariable(name, "java.lang.Object");
        }
        this.cv.visitTypeInsn(187, innerClassinternalName);
        this.cv.visitInsn(89);
        if (this.isStaticMethod() || this.classNode.isStaticClass()) {
            this.visitClassExpression(new ClassExpression(ownerTypeName));
        } else {
            this.loadThisOrOwner();
        }
        if (innerClass.getSuperClass().equals("groovy.lang.Closure")) {
            if (this.isStaticMethod()) {
                this.visitClassExpression(new ClassExpression(ownerTypeName));
            } else {
                this.loadThisOrOwner();
            }
        }
        for (i = 2; i < localVariableParams.length; ++i) {
            param = localVariableParams[i];
            name = param.getName();
            if (this.variableStack.get(name) == null) {
                this.visitFieldExpression(new FieldExpression(this.classNode.getField(name)));
                continue;
            }
            this.visitVariableExpression(new VariableExpression(name));
        }
        this.passingClosureParams = false;
        this.cv.visitMethodInsn(183, innerClassinternalName, "<init>", BytecodeHelper.getMethodDescriptor("void", localVariableParams));
    }

    protected void loadThisOrOwner() {
        if (this.isInnerClass()) {
            this.visitFieldExpression(new FieldExpression(this.classNode.getField("owner")));
        } else {
            this.cv.visitVarInsn(25, 0);
        }
    }

    public void visitRegexExpression(RegexExpression expression) {
        expression.getRegex().visit(this);
        this.regexPattern.call(this.cv);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        Object value = expression.getValue();
        if (value == null) {
            this.cv.visitInsn(1);
        } else if (value instanceof String) {
            this.cv.visitLdcInsn(value);
        } else if (value instanceof Number) {
            Number n = (Number)value;
            String className = BytecodeHelper.getClassInternalName(value.getClass().getName());
            this.cv.visitTypeInsn(187, className);
            this.cv.visitInsn(89);
            String methodType = "(I)V";
            if (n instanceof Double) {
                methodType = "(D)V";
            } else if (n instanceof Float) {
                methodType = "(F)V";
            }
            this.cv.visitLdcInsn((Object)n);
            this.cv.visitMethodInsn(183, className, "<init>", methodType);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            String text = bool != false ? "TRUE" : "FALSE";
            this.cv.visitFieldInsn(178, "java/lang/Boolean", text, "Ljava/lang/Boolean;");
        } else {
            throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName());
        }
    }

    public void visitNegationExpression(NegationExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        this.negation.call(this.cv);
    }

    public void visitCastExpression(CastExpression expression) {
        String type = expression.getType();
        type = this.checkValidType(type, (ASTNode)expression, "in cast");
        this.visitAndAutobox(expression.getExpression());
        this.doConvertAndCast(type);
    }

    public void visitNotExpression(NotExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        if (this.comparisonExpression(expression.getExpression())) {
            this.notBoolean.call(this.cv);
        } else {
            this.notObject.call(this.cv);
        }
    }

    public void visitBooleanExpression(BooleanExpression expression) {
        expression.getExpression().visit(this);
        if (!this.comparisonExpression(expression.getExpression())) {
            this.asBool.call(this.cv);
        }
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        this.leftHandExpression = false;
        Expression arguments = call.getArguments();
        boolean superMethodCall = MethodCallExpression.isSuperMethodCall(call);
        String method = call.getMethod();
        if (superMethodCall && method.equals("<init>")) {
            this.cv.visitVarInsn(25, 0);
            this.cv.visitVarInsn(25, 1);
            this.cv.visitMethodInsn(183, this.internalBaseClassName, "<init>", "(Ljava/lang/Object;)V");
        } else if (this.isThisExpression(call.getObjectExpression()) && this.isFieldOrVariable(call.getMethod())) {
            this.visitVariableExpression(new VariableExpression(method));
            arguments.visit(this);
            this.invokeClosureMethod.call(this.cv);
        } else if (this.emptyArguments(arguments) && !call.isSafe()) {
            call.getObjectExpression().visit(this);
            this.cv.visitLdcInsn((Object)method);
            this.invokeNoArgumentsMethod.call(this.cv);
        } else {
            if (this.argumentsUseStack(arguments)) {
                int paramIdx = this.defineVariable(this.createVariableName("temp"), "java.lang.Object", false).getIndex();
                arguments.visit(this);
                this.cv.visitVarInsn(58, paramIdx);
                call.getObjectExpression().visit(this);
                this.cv.visitLdcInsn((Object)method);
                this.cv.visitVarInsn(25, paramIdx);
            } else {
                call.getObjectExpression().visit(this);
                this.cv.visitLdcInsn((Object)method);
                arguments.visit(this);
            }
            if (superMethodCall) {
                this.invokeSuperMethodMethod.call(this.cv);
            } else if (call.isSafe()) {
                this.invokeMethodSafeMethod.call(this.cv);
            } else {
                this.invokeMethodMethod.call(this.cv);
            }
        }
    }

    protected boolean emptyArguments(Expression arguments) {
        if (arguments instanceof TupleExpression) {
            TupleExpression tupleExpression = (TupleExpression)arguments;
            int size = tupleExpression.getExpressions().size();
            return size == 0;
        }
        return false;
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        this.leftHandExpression = false;
        Expression arguments = call.getArguments();
        if (this.emptyArguments(arguments)) {
            this.cv.visitLdcInsn((Object)call.getType());
            this.cv.visitLdcInsn((Object)call.getMethod());
            this.invokeStaticNoArgumentsMethod.call(this.cv);
        } else {
            TupleExpression tupleExpression;
            int size;
            if (arguments instanceof TupleExpression && (size = (tupleExpression = (TupleExpression)arguments).getExpressions().size()) == 1) {
                arguments = (Expression)tupleExpression.getExpressions().get(0);
            }
            this.cv.visitLdcInsn((Object)call.getType());
            this.cv.visitLdcInsn((Object)call.getMethod());
            arguments.visit(this);
            this.invokeStaticMethodMethod.call(this.cv);
        }
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.leftHandExpression = false;
        Expression arguments = call.getArguments();
        if (arguments instanceof TupleExpression) {
            TupleExpression tupleExpression = (TupleExpression)arguments;
            int size = tupleExpression.getExpressions().size();
            if (size == 0) {
                arguments = ConstantExpression.EMPTY_ARRAY;
            } else if (size == 1) {
                arguments = (Expression)tupleExpression.getExpressions().get(0);
            }
        }
        String type = this.checkValidType(call.getType(), (ASTNode)call, "in constructor call");
        this.visitClassExpression(new ClassExpression(type));
        arguments.visit(this);
        this.invokeConstructorOfMethod.call(this.cv);
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        String name;
        FieldNode field;
        String className = this.checkForQualifiedClass(expression);
        if (className != null) {
            this.visitClassExpression(new ClassExpression(className));
            return;
        }
        Expression objectExpression = expression.getObjectExpression();
        if (expression.getProperty().equals("class")) {
            if (objectExpression instanceof ClassExpression) {
                this.visitClassExpression((ClassExpression)objectExpression);
                return;
            }
            if (objectExpression instanceof VariableExpression) {
                VariableExpression varExp = (VariableExpression)objectExpression;
                className = varExp.getVariable();
                try {
                    className = this.resolveClassName(className);
                    this.visitClassExpression(new ClassExpression(className));
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.isThisExpression(objectExpression) && (field = this.classNode.getField(name = expression.getProperty())) != null) {
            this.visitFieldExpression(new FieldExpression(field));
            return;
        }
        boolean left = this.leftHandExpression;
        this.leftHandExpression = false;
        objectExpression.visit(this);
        this.cv.visitLdcInsn((Object)expression.getProperty());
        if (expression.isSafe()) {
            if (left) {
                this.setPropertySafeMethod2.call(this.cv);
            } else {
                this.getPropertySafeMethod.call(this.cv);
            }
        } else if (left) {
            this.setPropertyMethod2.call(this.cv);
        } else {
            this.getPropertyMethod.call(this.cv);
        }
    }

    protected String checkForQualifiedClass(PropertyExpression expression) {
        String text = expression.getText();
        try {
            return this.resolveClassName(text);
        }
        catch (Exception e) {
            if (text.endsWith(".class")) {
                text = text.substring(0, text.length() - 6);
                try {
                    return this.resolveClassName(text);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public void visitFieldExpression(FieldExpression expression) {
        String ownerName;
        boolean holder;
        FieldNode field = expression.getField();
        boolean isStatic = field.isStatic();
        boolean bl = holder = field.isHolder() && !this.isInClosureConstructor();
        if (!isStatic && !this.leftHandExpression) {
            this.cv.visitVarInsn(25, 0);
        }
        String type = field.getType();
        int tempIndex = this.defineVariable(this.createVariableName("field"), "java.lang.Object", false).getIndex();
        if (this.leftHandExpression && !holder) {
            if (this.isInClosureConstructor()) {
                this.helper.doCast(type);
            } else {
                this.doConvertAndCast(type);
            }
        }
        int opcode = this.leftHandExpression && !holder ? (isStatic ? 179 : 181) : (isStatic ? 178 : 180);
        String string = ownerName = field.getOwner().equals(this.classNode.getName()) ? this.internalClassName : org.objectweb.asm.Type.getInternalName((Class)this.loadClass(field.getOwner()));
        if (holder) {
            if (this.leftHandExpression) {
                this.cv.visitVarInsn(58, tempIndex);
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(opcode, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(type));
                this.cv.visitVarInsn(25, tempIndex);
                this.cv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
            } else {
                this.cv.visitFieldInsn(opcode, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(type));
                this.cv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
            }
        } else {
            this.cv.visitFieldInsn(opcode, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(type));
            if (!this.leftHandExpression && this.helper.isPrimitiveType(type)) {
                this.helper.box(type);
            }
        }
    }

    protected void visitOuterFieldExpression(FieldExpression expression) {
        FieldNode field;
        boolean isStatic;
        ClassNode outerClassNode = this.classNode.getOuterClass();
        if (outerClassNode instanceof InnerClassNode) {
            this.visitPropertyExpression(new PropertyExpression(new FieldExpression(this.classNode.getField("owner")), expression.getFieldName()));
            return;
        }
        int valueIdx = this.defineVariable(this.createVariableName("temp"), "java.lang.Object", false).getIndex();
        if (this.leftHandExpression) {
            this.cv.visitVarInsn(58, valueIdx);
        }
        if (!(isStatic = (field = expression.getField()).isStatic())) {
            this.cv.visitVarInsn(25, 0);
            this.cv.visitFieldInsn(180, this.internalClassName, "owner", BytecodeHelper.getTypeDescription(outerClassNode.getName()));
        }
        int opcode = this.leftHandExpression ? (isStatic ? 179 : 181) : (isStatic ? 178 : 180);
        String ownerName = BytecodeHelper.getClassInternalName(outerClassNode.getName());
        if (this.leftHandExpression) {
            boolean holder;
            this.cv.visitVarInsn(25, valueIdx);
            boolean bl = holder = field.isHolder() && !this.isInClosureConstructor();
            if (!holder) {
                this.doConvertAndCast(field.getType());
            }
        }
        this.cv.visitFieldInsn(opcode, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(field.getType()));
    }

    public void visitVariableExpression(VariableExpression expression) {
        String className;
        String variableName = expression.getVariable();
        if (this.isStaticMethod() && variableName.equals("this")) {
            this.visitClassExpression(new ClassExpression(this.classNode.getName()));
            return;
        }
        if (variableName.equals("super")) {
            this.visitClassExpression(new ClassExpression(this.classNode.getSuperClass()));
            return;
        }
        if (!variableName.equals("this") && (className = this.resolveClassName(variableName)) != null) {
            if (this.leftHandExpression) {
                throw new RuntimeParserException("Cannot use a class expression on the left hand side of an assignment", expression);
            }
            this.visitClassExpression(new ClassExpression(className));
            return;
        }
        FieldNode field = this.classNode.getField(variableName);
        if (field != null && this.variableStack.get(variableName) == null) {
            this.visitFieldExpression(new FieldExpression(field));
        } else {
            field = this.classNode.getOuterField(variableName);
            if (field != null) {
                this.visitOuterFieldExpression(new FieldExpression(field));
            } else {
                boolean holder;
                String name = variableName;
                Variable variable = null;
                String variableType = expression.getType();
                boolean useProperty = this.isInScriptBody();
                if (!this.leftHandExpression) {
                    variable = (Variable)this.variableStack.get(name);
                } else if (!useProperty) {
                    variable = this.defineVariable(name, variableType);
                }
                if (variable == null || variable.isProperty()) {
                    if (variable == null) {
                        variable = this.defineVariable(name, variableType);
                        variable.setProperty(true);
                    }
                    if (variable.isHolder() && this.passingClosureParams && useProperty) {
                        this.cv.visitTypeInsn(187, "org/codehaus/groovy/runtime/ScriptReference");
                        this.cv.visitInsn(89);
                        this.loadThisOrOwner();
                        this.cv.visitLdcInsn((Object)name);
                        this.cv.visitMethodInsn(183, "org/codehaus/groovy/runtime/ScriptReference", "<init>", "(Lgroovy/lang/Script;Ljava/lang/String;)V");
                    } else {
                        this.visitPropertyExpression(new PropertyExpression(VariableExpression.THIS_EXPRESSION, name));
                    }
                    return;
                }
                String type = variable.getTypeName();
                int index = variable.getIndex();
                boolean bl = holder = variable.isHolder() && !this.passingClosureParams;
                if (this.leftHandExpression) {
                    if (holder) {
                        int tempIndex = this.defineVariable(this.createVariableName("reference"), variableType, false).getIndex();
                        this.cv.visitVarInsn(58, tempIndex);
                        this.cv.visitVarInsn(25, index);
                        this.cv.visitVarInsn(25, tempIndex);
                        this.cv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
                    } else if (type.equals("double")) {
                        this.cv.visitVarInsn(57, index);
                    } else if (type.equals("float")) {
                        this.cv.visitVarInsn(56, index);
                    } else if (type.equals("long")) {
                        this.cv.visitVarInsn(55, index);
                    } else if (type.equals("byte") || type.equals("short") || type.equals("boolean") || type.equals("int")) {
                        this.cv.visitVarInsn(54, index);
                    } else {
                        this.cv.visitVarInsn(58, index);
                    }
                } else if (holder) {
                    this.cv.visitVarInsn(25, index);
                    this.cv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
                } else {
                    this.cv.visitVarInsn(25, index);
                }
            }
        }
    }

    protected boolean isInScriptBody() {
        if (this.classNode.isScriptBody()) {
            return true;
        }
        return this.classNode.isScript() && this.methodNode != null && this.methodNode.getName().equals("run");
    }

    protected boolean isPopRequired(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            return !MethodCallExpression.isSuperMethodCall((MethodCallExpression)expression);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binExp = (BinaryExpression)expression;
            switch (binExp.getOperation().getType()) {
                case 100: 
                case 200: 
                case 230: 
                case 250: 
                case 270: 
                case 290: {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean firstStatementIsSuperMethodCall(Statement code) {
        ExpressionStatement expStmt;
        Object expr;
        BlockStatement block;
        if (code instanceof BlockStatement && !(block = (BlockStatement)code).getStatements().isEmpty() && (expr = block.getStatements().get(0)) instanceof ExpressionStatement && (expr = (expStmt = (ExpressionStatement)expr).getExpression()) instanceof MethodCallExpression) {
            return MethodCallExpression.isSuperMethodCall((MethodCallExpression)expr);
        }
        return false;
    }

    protected void createSyntheticStaticFields() {
        Iterator iter = this.syntheticStaticFields.iterator();
        while (iter.hasNext()) {
            String staticFieldName = (String)iter.next();
            this.cw.visitField(65544, staticFieldName, "Ljava/lang/Class;", null, null);
        }
        if (!this.syntheticStaticFields.isEmpty()) {
            this.cv = this.cw.visitMethod(65544, "class$", "(Ljava/lang/String;)Ljava/lang/Class;", null, null);
            this.helper = new BytecodeHelper(this.cv);
            Label l0 = new Label();
            this.cv.visitLabel(l0);
            this.cv.visitVarInsn(25, 0);
            this.cv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            Label l1 = new Label();
            this.cv.visitLabel(l1);
            this.cv.visitInsn(176);
            Label l2 = new Label();
            this.cv.visitLabel(l2);
            this.cv.visitVarInsn(58, 1);
            this.cv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
            this.cv.visitInsn(89);
            this.cv.visitVarInsn(25, 1);
            this.cv.visitMethodInsn(182, "java/lang/ClassNotFoundException", "getMessage", "()Ljava/lang/String;");
            this.cv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V");
            this.cv.visitInsn(191);
            this.cv.visitTryCatchBlock(l0, l1, l2, "java/lang/ClassNotFoundException");
            this.cv.visitMaxs(3, 2);
            this.cw.visitEnd();
        }
    }

    public void visitClassExpression(ClassExpression expression) {
        String type = expression.getText();
        if (this.helper.isPrimitiveType(type)) {
            String objectType = this.helper.getObjectTypeForPrimitive(type);
            this.cv.visitFieldInsn(178, BytecodeHelper.getClassInternalName(objectType), "TYPE", "Ljava/lang/Class;");
        } else {
            String staticFieldName = type.equals(this.classNode.getName()) ? "class$0" : "class$" + type.replace('.', '$');
            this.syntheticStaticFields.add(staticFieldName);
            this.cv.visitFieldInsn(178, this.internalClassName, staticFieldName, "Ljava/lang/Class;");
            Label l0 = new Label();
            this.cv.visitJumpInsn(199, l0);
            this.cv.visitLdcInsn((Object)type);
            this.cv.visitMethodInsn(184, this.internalClassName, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
            this.cv.visitInsn(89);
            this.cv.visitFieldInsn(179, this.internalClassName, staticFieldName, "Ljava/lang/Class;");
            Label l1 = new Label();
            this.cv.visitJumpInsn(167, l1);
            this.cv.visitLabel(l0);
            this.cv.visitFieldInsn(178, this.internalClassName, staticFieldName, "Ljava/lang/Class;");
            this.cv.visitLabel(l1);
        }
    }

    public void visitRangeExpression(RangeExpression expression) {
        this.leftHandExpression = false;
        expression.getFrom().visit(this);
        this.leftHandExpression = false;
        expression.getTo().visit(this);
        this.helper.pushConstant(expression.isInclusive());
        this.createRangeMethod.call(this.cv);
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
    }

    public void visitMapExpression(MapExpression expression) {
        List entries = expression.getMapEntryExpressions();
        int size = entries.size();
        this.helper.pushConstant(size * 2);
        this.cv.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            MapEntryExpression entry = (MapEntryExpression)iter.next();
            this.cv.visitInsn(89);
            this.helper.pushConstant(i++);
            this.visitAndAutobox(entry.getKeyExpression());
            this.cv.visitInsn(83);
            this.cv.visitInsn(89);
            this.helper.pushConstant(i++);
            this.visitAndAutobox(entry.getValueExpression());
            this.cv.visitInsn(83);
        }
        this.createMapMethod.call(this.cv);
    }

    public void visitTupleExpression(TupleExpression expression) {
        int size = expression.getExpressions().size();
        this.helper.pushConstant(size);
        this.cv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < size; ++i) {
            this.cv.visitInsn(89);
            this.helper.pushConstant(i);
            this.visitAndAutobox(expression.getExpression(i));
            this.cv.visitInsn(83);
        }
    }

    public void visitArrayExpression(ArrayExpression expression) {
        String typeName = BytecodeHelper.getClassInternalName(expression.getType());
        Expression sizeExpression = expression.getSizeExpression();
        if (sizeExpression != null) {
            this.visitAndAutobox(sizeExpression);
            this.asIntMethod.call(this.cv);
            this.cv.visitTypeInsn(189, typeName);
        } else {
            int size = expression.getExpressions().size();
            this.helper.pushConstant(size);
            this.cv.visitTypeInsn(189, typeName);
            for (int i = 0; i < size; ++i) {
                this.cv.visitInsn(89);
                this.helper.pushConstant(i);
                Expression elementExpression = expression.getExpression(i);
                if (elementExpression == null) {
                    ConstantExpression.NULL.visit(this);
                } else {
                    this.visitAndAutobox(elementExpression);
                }
                this.cv.visitInsn(83);
            }
        }
    }

    public void visitListExpression(ListExpression expression) {
        int size = expression.getExpressions().size();
        this.helper.pushConstant(size);
        this.cv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < size; ++i) {
            this.cv.visitInsn(89);
            this.helper.pushConstant(i);
            this.visitAndAutobox(expression.getExpression(i));
            this.cv.visitInsn(83);
        }
        this.createListMethod.call(this.cv);
    }

    public void visitGStringExpression(GStringExpression expression) {
        int size = expression.getValues().size();
        this.helper.pushConstant(size);
        this.cv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < size; ++i) {
            this.cv.visitInsn(89);
            this.helper.pushConstant(i);
            this.visitAndAutobox(expression.getValue(i));
            this.cv.visitInsn(83);
        }
        int paramIdx = this.defineVariable(this.createVariableName("iterator"), "java.lang.Object", false).getIndex();
        this.cv.visitVarInsn(58, paramIdx);
        ClassNode innerClass = this.createGStringClass(expression);
        this.addInnerClass(innerClass);
        String innerClassinternalName = BytecodeHelper.getClassInternalName(innerClass.getName());
        this.cv.visitTypeInsn(187, innerClassinternalName);
        this.cv.visitInsn(89);
        this.cv.visitVarInsn(25, paramIdx);
        this.cv.visitMethodInsn(183, innerClassinternalName, "<init>", "([Ljava/lang/Object;)V");
    }

    protected boolean addInnerClass(ClassNode innerClass) {
        innerClass.setModule(this.classNode.getModule());
        return this.innerClasses.add(innerClass);
    }

    protected ClassNode createClosureClass(ClosureExpression expression) {
        Parameter[] parameters;
        boolean staticMethodOrInStaticClass;
        ClassNode owner = this.getOutermostClass();
        boolean parentIsInnerClass = owner instanceof InnerClassNode;
        String outerClassName = owner.getName();
        String name = outerClassName + "$" + this.context.getNextInnerClassIdx();
        boolean bl = staticMethodOrInStaticClass = this.isStaticMethod() || this.classNode.isStaticClass();
        if (staticMethodOrInStaticClass) {
            outerClassName = "java.lang.Class";
        }
        if ((parameters = expression.getParameters()) == null || parameters.length == 0) {
            parameters = new Parameter[]{new Parameter("it")};
        }
        Parameter[] localVariableParams = this.getClosureSharedVariables(expression);
        InnerClassNode answer = new InnerClassNode(owner, name, 1, "groovy.lang.Closure");
        if (staticMethodOrInStaticClass) {
            answer.setStaticClass(true);
        }
        if (this.isInScriptBody()) {
            answer.setScriptBody(true);
        }
        MethodNode method = answer.addMethod("doCall", 1, "java.lang.Object", parameters, expression.getCode());
        method.setLineNumber(expression.getLineNumber());
        method.setColumnNumber(expression.getColumnNumber());
        VariableScope scope = expression.getVariableScope();
        if (scope == null) {
            throw new RuntimeException("Must have a VariableScope by now! for expression: " + expression + " class: " + name);
        }
        method.setVariableScope(scope);
        if (parameters.length > 1 || parameters.length == 1 && parameters[0].getType() != null && !parameters[0].getType().equals("java.lang.Object")) {
            answer.addMethod("call", 1, "java.lang.Object", parameters, new ReturnStatement(new MethodCallExpression(VariableExpression.THIS_EXPRESSION, "doCall", new ArgumentListExpression(parameters))));
        }
        FieldNode field = answer.addField("owner", 2, outerClassName, null);
        BlockStatement block = new BlockStatement();
        block.addStatement(new ExpressionStatement(new MethodCallExpression(new VariableExpression("super"), "<init>", new VariableExpression("_outerInstance"))));
        block.addStatement(new ExpressionStatement(new BinaryExpression(new FieldExpression(field), Token.equal(-1, -1), new VariableExpression("_outerInstance"))));
        for (int i = 0; i < localVariableParams.length; ++i) {
            Parameter param = localVariableParams[i];
            String paramName = param.getName();
            boolean holder = this.mutableVars.contains(paramName);
            VariableExpression initialValue = null;
            String type = param.getType();
            if (holder) {
                initialValue = new VariableExpression(paramName);
                type = (class$groovy$lang$Reference == null ? ClassGenerator.class$("groovy.lang.Reference") : class$groovy$lang$Reference).getName();
                param.makeReference();
            }
            FieldNode paramField = null;
            if (holder) {
                paramField = answer.addField(paramName, 2, type, initialValue);
                paramField.setHolder(true);
                String realType = param.getRealType();
                String methodName = Verifier.capitalize(paramName);
                FieldExpression fieldExp = new FieldExpression(paramField);
                answer.addMethod("get" + methodName, 1, realType, Parameter.EMPTY_ARRAY, new ReturnStatement(fieldExp));
            } else {
                PropertyNode propertyNode = answer.addProperty(paramName, 1, type, initialValue, null, null);
                paramField = propertyNode.getField();
            }
            if (holder) continue;
            block.addStatement(new ExpressionStatement(new BinaryExpression(new FieldExpression(paramField), Token.equal(-1, -1), new VariableExpression(paramName))));
        }
        Parameter[] params = new Parameter[2 + localVariableParams.length];
        params[0] = new Parameter(outerClassName, "_outerInstance");
        params[1] = new Parameter("java.lang.Object", "_delegate");
        System.arraycopy(localVariableParams, 0, params, 2, localVariableParams.length);
        answer.addConstructor(1, params, block);
        return answer;
    }

    protected ClassNode getOutermostClass() {
        if (this.outermostClass == null) {
            this.outermostClass = this.classNode;
            while (this.outermostClass instanceof InnerClassNode) {
                this.outermostClass = this.outermostClass.getOuterClass();
            }
        }
        return this.outermostClass;
    }

    protected ClassNode createGStringClass(GStringExpression expression) {
        ClassNode owner = this.classNode;
        if (owner instanceof InnerClassNode) {
            owner = owner.getOuterClass();
        }
        String outerClassName = owner.getName();
        String name = outerClassName + "$" + this.context.getNextInnerClassIdx();
        InnerClassNode answer = new InnerClassNode(owner, name, 1, GString.class.getName());
        FieldNode stringsField = answer.addField("strings", 10, "java.lang.String[]", new ArrayExpression("java.lang.String", expression.getStrings()));
        answer.addMethod("getStrings", 1, "java.lang.String[]", Parameter.EMPTY_ARRAY, new ReturnStatement(new FieldExpression(stringsField)));
        BlockStatement block = new BlockStatement();
        block.addStatement(new ExpressionStatement(new MethodCallExpression(new VariableExpression("super"), "<init>", new VariableExpression("values"))));
        Parameter[] contructorParams = new Parameter[]{new Parameter("java.lang.Object[]", "values")};
        answer.addConstructor(1, contructorParams, block);
        return answer;
    }

    protected void doConvertAndCast(String type) {
        if (!type.equals("java.lang.Object")) {
            if (!type.endsWith("[]") && this.isValidTypeForCast(type)) {
                this.visitClassExpression(new ClassExpression(type));
                this.asTypeMethod.call(this.cv);
            }
            this.helper.doCast(type);
        }
    }

    protected void evaluateLogicalOrExpression(BinaryExpression expression) {
        this.visitBooleanExpression(new BooleanExpression(expression.getLeftExpression()));
        Label l0 = new Label();
        Label l2 = new Label();
        this.cv.visitJumpInsn(153, l0);
        this.cv.visitLabel(l2);
        this.visitConstantExpression(ConstantExpression.TRUE);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        this.visitBooleanExpression(new BooleanExpression(expression.getRightExpression()));
        this.cv.visitJumpInsn(154, l2);
        this.visitConstantExpression(ConstantExpression.FALSE);
        this.cv.visitLabel(l1);
    }

    protected void evaluateLogicalAndExpression(BinaryExpression expression) {
        this.visitBooleanExpression(new BooleanExpression(expression.getLeftExpression()));
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        this.visitBooleanExpression(new BooleanExpression(expression.getRightExpression()));
        this.cv.visitJumpInsn(153, l0);
        this.visitConstantExpression(ConstantExpression.TRUE);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        this.visitConstantExpression(ConstantExpression.FALSE);
        this.cv.visitLabel(l1);
    }

    protected void evaluateBinaryExpression(String method, BinaryExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        this.leftHandExpression = false;
        leftExpression.visit(this);
        this.cv.visitLdcInsn((Object)method);
        this.leftHandExpression = false;
        new ArgumentListExpression(new Expression[]{expression.getRightExpression()}).visit(this);
        this.invokeMethodMethod.call(this.cv);
    }

    protected void evaluateCompareTo(BinaryExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        this.leftHandExpression = false;
        leftExpression.visit(this);
        expression.getRightExpression().visit(this);
        this.compareToMethod.call(this.cv);
    }

    protected void evaluateBinaryExpressionWithAsignment(String method, BinaryExpression expression) {
        BinaryExpression leftBinExpr;
        Expression leftExpression = expression.getLeftExpression();
        if (leftExpression instanceof BinaryExpression && (leftBinExpr = (BinaryExpression)leftExpression).getOperation().getType() == 30) {
            MethodCallExpression methodCall = new MethodCallExpression(expression.getLeftExpression(), method, new ArgumentListExpression(new Expression[]{expression.getRightExpression()}));
            Expression safeIndexExpr = this.createReusableExpression(leftBinExpr.getRightExpression());
            this.visitMethodCallExpression(new MethodCallExpression(leftBinExpr.getLeftExpression(), "putAt", new ArgumentListExpression(new Expression[]{safeIndexExpr, methodCall})));
            this.cv.visitInsn(87);
            return;
        }
        this.evaluateBinaryExpression(method, expression);
        this.leftHandExpression = true;
        leftExpression.visit(this);
        this.leftHandExpression = false;
    }

    protected void evaluateBinaryExpression(MethodCaller compareMethod, BinaryExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        this.leftHandExpression = false;
        leftExpression.visit(this);
        this.leftHandExpression = false;
        expression.getRightExpression().visit(this);
        compareMethod.call(this.cv);
    }

    protected void evaluateEqual(BinaryExpression expression) {
        BinaryExpression leftBinExpr;
        Expression leftExpression = expression.getLeftExpression();
        if (leftExpression instanceof BinaryExpression && (leftBinExpr = (BinaryExpression)leftExpression).getOperation().getType() == 30) {
            this.visitMethodCallExpression(new MethodCallExpression(leftBinExpr.getLeftExpression(), "putAt", new ArgumentListExpression(new Expression[]{leftBinExpr.getRightExpression(), expression.getRightExpression()})));
            this.cv.visitInsn(87);
            return;
        }
        if (this.isNonStaticField(leftExpression)) {
            this.cv.visitVarInsn(25, 0);
        }
        this.leftHandExpression = false;
        Expression rightExpression = expression.getRightExpression();
        String type = this.getLHSType(leftExpression);
        if (type != null) {
            if (this.helper.isPrimitiveType(type)) {
                rightExpression.visit(this);
            } else {
                this.visitCastExpression(new CastExpression(type, rightExpression));
            }
        } else {
            this.visitAndAutobox(rightExpression);
        }
        this.leftHandExpression = true;
        leftExpression.visit(this);
        this.leftHandExpression = false;
    }

    protected String getLHSType(Expression leftExpression) {
        if (leftExpression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)leftExpression;
            String type = varExp.getType();
            if (this.isValidTypeForCast(type)) {
                return type;
            }
            String variableName = varExp.getVariable();
            Variable variable = (Variable)this.variableStack.get(variableName);
            if (variable != null) {
                if (variable.isHolder() || variable.isProperty()) {
                    return null;
                }
                type = variable.getTypeName();
                if (this.isValidTypeForCast(type)) {
                    return type;
                }
            } else {
                FieldNode field = this.classNode.getField(variableName);
                if (field == null) {
                    field = this.classNode.getOuterField(variableName);
                }
                if (field != null) {
                    type = field.getType();
                    if (!field.isHolder() && this.isValidTypeForCast(type)) {
                        return type;
                    }
                }
            }
        }
        return null;
    }

    protected boolean isValidTypeForCast(String type) {
        return type != null && !type.equals("java.lang.Object") && !type.equals("groovy.lang.Reference");
    }

    protected void visitAndAutobox(Expression expression) {
        expression.visit(this);
        if (this.comparisonExpression(expression)) {
            Label l0 = new Label();
            this.cv.visitJumpInsn(153, l0);
            this.cv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            Label l1 = new Label();
            this.cv.visitJumpInsn(167, l1);
            this.cv.visitLabel(l0);
            this.cv.visitFieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.cv.visitLabel(l1);
        }
    }

    protected void evaluatePrefixMethod(String method, Expression expression) {
        expression.visit(this);
        this.cv.visitLdcInsn((Object)method);
        ArgumentListExpression.EMPTY_ARGUMENTS.visit(this);
        this.invokeMethodMethod.call(this.cv);
        this.leftHandExpression = true;
        expression.visit(this);
        this.leftHandExpression = false;
        expression.visit(this);
    }

    protected void evaluatePostfixMethod(String method, Expression expression) {
        this.leftHandExpression = false;
        expression.visit(this);
        int tempIdx = this.defineVariable(this.createVariableName("postfix"), "java.lang.Object", false).getIndex();
        this.cv.visitVarInsn(58, tempIdx);
        this.cv.visitVarInsn(25, tempIdx);
        this.cv.visitLdcInsn((Object)method);
        ArgumentListExpression.EMPTY_ARGUMENTS.visit(this);
        this.invokeMethodMethod.call(this.cv);
        this.leftHandExpression = true;
        expression.visit(this);
        this.leftHandExpression = false;
        this.cv.visitVarInsn(25, tempIdx);
    }

    protected boolean isHolderVariable(Expression expression) {
        if (expression instanceof FieldExpression) {
            FieldExpression fieldExp = (FieldExpression)expression;
            return fieldExp.getField().isHolder();
        }
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            FieldNode field = this.classNode.getField(varExp.getVariable());
            Variable variable = (Variable)this.variableStack.get(varExp.getVariable());
            if (field != null && variable == null) {
                return field.isHolder();
            }
            return variable.isHolder();
        }
        return false;
    }

    protected void evaluateInstanceof(BinaryExpression expression) {
        expression.getLeftExpression().visit(this);
        Expression rightExp = expression.getRightExpression();
        String className = null;
        if (!(rightExp instanceof ClassExpression)) {
            throw new RuntimeException("Right hand side of the instanceof keyworld must be a class name, not: " + rightExp);
        }
        ClassExpression classExp = (ClassExpression)rightExp;
        className = classExp.getType();
        className = this.checkValidType(className, (ASTNode)expression, "Must be a valid type name for an instanceof statement");
        String classInternalName = BytecodeHelper.getClassInternalName(className);
        this.cv.visitTypeInsn(193, classInternalName);
    }

    protected boolean argumentsUseStack(Expression arguments) {
        return arguments instanceof TupleExpression || arguments instanceof ClosureExpression;
    }

    protected boolean isNonStaticField(Expression expression) {
        FieldNode field = null;
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            field = this.classNode.getField(varExp.getVariable());
        } else if (expression instanceof FieldExpression) {
            FieldExpression fieldExp = (FieldExpression)expression;
            field = this.classNode.getField(fieldExp.getFieldName());
        } else if (expression instanceof PropertyExpression) {
            PropertyExpression fieldExp = (PropertyExpression)expression;
            field = this.classNode.getField(fieldExp.getProperty());
        }
        if (field != null) {
            return !field.isStatic();
        }
        return false;
    }

    protected boolean isThisExpression(Expression expression) {
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            return varExp.getVariable().equals("this");
        }
        return false;
    }

    protected Expression createReturnLHSExpression(Expression expression) {
        BinaryExpression binExpr;
        if (expression instanceof BinaryExpression && (binExpr = (BinaryExpression)expression).getOperation().isAssignmentToken()) {
            return this.createReusableExpression(binExpr.getLeftExpression());
        }
        return null;
    }

    protected Expression createReusableExpression(Expression expression) {
        ExpressionTransformer transformer = new ExpressionTransformer(){

            public Expression transform(Expression expression) {
                if (expression instanceof PostfixExpression) {
                    PostfixExpression postfixExp = (PostfixExpression)expression;
                    return postfixExp.getExpression();
                }
                if (expression instanceof PrefixExpression) {
                    PrefixExpression prefixExp = (PrefixExpression)expression;
                    return prefixExp.getExpression();
                }
                return expression;
            }
        };
        return transformer.transform(expression.transformExpression(transformer));
    }

    protected boolean comparisonExpression(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)expression;
            switch (binExpr.getOperation().getType()) {
                case 90: 
                case 106: 
                case 110: 
                case 115: 
                case 120: 
                case 130: 
                case 140: 
                case 150: 
                case 520: {
                    return true;
                }
            }
        } else if (expression instanceof BooleanExpression) {
            return true;
        }
        return false;
    }

    protected void onLineNumber(ASTNode statement) {
        int number = statement.getLineNumber();
        if (number >= 0 && this.cv != null) {
            this.cv.visitLineNumber(number, new Label());
        }
    }

    protected VariableScope getVariableScope() {
        if (this.variableScope == null) {
            if (this.methodNode != null) {
                this.variableScope = this.methodNode.getVariableScope();
                if (this.variableScope == null) {
                    this.variableScope = new VariableScope();
                    this.methodNode.setVariableScope(this.variableScope);
                    VariableScopeCodeVisitor visitor = new VariableScopeCodeVisitor(this.variableScope);
                    visitor.setParameters(this.methodNode.getParameters());
                    Statement code = this.methodNode.getCode();
                    if (code != null) {
                        code.visit(visitor);
                    }
                }
                this.addFieldsToVisitor(this.variableScope);
            } else if (this.constructorNode != null) {
                this.variableScope = new VariableScope();
                this.constructorNode.setVariableScope(this.variableScope);
                VariableScopeCodeVisitor visitor = new VariableScopeCodeVisitor(this.variableScope);
                visitor.setParameters(this.constructorNode.getParameters());
                Statement code = this.constructorNode.getCode();
                if (code != null) {
                    code.visit(visitor);
                }
                this.addFieldsToVisitor(this.variableScope);
            } else {
                throw new RuntimeException("Can't create a variable scope outside of a method or constructor");
            }
        }
        return this.variableScope;
    }

    protected Parameter[] getClosureSharedVariables(ClosureExpression expression) {
        String type;
        String var;
        ArrayList<Parameter> vars = new ArrayList<Parameter>();
        VariableScope outerScope = this.getVariableScope().createRecursiveParentScope();
        VariableScope innerScope = expression.getVariableScope();
        if (innerScope == null) {
            System.out.println("No variable scope for: " + expression + " method: " + this.methodNode + " constructor: " + this.constructorNode);
            innerScope = new VariableScope(this.getVariableScope());
        } else {
            innerScope = innerScope.createRecursiveChildScope();
        }
        Set outerDecls = outerScope.getDeclaredVariables();
        Set outerRefs = outerScope.getReferencedVariables();
        Set innerDecls = innerScope.getDeclaredVariables();
        Set innerRefs = innerScope.getReferencedVariables();
        HashSet<String> varSet = new HashSet<String>();
        Iterator iter = innerRefs.iterator();
        while (iter.hasNext()) {
            var = (String)iter.next();
            if (!outerDecls.contains(var) || !this.isNotFieldOfOutermostClass(var)) continue;
            type = this.getVariableType(var);
            vars.add(new Parameter(type, var));
            varSet.add(var);
        }
        iter = outerRefs.iterator();
        while (iter.hasNext()) {
            var = (String)iter.next();
            if (!innerDecls.contains(var) || !this.isNotFieldOfOutermostClass(var) || varSet.contains(var)) continue;
            type = this.getVariableType(var);
            vars.add(new Parameter(type, var));
        }
        Parameter[] answer = new Parameter[vars.size()];
        vars.toArray(answer);
        return answer;
    }

    protected boolean isNotFieldOfOutermostClass(String var) {
        return this.getOutermostClass().getField(var) == null;
    }

    protected void findMutableVariables() {
        String var;
        VariableScope outerScope = this.getVariableScope();
        VariableScope innerScope = outerScope.createCompositeChildScope();
        Set outerDecls = outerScope.getDeclaredVariables();
        Set outerRefs = outerScope.getReferencedVariables();
        Set innerDecls = innerScope.getDeclaredVariables();
        Set innerRefs = innerScope.getReferencedVariables();
        this.mutableVars.clear();
        Iterator iter = innerDecls.iterator();
        while (iter.hasNext()) {
            var = (String)iter.next();
            if (!outerDecls.contains(var) && !outerRefs.contains(var) || this.classNode.getField(var) != null) continue;
            this.mutableVars.add(var);
        }
        iter = innerRefs.iterator();
        while (iter.hasNext()) {
            var = (String)iter.next();
            if (!outerDecls.contains(var) || this.classNode.getField(var) != null) continue;
            this.mutableVars.add(var);
        }
    }

    protected void addFieldsToVisitor(VariableScope scope) {
        Iterator iter = this.classNode.getFields().iterator();
        while (iter.hasNext()) {
            FieldNode field = (FieldNode)iter.next();
            String name = field.getName();
            scope.getDeclaredVariables().add(name);
            scope.getReferencedVariables().add(name);
        }
    }

    private boolean isInnerClass() {
        return this.classNode instanceof InnerClassNode;
    }

    protected String getVariableType(String name) {
        Variable variable = (Variable)this.variableStack.get(name);
        if (variable != null) {
            return variable.getTypeName();
        }
        return null;
    }

    protected void resetVariableStack(Parameter[] parameters) {
        this.lastVariableIndex = -1;
        this.variableStack.clear();
        this.scope = null;
        this.pushBlockScope();
        this.definingParameters = true;
        if (!this.isStaticMethod()) {
            this.defineVariable("this", this.classNode.getName()).getIndex();
        }
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String type = parameter.getType();
            int idx = this.defineVariable(parameter.getName(), type).getIndex();
            if (!this.helper.isPrimitiveType(type)) continue;
            this.helper.load(type, idx);
            this.helper.box(type);
            this.cv.visitVarInsn(58, idx);
        }
        this.definingParameters = false;
    }

    protected void popScope() {
        int lastID = this.scope.getLastVariableIndex();
        ArrayList<String> removeKeys = new ArrayList<String>();
        Iterator iter = this.variableStack.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            Variable value = (Variable)entry.getValue();
            if (value.getIndex() < lastID) continue;
            removeKeys.add(name);
        }
        iter = removeKeys.iterator();
        while (iter.hasNext()) {
            this.variableStack.remove(iter.next());
        }
        this.scope = this.scope.getParent();
    }

    protected void pushBlockScope() {
        this.scope = new BlockScope(this.scope);
        this.scope.setLastVariableIndex(this.getNextVariableID());
    }

    protected Variable defineVariable(String name, String type) {
        return this.defineVariable(name, type, true);
    }

    protected Variable defineVariable(String name, String type, boolean define) {
        return this.defineVariable(name, new Type(type), define);
    }

    private Variable defineVariable(String name, Type type, boolean define) {
        Variable answer = (Variable)this.variableStack.get(name);
        if (answer == null) {
            this.lastVariableIndex = this.getNextVariableID();
            answer = new Variable(this.lastVariableIndex, type, name);
            if (this.mutableVars.contains(name)) {
                answer.setHolder(true);
            }
            this.variableStack.put(name, answer);
            if (define) {
                if (this.definingParameters) {
                    if (answer.isHolder()) {
                        this.cv.visitTypeInsn(187, "groovy/lang/Reference");
                        this.cv.visitInsn(89);
                        this.cv.visitVarInsn(25, this.lastVariableIndex);
                        this.cv.visitMethodInsn(183, "groovy/lang/Reference", "<init>", "(Ljava/lang/Object;)V");
                        this.cv.visitVarInsn(58, this.lastVariableIndex);
                    }
                } else if (answer.isHolder() && !this.isInScriptBody()) {
                    this.cv.visitTypeInsn(187, "groovy/lang/Reference");
                    this.cv.visitInsn(89);
                    this.cv.visitMethodInsn(183, "groovy/lang/Reference", "<init>", "()V");
                    this.cv.visitVarInsn(58, this.lastVariableIndex);
                } else if (!this.leftHandExpression) {
                    this.cv.visitInsn(1);
                    this.cv.visitVarInsn(58, this.lastVariableIndex);
                }
            }
        }
        return answer;
    }

    private int getNextVariableID() {
        return Math.max(this.lastVariableIndex + 1, this.variableStack.size());
    }

    protected boolean isFieldOrVariable(String name) {
        return this.variableStack.containsKey(name) || this.classNode.getField(name) != null;
    }

    protected Type checkValidType(Type type, ASTNode node, String message) {
        if (type.isDynamic()) {
            return type;
        }
        String name = this.checkValidType(type.getName(), node, message);
        if (type.getName().equals(name)) {
            return type;
        }
        return new Type(name);
    }

    protected String checkValidType(String type, ASTNode node, String message) {
        if (this.helper.isPrimitiveType(type)) {
            return type;
        }
        String original = type;
        if ((type = this.resolveClassName(type)) != null) {
            return type;
        }
        throw new MissingClassException(original, node, message);
    }

    protected String resolveClassName(String type) {
        return this.classNode.resolveClassName(type);
    }

    protected String createVariableName(String type) {
        return "__" + type + ++tempVariableNameCounter;
    }

    protected Class getExpressionType(Expression expression) {
        if (this.comparisonExpression(expression)) {
            return Boolean.class;
        }
        return Object.class;
    }

    protected boolean isPrimitiveFieldType(String type) {
        return type.equals("java.lang.String") || type.equals("java.lang.Integer") || type.equals("java.lang.Double") || type.equals("java.lang.Long") || type.equals("java.lang.Float");
    }

    protected boolean isInClosureConstructor() {
        return this.constructorNode != null && this.classNode.getOuterClass() != null && this.classNode.getSuperClass().equals(Closure.class.getName());
    }

    protected boolean isStaticMethod() {
        if (this.methodNode == null) {
            return false;
        }
        return this.methodNode.isStatic();
    }

    protected Class loadClass(String name) {
        try {
            CompileUnit compileUnit = this.getCompileUnit();
            if (compileUnit != null) {
                return compileUnit.loadClass(name);
            }
            throw new ClassGeneratorException("Could not load class: " + name);
        }
        catch (ClassNotFoundException e) {
            throw new ClassGeneratorException("Could not load class: " + name + " reason: " + e, e);
        }
    }

    protected CompileUnit getCompileUnit() {
        CompileUnit answer = this.classNode.getCompileUnit();
        if (answer == null) {
            answer = this.context.getCompileUnit();
        }
        return answer;
    }
}

