/**
 * Documentation:  https://dlang.org/phobos/dmd_strictvisitor.html
 * Coverage:    https://codecov.io/gh/dlang/dmd/src/master/src/dmd/strictvisitor.d
 */

module dmd.strictvisitor;

import dmd.parsetimevisitor;

/** The StrictVisitor asserts 0 an all visiting functions in order to
  * make sure that all the nodes are visited.
  */
extern(C++) class StrictVisitor(AST) : ParseTimeVisitor!AST
{
    alias visit = ParseTimeVisitor!AST.visit;

    override void visit(AST.Dsymbol) { assert(0); }
    override void visit(AST.AliasThis) { assert(0); }
    override void visit(AST.Declaration) { assert(0); }
    override void visit(AST.ScopeDsymbol) { assert(0); }
    override void visit(AST.Import) { assert(0); }
    override void visit(AST.AttribDeclaration) { assert(0); }
    override void visit(AST.StaticAssert) { assert(0); }
    override void visit(AST.DebugSymbol) { assert(0); }
    override void visit(AST.VersionSymbol) { assert(0); }
    override void visit(AST.VarDeclaration) { assert(0); }
    override void visit(AST.FuncDeclaration) { assert(0); }
    override void visit(AST.AliasDeclaration) { assert(0); }
    override void visit(AST.TupleDeclaration) { assert(0); }
    override void visit(AST.FuncLiteralDeclaration) { assert(0); }
    override void visit(AST.PostBlitDeclaration) { assert(0); }
    override void visit(AST.CtorDeclaration) { assert(0); }
    override void visit(AST.DtorDeclaration) { assert(0); }
    override void visit(AST.InvariantDeclaration) { assert(0); }
    override void visit(AST.UnitTestDeclaration) { assert(0); }
    override void visit(AST.NewDeclaration) { assert(0); }
    override void visit(AST.DeleteDeclaration) { assert(0); }
    override void visit(AST.StaticCtorDeclaration) { assert(0); }
    override void visit(AST.StaticDtorDeclaration) { assert(0); }
    override void visit(AST.SharedStaticCtorDeclaration) { assert(0); }
    override void visit(AST.SharedStaticDtorDeclaration) { assert(0); }
    override void visit(AST.Package) { assert(0); }
    override void visit(AST.EnumDeclaration) { assert(0); }
    override void visit(AST.AggregateDeclaration) { assert(0); }
    override void visit(AST.TemplateDeclaration) { assert(0); }
    override void visit(AST.TemplateInstance) { assert(0); }
    override void visit(AST.Nspace) { assert(0); }
    override void visit(AST.CompileDeclaration) { assert(0); }
    override void visit(AST.UserAttributeDeclaration) { assert(0); }
    override void visit(AST.LinkDeclaration) { assert(0); }
    override void visit(AST.AnonDeclaration) { assert(0); }
    override void visit(AST.AlignDeclaration) { assert(0); }
    override void visit(AST.CPPMangleDeclaration) { assert(0); }
    override void visit(AST.ProtDeclaration) { assert(0); }
    override void visit(AST.PragmaDeclaration) { assert(0); }
    override void visit(AST.StorageClassDeclaration) { assert(0); }
    override void visit(AST.ConditionalDeclaration) { assert(0); }
    override void visit(AST.DeprecatedDeclaration) { assert(0); }
    override void visit(AST.StaticIfDeclaration) { assert(0); }
    override void visit(AST.EnumMember) { assert(0); }
    override void visit(AST.Module) { assert(0); }
    override void visit(AST.StructDeclaration) { assert(0); }
    override void visit(AST.UnionDeclaration) { assert(0); }
    override void visit(AST.ClassDeclaration) { assert(0); }
    override void visit(AST.InterfaceDeclaration) { assert(0); }
    override void visit(AST.TemplateMixin) { assert(0); }
    override void visit(AST.Parameter) { assert(0); }
    override void visit(AST.Statement) { assert(0); }
    override void visit(AST.ImportStatement) { assert(0); }
    override void visit(AST.ScopeStatement) { assert(0); }
    override void visit(AST.ReturnStatement) { assert(0); }
    override void visit(AST.LabelStatement) { assert(0); }
    override void visit(AST.StaticAssertStatement) { assert(0); }
    override void visit(AST.CompileStatement) { assert(0); }
    override void visit(AST.WhileStatement) { assert(0); }
    override void visit(AST.ForStatement) { assert(0); }
    override void visit(AST.DoStatement) { assert(0); }
    override void visit(AST.ForeachRangeStatement) { assert(0); }
    override void visit(AST.ForeachStatement) { assert(0); }
    override void visit(AST.IfStatement) { assert(0); }
    override void visit(AST.OnScopeStatement) { assert(0); }
    override void visit(AST.ConditionalStatement) { assert(0); }
    override void visit(AST.PragmaStatement) { assert(0); }
    override void visit(AST.SwitchStatement) { assert(0); }
    override void visit(AST.CaseRangeStatement) { assert(0); }
    override void visit(AST.CaseStatement) { assert(0); }
    override void visit(AST.DefaultStatement) { assert(0); }
    override void visit(AST.BreakStatement) { assert(0); }
    override void visit(AST.ContinueStatement) { assert(0); }
    override void visit(AST.GotoDefaultStatement) { assert(0); }
    override void visit(AST.GotoCaseStatement) { assert(0); }
    override void visit(AST.GotoStatement) { assert(0); }
    override void visit(AST.SynchronizedStatement) { assert(0); }
    override void visit(AST.WithStatement) { assert(0); }
    override void visit(AST.TryCatchStatement) { assert(0); }
    override void visit(AST.TryFinallyStatement) { assert(0); }
    override void visit(AST.ThrowStatement) { assert(0); }
    override void visit(AST.AsmStatement) { assert(0); }
    override void visit(AST.ExpStatement) { assert(0); }
    override void visit(AST.CompoundStatement) { assert(0); }
    override void visit(AST.CompoundDeclarationStatement) { assert(0); }
    override void visit(AST.CompoundAsmStatement) { assert(0); }
    override void visit(AST.InlineAsmStatement) { assert(0); }
    override void visit(AST.Type) { assert(0); }
    override void visit(AST.TypeBasic) { assert(0); }
    override void visit(AST.TypeError) { assert(0); }
    override void visit(AST.TypeNull) { assert(0); }
    override void visit(AST.TypeVector) { assert(0); }
    override void visit(AST.TypeEnum) { assert(0); }
    override void visit(AST.TypeTuple) { assert(0); }
    override void visit(AST.TypeClass) { assert(0); }
    override void visit(AST.TypeStruct) { assert(0); }
    override void visit(AST.TypeNext) { assert(0); }
    override void visit(AST.TypeReference) { assert(0); }
    override void visit(AST.TypeSlice) { assert(0); }
    override void visit(AST.TypeDelegate) { assert(0); }
    override void visit(AST.TypePointer) { assert(0); }
    override void visit(AST.TypeFunction) { assert(0); }
    override void visit(AST.TypeArray) { assert(0); }
    override void visit(AST.TypeDArray) { assert(0); }
    override void visit(AST.TypeAArray) { assert(0); }
    override void visit(AST.TypeSArray) { assert(0); }
    override void visit(AST.TypeQualified) { assert(0); }
    override void visit(AST.TypeIdentifier) { assert(0); }
    override void visit(AST.TypeReturn) { assert(0); }
    override void visit(AST.TypeTypeof) { assert(0); }
    override void visit(AST.TypeInstance) { assert(0); }
    override void visit(AST.Expression) { assert(0); }
    override void visit(AST.DeclarationExp) { assert(0); }
    override void visit(AST.IntegerExp) { assert(0); }
    override void visit(AST.NewAnonClassExp) { assert(0); }
    override void visit(AST.IsExp) { assert(0); }
    override void visit(AST.RealExp) { assert(0); }
    override void visit(AST.NullExp) { assert(0); }
    override void visit(AST.TypeidExp) { assert(0); }
    override void visit(AST.TraitsExp) { assert(0); }
    override void visit(AST.StringExp) { assert(0); }
    override void visit(AST.NewExp) { assert(0); }
    override void visit(AST.AssocArrayLiteralExp) { assert(0); }
    override void visit(AST.ArrayLiteralExp) { assert(0); }
    override void visit(AST.FuncExp) { assert(0); }
    override void visit(AST.IntervalExp) { assert(0); }
    override void visit(AST.TypeExp) { assert(0); }
    override void visit(AST.ScopeExp) { assert(0); }
    override void visit(AST.IdentifierExp) { assert(0); }
    override void visit(AST.UnaExp) { assert(0); }
    override void visit(AST.DefaultInitExp) { assert(0); }
    override void visit(AST.BinExp) { assert(0); }
    override void visit(AST.DsymbolExp) { assert(0); }
    override void visit(AST.TemplateExp) { assert(0); }
    override void visit(AST.SymbolExp) { assert(0); }
    override void visit(AST.VarExp) { assert(0); }
    override void visit(AST.TupleExp) { assert(0); }
    override void visit(AST.DollarExp) { assert(0); }
    override void visit(AST.ThisExp) { assert(0); }
    override void visit(AST.SuperExp) { assert(0); }
    override void visit(AST.AddrExp) { assert(0); }
    override void visit(AST.PreExp) { assert(0); }
    override void visit(AST.PtrExp) { assert(0); }
    override void visit(AST.NegExp) { assert(0); }
    override void visit(AST.UAddExp) { assert(0); }
    override void visit(AST.NotExp) { assert(0); }
    override void visit(AST.ComExp) { assert(0); }
    override void visit(AST.DeleteExp) { assert(0); }
    override void visit(AST.CastExp) { assert(0); }
    override void visit(AST.CallExp) { assert(0); }
    override void visit(AST.DotIdExp) { assert(0); }
    override void visit(AST.AssertExp) { assert(0); }
    override void visit(AST.CompileExp) { assert(0); }
    override void visit(AST.ImportExp) { assert(0); }
    override void visit(AST.DotTemplateInstanceExp) { assert(0); }
    override void visit(AST.ArrayExp) { assert(0); }
    override void visit(AST.FuncInitExp) { assert(0); }
    override void visit(AST.PrettyFuncInitExp) { assert(0); }
    override void visit(AST.FileInitExp) { assert(0); }
    override void visit(AST.LineInitExp) { assert(0); }
    override void visit(AST.ModuleInitExp) { assert(0); }
    override void visit(AST.CommaExp) { assert(0); }
    override void visit(AST.PostExp) { assert(0); }
    override void visit(AST.PowExp) { assert(0); }
    override void visit(AST.MulExp) { assert(0); }
    override void visit(AST.DivExp) { assert(0); }
    override void visit(AST.ModExp) { assert(0); }
    override void visit(AST.AddExp) { assert(0); }
    override void visit(AST.MinExp) { assert(0); }
    override void visit(AST.CatExp) { assert(0); }
    override void visit(AST.ShlExp) { assert(0); }
    override void visit(AST.ShrExp) { assert(0); }
    override void visit(AST.UshrExp) { assert(0); }
    override void visit(AST.EqualExp) { assert(0); }
    override void visit(AST.InExp) { assert(0); }
    override void visit(AST.IdentityExp) { assert(0); }
    override void visit(AST.CmpExp) { assert(0); }
    override void visit(AST.AndExp) { assert(0); }
    override void visit(AST.XorExp) { assert(0); }
    override void visit(AST.OrExp) { assert(0); }
    override void visit(AST.LogicalExp) { assert(0); }
    override void visit(AST.CondExp) { assert(0); }
    override void visit(AST.AssignExp) { assert(0); }
    override void visit(AST.BinAssignExp) { assert(0); }
    override void visit(AST.AddAssignExp) { assert(0); }
    override void visit(AST.MinAssignExp) { assert(0); }
    override void visit(AST.MulAssignExp) { assert(0); }
    override void visit(AST.DivAssignExp) { assert(0); }
    override void visit(AST.ModAssignExp) { assert(0); }
    override void visit(AST.PowAssignExp) { assert(0); }
    override void visit(AST.AndAssignExp) { assert(0); }
    override void visit(AST.OrAssignExp) { assert(0); }
    override void visit(AST.XorAssignExp) { assert(0); }
    override void visit(AST.ShlAssignExp) { assert(0); }
    override void visit(AST.ShrAssignExp) { assert(0); }
    override void visit(AST.UshrAssignExp) { assert(0); }
    override void visit(AST.CatAssignExp) { assert(0); }
    override void visit(AST.TemplateParameter) { assert(0); }
    override void visit(AST.TemplateAliasParameter) { assert(0); }
    override void visit(AST.TemplateTypeParameter) { assert(0); }
    override void visit(AST.TemplateTupleParameter) { assert(0); }
    override void visit(AST.TemplateValueParameter) { assert(0); }
    override void visit(AST.TemplateThisParameter) { assert(0); }
    override void visit(AST.Condition) { assert(0); }
    override void visit(AST.StaticIfCondition) { assert(0); }
    override void visit(AST.DVCondition) { assert(0); }
    override void visit(AST.DebugCondition) { assert(0); }
    override void visit(AST.VersionCondition) { assert(0); }
    override void visit(AST.Initializer) { assert(0); }
    override void visit(AST.ExpInitializer) { assert(0); }
    override void visit(AST.StructInitializer) { assert(0); }
    override void visit(AST.ArrayInitializer) { assert(0); }
    override void visit(AST.VoidInitializer) { assert(0); }
}
