/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.id;

class Relation {
    Accessible accessible;
    Accessible[] targets;
    int type;

    Relation(Accessible accessible, int n) {
        this.accessible = accessible;
        this.type = n;
        this.targets = new Accessible[0];
    }

    void addTarget(Accessible accessible) {
        if (this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, accessibleArray, 0, this.targets.length);
        accessibleArray[this.targets.length] = accessible;
        this.targets = accessibleArray;
    }

    boolean containsTarget(Accessible accessible) {
        int n = 0;
        while (n < this.targets.length) {
            if (this.targets[n] == accessible) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void removeTarget(Accessible accessible) {
        if (!this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < this.targets.length) {
            if (this.targets[n2] != accessible) {
                accessibleArray[n++] = this.targets[n2];
            }
            ++n2;
        }
        this.targets = accessibleArray;
    }

    id getTitleUIElement() {
        id id2 = null;
        int n = 0;
        while (n < this.targets.length) {
            Accessible accessible = this.targets[n];
            id2 = accessible.accessibleHandle(accessible);
            ++n;
        }
        return id2;
    }

    id getServesAsTitleForUIElements() {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.targets.length);
        int n = 0;
        while (n < this.targets.length) {
            Accessible accessible = this.targets[n];
            id id2 = accessible.accessibleHandle(accessible);
            nSMutableArray.addObject(id2);
            ++n;
        }
        return nSMutableArray;
    }

    id getLinkedUIElements() {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.targets.length);
        int n = 0;
        while (n < this.targets.length) {
            Accessible accessible = this.targets[n];
            id id2 = accessible.accessibleHandle(accessible);
            nSMutableArray.addObject(id2);
            ++n;
        }
        return nSMutableArray;
    }
}

