/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Buf;
import fan.sys.DateTime;
import fan.sys.File;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.LocalFile;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import fan.sys.Uri;
import fan.sys.Zip;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipEntryFile
extends File {
    final Object parent;
    final ZipEntry entry;

    public ZipEntryFile(ZipFile zipFile, ZipEntry zipEntry, Uri uri) {
        super(uri);
        this.parent = zipFile;
        this.entry = zipEntry;
    }

    public ZipEntryFile(ZipFile zipFile, ZipEntry zipEntry) {
        this(zipFile, zipEntry, ZipEntryFile.entryUri(zipEntry));
    }

    public ZipEntryFile(Zip zip, ZipEntry zipEntry) {
        super(ZipEntryFile.entryUri(zipEntry));
        this.parent = zip;
        this.entry = zipEntry;
    }

    static Uri entryUri(ZipEntry zipEntry) {
        return Uri.fromStr("/" + LocalFile.fileNameToUriName(zipEntry.getName()));
    }

    public Type typeof() {
        return Sys.ZipEntryFileType;
    }

    public boolean exists() {
        return true;
    }

    public Long size() {
        if (this.isDir()) {
            return null;
        }
        long l = this.entry.getSize();
        if (l < 0L) {
            return null;
        }
        return l;
    }

    public DateTime modified() {
        return DateTime.fromJava(this.entry.getTime());
    }

    public void modified(DateTime dateTime) {
        throw IOErr.make("ZipEntryFile is readonly");
    }

    public String osPath() {
        return null;
    }

    public File parent() {
        return null;
    }

    public List list() {
        return new List(Sys.FileType, 0);
    }

    public File normalize() {
        return this;
    }

    public File plus(Uri uri, boolean bl) {
        throw UnsupportedErr.make("ZipEntryFile.plus");
    }

    public File create() {
        throw IOErr.make("ZipEntryFile is readonly");
    }

    public File moveTo(File file) {
        throw IOErr.make("ZipEntryFile is readonly");
    }

    public void delete() {
        throw IOErr.make("ZipEntryFile is readonly");
    }

    public File deleteOnExit() {
        throw IOErr.make("ZipEntryFile is readonly");
    }

    public Buf open(String string) {
        throw UnsupportedErr.make("ZipEntryFile.open");
    }

    public Buf mmap(String string, long l, Long l2) {
        throw UnsupportedErr.make("ZipEntryFile.mmap");
    }

    public InStream in(Long l) {
        try {
            InputStream inputStream;
            if (this.parent instanceof Zip) {
                inputStream = new FilterInputStream(((Zip)this.parent).zipIn){

                    public void close() {
                    }
                };
            } else {
                inputStream = ((ZipFile)this.parent).getInputStream(this.entry);
                if (l != null && l != 0L) {
                    inputStream = new BufferedInputStream(inputStream, l.intValue());
                }
            }
            return new SysInStream(inputStream);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public OutStream out(boolean bl, Long l) {
        throw IOErr.make("ZipEntryFile is readonly");
    }
}

