/*
 * Decompiled with CFR 0.152.
 */
package fanx.serial;

import fan.sys.FanDecimal;
import fan.sys.FanFloat;
import fan.sys.FanObj;
import fan.sys.Field;
import fan.sys.Func;
import fan.sys.FuncType;
import fan.sys.IOErr;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.MapType;
import fan.sys.Method;
import fan.sys.OutStream;
import fan.sys.Serializable;
import fan.sys.StrBufOutStream;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.serial.Literal;
import fanx.util.OpUtil;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;

public class ObjEncoder {
    static final FuncType eachIteratorType = new FuncType(new Type[]{Sys.ObjType}, Sys.VoidType);
    OutStream out;
    int level = 0;
    int indent = 0;
    boolean skipDefaults = false;
    boolean skipErrors = false;
    Type curFieldType;

    public static String encode(Object object) {
        StrBufOutStream strBufOutStream = new StrBufOutStream();
        new ObjEncoder(strBufOutStream, null).writeObj(object);
        return strBufOutStream.string();
    }

    public ObjEncoder(OutStream outStream, Map map) {
        this.out = outStream;
        if (map != null) {
            this.initOptions(map);
        }
    }

    public void writeObj(Object object) {
        if (object == null) {
            this.w("null");
            return;
        }
        if (object.getClass().getName().charAt(0) == 'j') {
            if (object instanceof Boolean) {
                this.w(object.toString());
                return;
            }
            if (object instanceof String) {
                this.wStrLiteral(object.toString(), '\"');
                return;
            }
            if (object instanceof Long) {
                this.w(object.toString());
                return;
            }
            if (object instanceof Double) {
                FanFloat.encode((Double)object, this);
                return;
            }
            if (object instanceof BigDecimal) {
                FanDecimal.encode((BigDecimal)object, this);
                return;
            }
        }
        if (object instanceof Literal) {
            ((Literal)object).encode(this);
            return;
        }
        Type type = FanObj.typeof(object);
        Serializable serializable = (Serializable)type.facet(Sys.SerializableType, false);
        if (serializable != null) {
            if (serializable.simple) {
                this.writeSimple(type, object);
            } else {
                this.writeComplex(type, object, serializable);
            }
        } else if (this.skipErrors) {
            this.w("null /* Not serializable: ").w(type.qname()).w(" */");
        } else {
            throw IOErr.make("Not serializable: " + type);
        }
    }

    private void writeSimple(Type type, Object object) {
        this.wType(type).w('(').wStrLiteral(FanObj.toStr(object), '\"').w(')');
    }

    private void writeComplex(Type type, Object object, Serializable serializable) {
        this.wType(type);
        boolean bl = true;
        Object object2 = null;
        if (this.skipDefaults) {
            object2 = FanObj.typeof(object).make();
        }
        List list = type.fields();
        for (int i = 0; i < list.sz(); ++i) {
            Object object3;
            Field field = (Field)list.get(i);
            if (field.isStatic() || field.isSynthetic() || field.hasFacet(Sys.TransientType)) continue;
            Object object4 = field.get(object);
            if (object2 != null && OpUtil.compareEQ(object4, object3 = field.get(object2))) continue;
            if (bl) {
                this.w('\n').wIndent().w('{').w('\n');
                ++this.level;
                bl = false;
            }
            this.wIndent().w(field.name()).w('=');
            this.curFieldType = field.type().toNonNullable();
            this.writeObj(object4);
            this.curFieldType = null;
            this.w('\n');
        }
        if (serializable.collection) {
            bl = this.writeCollectionItems(type, object, bl);
        }
        if (!bl) {
            --this.level;
            this.wIndent().w('}');
        }
    }

    private boolean writeCollectionItems(Type type, Object object, boolean bl) {
        Method method = type.method("each", false);
        if (method == null) {
            throw IOErr.make("Missing " + type.qname() + ".each");
        }
        EachIterator eachIterator = new EachIterator(bl);
        method.invoke(object, new Object[]{eachIterator});
        return eachIterator.first;
    }

    public void writeList(List list) {
        int n;
        Type type = list.of();
        boolean bl = this.isMultiLine(type);
        boolean bl2 = false;
        if (this.curFieldType != null && this.curFieldType.fits(Sys.ListType)) {
            bl2 = true;
        }
        this.curFieldType = null;
        if (!bl2) {
            this.wType(type);
        }
        if ((n = list.sz()) == 0) {
            this.w("[,]");
            return;
        }
        if (bl) {
            this.w('\n').wIndent();
        }
        this.w('[');
        ++this.level;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.w(',');
            }
            if (bl) {
                this.w('\n').wIndent();
            }
            this.writeObj(list.get(i));
        }
        --this.level;
        if (bl) {
            this.w('\n').wIndent();
        }
        this.w(']');
    }

    public void writeMap(Map map) {
        MapType mapType = (MapType)map.typeof();
        boolean bl = this.isMultiLine(mapType.k) || this.isMultiLine(mapType.v);
        boolean bl2 = false;
        if (this.curFieldType != null && this.curFieldType.fits(Sys.MapType)) {
            bl2 = true;
        }
        this.curFieldType = null;
        if (!bl2) {
            this.wType(mapType);
        }
        if (map.isEmpty()) {
            this.w("[:]");
            return;
        }
        ++this.level;
        this.w('[');
        boolean bl3 = true;
        Iterator iterator = map.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (bl3) {
                bl3 = false;
            } else {
                this.w(',');
            }
            if (bl) {
                this.w('\n').wIndent();
            }
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.writeObj(k);
            this.w(':');
            this.writeObj(v);
        }
        this.w(']');
        --this.level;
    }

    private boolean isMultiLine(Type type) {
        return type.pod() != Sys.sysPod;
    }

    public final ObjEncoder wType(Type type) {
        return this.w(type.signature());
    }

    public final ObjEncoder wStrLiteral(String string, char c) {
        int n = string.length();
        this.w(c);
        block10: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '\n': {
                    this.w('\\').w('n');
                    continue block10;
                }
                case '\r': {
                    this.w('\\').w('r');
                    continue block10;
                }
                case '\f': {
                    this.w('\\').w('f');
                    continue block10;
                }
                case '\t': {
                    this.w('\\').w('t');
                    continue block10;
                }
                case '\\': {
                    this.w('\\').w('\\');
                    continue block10;
                }
                case '\"': {
                    if (c == '\"') {
                        this.w('\\').w('\"');
                        continue block10;
                    }
                    this.w(c2);
                    continue block10;
                }
                case '`': {
                    if (c == '`') {
                        this.w('\\').w('`');
                        continue block10;
                    }
                    this.w(c2);
                    continue block10;
                }
                case '$': {
                    this.w('\\').w('$');
                    continue block10;
                }
                default: {
                    this.w(c2);
                }
            }
        }
        return this.w(c);
    }

    public final ObjEncoder wIndent() {
        int n = this.level * this.indent;
        for (int i = 0; i < n; ++i) {
            this.w(' ');
        }
        return this;
    }

    public final ObjEncoder w(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.out.writeChar(string.charAt(i));
        }
        return this;
    }

    public final ObjEncoder w(char c) {
        this.out.writeChar(c);
        return this;
    }

    private void initOptions(Map map) {
        this.indent = ObjEncoder.option(map, "indent", this.indent);
        this.skipDefaults = ObjEncoder.option(map, "skipDefaults", this.skipDefaults);
        this.skipErrors = ObjEncoder.option(map, "skipErrors", this.skipErrors);
    }

    private static int option(Map map, String string, int n) {
        Long l = (Long)map.get(string);
        if (l == null) {
            return n;
        }
        return l.intValue();
    }

    private static boolean option(Map map, String string, boolean bl) {
        Boolean bl2 = (Boolean)map.get(string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    class EachIterator
    extends Func.Indirect1 {
        boolean first;

        EachIterator(boolean bl) {
            super(eachIteratorType);
            this.first = bl;
        }

        public Object call(Object object) {
            if (this.first) {
                ObjEncoder.this.w('\n').wIndent().w('{').w('\n');
                ++ObjEncoder.this.level;
                this.first = false;
            }
            ObjEncoder.this.wIndent();
            ObjEncoder.this.writeObj(object);
            ObjEncoder.this.w(',').w('\n');
            return null;
        }
    }
}

