//==========================================================================
// (c) Microsoft Corporation 2005-2007.
//==========================================================================

#light

namespace Microsoft.FSharp.Compatibility

/// Operations to manipulate .NET-compatible arrays, only really necessary
/// use when using .NET 1.x.
module CompatArray = 

    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Collections

    #if CLI_AT_LEAST_2_0

    /// Build a new array that contains the elements of the first array followed by the elements of the second array
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val append: 'a[] -> 'a[] -> 'a[]

    /// Read a range of elements from the first array and write them into the second.
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val blit: 'a[] -> int -> 'a[] -> int -> int -> unit

    /// Build a new array that contains the elements of each of the given list of arrays
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val concat: 'a[] list -> 'a[]

    /// Build a new array that contains the elements of the given array
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val copy: 'a[] -> 'a[]

    /// Create a new array of the given length, each entry of which holds the given element
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val create: int -> 'a -> 'a[]

    /// Fill a range of an array with the given element
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val fill: 'a[] -> int -> int -> 'a -> unit

    /// Apply a function to each element of the collection, threading an 'accumulator' argument
    /// through the computation. If the elements are "i0...iN" then computes "f (... (f s i0)...) iN"
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val fold_left: ('a -> 'b -> 'a) -> 'a -> 'b[] -> 'a

    /// Compute f (get arr n) (...(f (get arr n) s))
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val fold_right: ('a -> 'b -> 'b) -> 'a[] -> 'b -> 'b

    /// Fetch the given element of the array, indexed by 0
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val get: 'a[] -> int -> 'a

    /// Build a new array whose elements are f 0, ... f N
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val init: int -> (int -> 'a) -> 'a[]

    /// Execute the given function for each element of the given array
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val iter: ('a -> unit) -> 'a[] -> unit

    /// Execute the given function for each element of the given array.  The integer
    /// index indicates the index of the element.
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val iteri: (int -> 'a -> unit) -> 'a[] -> unit

    /// The length of the array
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val length: 'a[] -> int

    /// Build a new array of the given length, each entry of which holds the given element.
    /// Same as create.
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val make: int -> 'a -> 'a[]

    /// Build a new array whose elements are the results of applying the given function
    /// to each of the elements of the array.
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val map: ('a -> 'b) -> 'a[] -> 'b []

    /// Build a new array whose elements are the results of applying the given function
    /// to each of the elements of the array. The integer
    /// index passed to the funciton indicates the index of the element.
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val mapi: (int -> 'a -> 'b) -> 'a[] -> 'b[]

    /// Build a .NET compatible array from the F# array.  Note that F# arrays and .NET
    /// compatible arrays are only different types when using .NET 1.0 or 1.1
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val of_array: 'a array -> 'a[]

    /// Convert the given list to a .NET compatible array suitable for passing to .NET functions
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val of_list: 'a list -> 'a[]

    /// Set the given element of the array
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val set: 'a[] -> int -> 'a -> unit

    /// Build a new .NET compatible array that contains the given subrange specified by
    /// starting index and length 
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val sub: 'a[] -> int -> int -> 'a[]

    /// Build an F# array from the given .NET compatible array.  Note that F# arrays and .NET
    /// compatible arrays are only different types when using .NET 1.0 or 1.1
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val to_array: 'a[] -> 'a array

    /// Convert the given .NET compatible array to a list
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val to_list: 'a[] -> 'a list

    /// Create a new array filled with zero (null or default) values.  Warning: Use of this
    /// function may result in subsequent exceptions if the elements of the array
    /// are accessed before initialized.
    [<System.Obsolete("The Microsoft.FSharp.Comatibility.CompatArray module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array module instead")>]
    val zero_create: int -> 'a[]

    #else

    /// Build a new array that contains the elements of the first array followed by the elements of the second array
    val inline append: $a[] -> $a[] -> $a[]

    /// Read a range of elements from the first array and write them into the second.
    val inline blit: $a[] -> int -> $a[] -> int -> int -> unit

    /// Build a new array that contains the elements of each of the given list of arrays
    val inline concat: $a[] list -> $a[]

    /// Build a new array that contains the elements of the given array
    val inline copy: $a[] -> $a[]

    /// Create a new array of the given length, each entry of which holds the given element
    val inline create: int -> $a -> $a[]

    /// Fill a range of an array with the given element
    val inline fill: $a[] -> int -> int -> $a -> unit

    /// Apply a function to each element of the collection, threading an 'accumulator' argument
    /// through the computation. If the elements are "i0...iN" then computes "f (... (f s i0)...) iN"
    val inline fold_left: ('a -> $b -> 'a) -> 'a -> $b[] -> 'a

    /// Compute f (get arr n) (...(f (get arr n) s))
    val inline fold_right: ($a -> 'b -> 'b) -> $a[] -> 'b -> 'b

    /// Fetch the given element of the array, indexed by 0
    val inline get: $a[] -> int -> $a

    /// Build a new array whose elements are f 0, ... f N
    val inline init: int -> (int -> $a) -> $a[]

    /// Execute the given function for each element of the given array
    val inline iter: ($a -> unit) -> $a[] -> unit


    /// Execute the given function for each element of the given array.  The integer
    /// index indicates the index of the element.
    val inline iteri: (int -> $a -> unit) -> $a[] -> unit

    /// The length of the array
    val inline length: $a[] -> int

    /// Build a new array of the given length, each entry of which holds the given element.
    /// Same as create.
    val inline make: int -> $a -> $a[]

    /// Build a new array whose elements are the results of applying the given function
    /// to each of the elements of the array.
    val inline map: ($a -> $b) -> $a[] -> $b []

    /// Build a new array whose elements are the results of applying the given function
    /// to each of the elements of the array. The integer
    /// index passed to the funciton indicates the index of the element.
    val inline mapi: (int -> $a -> $b) -> $a[] -> $b[]

    /// Build a .NET compatible array from the F# array.  Note that F# arrays and .NET
    /// compatible arrays are only different types when using .NET 1.0 or 1.1
    val inline of_array: $a array -> $a[]

    /// Convert the given list to a .NET compatible array suitable for passing to .NET functions
    val inline of_list: $a list -> $a[]

    /// Set the given element of the array
    val inline set: $a[] -> int -> $a -> unit

    /// Build a new .NET compatible array that contains the given subrange specified by
    /// starting index and length 
    val inline sub: $a[] -> int -> int -> $a[]

    /// Build an F# array from the given .NET compatible array.  Note that F# arrays and .NET
    /// compatible arrays are only different types when using .NET 1.0 or 1.1
    val inline to_array: $a[] -> $a array

    /// Convert the given .NET compatible array to a list
    val inline to_list: $a[] -> $a list

    /// Create a new array filled with zero (null or default) values.  Warning: Use of this
    /// function may result in subsequent exceptions if the elements of the array
    /// are accessed before initialized.
    val inline zero_create: int -> $a[]

    #endif
