// (c) Microsoft Corporation 2005-2007.  

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators

/// Simple operations to convert between .NET enuemration types and integers
[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Enum = 

    let to_int x = (unbox (box x) : int)
    let of_int (x:int) = (unbox (box x) : 'a)

    let rec combine_aux l  = 
      match l with
      | [] -> 0
      | h::t -> (to_int h) ||| (combine_aux t) 
    let combine (l : 'a list) = (of_int (combine_aux l) : 'a)
    let test (x : 'a) (y : 'a) = (to_int x) &&& (to_int y) <> 0
