
//-----------------------------------------------------------------------------
// File: Meshes.fs
//
// This is a translation of the Managed DirectX Tutorial 6 into F#
//
// Desc: For advanced geometry, most apps will prefer to load pre-authored
//       meshes from a file. Fortunately, when using meshes, D3DX does most of
//       the work for this, parsing a geometry file and creating vertx buffers
//       (and index buffers) for us. This tutorial shows how to use a D3DXMESH
//       object, including loading it from a file and rendering it. One thing
//       D3DX does not handle for us is the materials and textures for a mesh,
//       so note that we have to handle those manually.
//
//       Note: one advanced (but nice) feature that we don't show here is that
//       when cloning a mesh we can specify the FVF. So, regardless of how the
//       mesh was authored, we can add/remove normals, add more texture
//       coordinate sets (for multi-texturing), etc.
//
// Copyright (c) Microsoft Corporation 2005-2006.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 
//-----------------------------------------------------------------------------

#light 

open System
open System.Drawing
open System.Windows.Forms
open Microsoft.DirectX
open Microsoft.DirectX.Direct3D
open DirectXLib // dxlib.fs

let form = NewStandardForm("F# Direct3D Tutorial 6 - Meshes",400, 300)

let device = NewStandardDevice(form)

let renderers = 
    [ Clear(Color.Blue);
      ChangingWorldTransform(fun () -> Matrix.RotationY( time()  / 500.0f ));
      View(Matrix.LookAtLH( Vector3( 0.0f, 3.0f, -5.0f ),
                            Vector3( 0.0f, 0.0f, 0.0f ), 
                            Vector3( 0.0f, 1.0f, 0.0f ) ));
      Projection(Matrix.PerspectiveFovLH(PI / 4.0f, 1.0f, 1.0f, 100.0f ));
      RenderMeshDataFromFile("tiger.x") ]

// Run the main code. The attribute marks the startup application thread as "Single 
// Thread Apartment" mode, which is necessary for GUI applications. 
[<STAThread>]    
do RenderInLoop(form, device, renderers)
        

