// Copyright (c) Microsoft Corporation 2005-2007.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 
//

#light


module Microsoft.FSharp.Data.Linq

open Quotations
open Quotations.Typed
open System
open System.Linq
open System.Data.Linq
open System.Linq.Expressions
open System.Collections.Generic

type NDecimal = Nullable<System.Decimal>

val ( <>?! )       : Nullable< 'a> -> 'a -> bool          when 'a :> System.ValueType
val ( =?! )        : Nullable< 'a> -> 'a -> bool          when 'a :> System.ValueType
val ( <=?! )       : Nullable< 'a> -> 'a -> bool          when 'a :> System.ValueType
val ( <?!  )       : Nullable< 'a> -> 'a -> bool          when 'a :> System.ValueType
val ( >?!  )       : Nullable< 'a> -> 'a -> bool          when 'a :> System.ValueType
val ( >=?! )       : Nullable< 'a> -> 'a -> bool          when 'a :> System.ValueType
val inline ( +?! ) : Nullable< ^a> -> ^a -> Nullable< ^a> when ^a : (static member ( + ) : ^a * ^a -> ^a) and ^a :> System.ValueType
val inline ( -?! ) : Nullable< ^a> -> ^a -> Nullable< ^a> when ^a : (static member ( - ) : ^a * ^a -> ^a) and ^a :> System.ValueType
val inline ( *?! ) : Nullable< ^a> -> ^a -> Nullable< ^a> when ^a : (static member ( * ) : ^a * ^a -> ^a) and ^a :> System.ValueType
val inline ( /?! ) : Nullable< ^a> -> ^a -> Nullable< ^a> when ^a : (static member ( / ) : ^a * ^a -> ^a) and ^a :> System.ValueType


// Query experession and evaluation. Evaluate
// the given meta-program using SQL.
val SQL : Expr<'a> -> 'a





(*
module Query : begin
  
    val ( |> )     : 'a -> ('a -> 'b) -> 'b 
    
    val orderBy   : Expr<('a -> 'b)>    -> #IQueryable<'a>       -> IOrderedQueryable<'a>  
    val select    : Expr<('a -> 'b)>    -> #IQueryable<'a>       -> IQueryable<'b> 
    val first     : Expr<('a -> bool)>  -> #IQueryable<'a>       -> 'a 
    val take      : int                 -> #IQueryable<'a>       -> IQueryable<'a> 
    val min       :                       #IQueryable<'a>       -> 'a 
    val fmin      : Expr<('a -> 'b)>    -> #IQueryable<'a>       -> 'b                when 'b  :> IComparable<'b>
    val averagem  :                       #IQueryable<Decimal>  -> Decimal
    val averageNm :                       #IQueryable<NDecimal> -> NDecimal  
    val where     : Expr<'a -> bool>    -> #IQueryable<'a>       -> IQueryable<'a> 
    val distinct  :                       #IQueryable<'a>       -> IQueryable<'a> 
    val groupBy   : Expr<'a -> 'k>        -> #IQueryable<'a>       -> IQueryable<IGrouping<'k,'a>>
    val groupByAndProject 
                  : Expr<'a -> 'k>     -> 
                    Expr<'a -> 'v>     -> #IQueryable<'a>       -> IQueryable<IGrouping<'k,'v>> 

    val selectMany : ('a -> IEnumerable<'b>) Expr 
                                        -> #IQueryable<'a>       -> IQueryable<'b> 


    val iter      : ('a -> unit)       -> #IEnumerable<'a> -> unit 
    
end
*)
